/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.relation.web;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import org.hswebframework.web.authorization.annotation.Authorize;
import org.hswebframework.web.authorization.annotation.QueryAction;
import org.hswebframework.web.authorization.annotation.Resource;
import org.hswebframework.web.authorization.annotation.SaveAction;
import org.hswebframework.web.crud.web.reactive.ReactiveServiceCrudController;
import org.hswebframework.web.i18n.LocaleUtils;
import org.jetlinks.community.relation.configuration.RelationProperties;
import org.jetlinks.community.relation.entity.RelationEntity;
import org.jetlinks.community.relation.service.RelationService;
import org.jetlinks.community.relation.service.request.SaveRelationRequest;
import org.jetlinks.community.relation.service.response.RelatedInfo;
import org.jetlinks.community.web.response.ValidationResult;
import org.jetlinks.core.things.relation.ObjectType;
import org.jetlinks.core.things.relation.RelationManager;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"/relation"})
@Resource(id="relation", name="\u5173\u7cfb\u7ba1\u7406")
public class RelationController
implements ReactiveServiceCrudController<RelationEntity, String> {
    private final RelationProperties properties;
    private final RelationService service;
    private final RelationManager relationManager;

    @GetMapping(value={"/{type}/{id}/related"})
    @Operation(summary="\u67e5\u8be2\u6307\u5b9a\u7c7b\u578b\u6570\u636e\u7684\u5173\u7cfb\u4fe1\u606f")
    @QueryAction
    public Flux<RelatedInfo> getRelationInfo(@PathVariable String type, @PathVariable String id) {
        return this.service.getRelationInfo(type, id);
    }

    @PatchMapping(value={"/{type}/{id}/_bind"})
    @Operation(summary="\u4fdd\u5b58\u6307\u5b9a\u7c7b\u578b\u6570\u636e\u7684\u5173\u7cfb\u4fe1\u606f")
    @SaveAction
    public Mono<Void> saveRelation(@PathVariable String type, @PathVariable String id, @RequestBody Flux<SaveRelationRequest> requestFlux) {
        return this.service.saveRelated(type, id, requestFlux);
    }

    @GetMapping(value={"/types"})
    @Authorize(merge=false)
    @Operation(summary="\u83b7\u53d6\u6240\u6709\u7684\u5173\u7cfb\u5bf9\u8c61\u7c7b\u578b")
    public Flux<ObjectTypeInfo> getTypes() {
        return this.relationManager.getObjectTypes().map(type -> ObjectTypeInfo.of(type, this.properties.getRelatable(type.getId())));
    }

    @GetMapping(value={"/{type}/relations"})
    @Authorize(merge=false)
    @Operation(summary="\u83b7\u53d6\u6307\u5b9a\u7c7b\u578b\u7684\u5173\u7cfb\u5b9a\u4e49")
    public Flux<ObjectTypeInfo> getTypes(@PathVariable String type) {
        return this.relationManager.getObjectType(type).flatMapIterable(ObjectType::getRelatedTypes).map(_type -> ObjectTypeInfo.of(_type, this.properties.getRelatable(_type.getId())));
    }

    @GetMapping(value={"/_validate"})
    @QueryAction
    @Operation(summary="\u9a8c\u8bc1\u5173\u7cfb\u6807\u8bc6\u662f\u5426\u5408\u6cd5")
    public Mono<ValidationResult> relationValidate2(@RequestParam @Parameter(description="\u5bf9\u8c61\u7c7b\u578b") String objectType, @RequestParam @Parameter(description="\u5173\u7cfb\u6807\u8bc6") String relation, @RequestParam @Parameter(description="\u76ee\u6807\u5bf9\u8c61\u7c7b\u578b") String targetType) {
        return LocaleUtils.currentReactive().flatMap(locale -> {
            RelationEntity entity = new RelationEntity();
            entity.setObjectType(objectType);
            entity.setRelation(relation);
            entity.setTargetType(targetType);
            entity.generateId();
            return this.service.findById(entity.getId()).map(relationEntity -> ValidationResult.error((String)LocaleUtils.resolveMessage((String)"error.relation_ID_already_exists", (Object[])new Object[]{locale})));
        }).defaultIfEmpty((Object)ValidationResult.success());
    }

    public RelationController(RelationProperties properties, RelationService service, RelationManager relationManager) {
        this.properties = properties;
        this.service = service;
        this.relationManager = relationManager;
    }

    public RelationProperties getProperties() {
        return this.properties;
    }

    public RelationService getService() {
        return this.service;
    }

    public RelationManager getRelationManager() {
        return this.relationManager;
    }

    public static class ObjectTypeInfo {
        @Schema(description="\u7c7b\u578bID")
        private String id;
        @Schema(description="\u540d\u79f0")
        private String name;
        @Schema(description="\u8bf4\u660e")
        private String description;
        @Schema(description="\u53ef\u5efa\u7acb\u5173\u7cfb\u7684\u5176\u4ed6\u7c7b\u578bID")
        private List<String> relatable;

        public static ObjectTypeInfo of(ObjectType type, List<String> relatable) {
            ObjectTypeInfo info = new ObjectTypeInfo();
            info.setId(type.getId());
            info.setName(type.getName());
            info.setDescription(type.getDescription());
            info.setRelatable(relatable);
            return info;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public List<String> getRelatable() {
            return this.relatable;
        }

        public void setId(String id) {
            this.id = id;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public void setRelatable(List<String> relatable) {
            this.relatable = relatable;
        }
    }
}

