/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.relation.impl.property;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetlinks.community.relation.impl.property.PropertyOperationStrategy;
import org.jetlinks.core.things.relation.PropertyOperation;
import reactor.core.publisher.Mono;

public class DetectPropertyOperationStrategy
implements PropertyOperationStrategy {
    private final Map<String, PropertyOperation> mappers = new ConcurrentHashMap<String, PropertyOperation>();

    public DetectPropertyOperationStrategy addOperation(String key, PropertyOperation operation) {
        this.mappers.put(key, operation);
        return this;
    }

    @Override
    public boolean isSupported(String key) {
        return this.get(key) != Mono.empty();
    }

    public Mono<Object> get(String key) {
        String[] detect = this.detect(key);
        if (detect == null || detect.length == 0) {
            return Mono.empty();
        }
        PropertyOperation operation = this.mappers.get(detect[0]);
        if (null == operation) {
            return Mono.empty();
        }
        String relKey = detect.length == 1 ? detect[0] : detect[1];
        return operation.get(relKey);
    }

    protected String[] detect(String key) {
        if (key.contains(".")) {
            return key.split("[.]", 2);
        }
        return new String[]{key};
    }
}

