/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.relation.impl;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.hswebframework.ezorm.rdb.mapping.ReactiveQuery;
import org.hswebframework.ezorm.rdb.mapping.ReactiveRepository;
import org.hswebframework.web.exception.I18nSupportException;
import org.jetlinks.community.relation.RelationObjectProvider;
import org.jetlinks.community.relation.entity.RelatedEntity;
import org.jetlinks.community.relation.entity.RelationEntity;
import org.jetlinks.community.relation.impl.CompositeObjectType;
import org.jetlinks.community.relation.impl.DefaultRelationObject;
import org.jetlinks.community.relation.impl.SimpleObjectType;
import org.jetlinks.community.relation.impl.SimpleRelation;
import org.jetlinks.core.things.relation.ObjectType;
import org.jetlinks.core.things.relation.RelationManager;
import org.jetlinks.core.things.relation.RelationObject;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class DefaultRelationManager
implements RelationManager {
    private final ReactiveRepository<RelatedEntity, String> relatedRepository;
    private final ReactiveRepository<RelationEntity, String> relationRepository;
    protected final Map<String, RelationObjectProvider> providers = new ConcurrentHashMap<String, RelationObjectProvider>();

    public void addProvider(RelationObjectProvider provider) {
        this.providers.put(provider.getTypeId(), provider);
    }

    public Mono<ObjectType> getObjectType(String typeId) {
        RelationObjectProvider provider = this.getProvider(typeId);
        return provider.getType().flatMap(type -> ((ReactiveQuery)this.relationRepository.createQuery().where(RelationEntity::getObjectType, (Object)typeId)).fetch().collect(Collectors.groupingBy(RelationEntity::getTargetType, Collectors.mapping(SimpleRelation::of, Collectors.toList()))).map(group -> {
            SimpleObjectType custom = new SimpleObjectType(typeId, type.getName(), type.getDescription());
            for (Map.Entry entry : group.entrySet()) {
                custom.withRelation((String)entry.getKey(), (List)entry.getValue());
            }
            return new CompositeObjectType((ObjectType)type, custom);
        }).defaultIfEmpty(type));
    }

    public Flux<ObjectType> getObjectTypes() {
        return Flux.fromIterable(this.providers.values()).flatMap(RelationObjectProvider::getType);
    }

    public Mono<RelationObject> getObject(String objectType, String objectId) {
        if (!StringUtils.hasText((String)objectType) || !StringUtils.hasText((String)objectId)) {
            return Mono.empty();
        }
        return Mono.just((Object)new DefaultRelationObject(objectType, objectId, this.relatedRepository, this::getProvider));
    }

    public Flux<RelationObject> getObjects(String objectType, Collection<String> objectIds) {
        return Flux.fromIterable(objectIds).flatMap(id -> this.getObject(objectType, (String)id));
    }

    private RelationObjectProvider getProvider(String type) {
        RelationObjectProvider provider = this.providers.get(type);
        if (provider == null) {
            throw new I18nSupportException("error.unsupported_object_type", new Object[]{type});
        }
        return provider;
    }

    public DefaultRelationManager(ReactiveRepository<RelatedEntity, String> relatedRepository, ReactiveRepository<RelationEntity, String> relationRepository) {
        this.relatedRepository = relatedRepository;
        this.relationRepository = relationRepository;
    }
}

