/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.relation.entity;

import io.swagger.v3.oas.annotations.media.Schema;
import java.sql.JDBCType;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Table;
import org.hswebframework.ezorm.rdb.mapping.annotation.ColumnType;
import org.hswebframework.ezorm.rdb.mapping.annotation.DefaultValue;
import org.hswebframework.ezorm.rdb.mapping.annotation.JsonCodec;
import org.hswebframework.web.api.crud.entity.GenericEntity;
import org.hswebframework.web.crud.annotation.EnableEntityEvent;
import org.hswebframework.web.utils.DigestUtils;
import org.springframework.util.StringUtils;

@Table(name="s_object_relation")
@Schema(description="\u5bf9\u8c61\u5173\u7cfb\u5b9a\u4e49\u5b9e\u4f53")
@EnableEntityEvent
public class RelationEntity
extends GenericEntity<String> {
    @Schema(description="\u5bf9\u8c61\u7c7b\u578b")
    @Column(length=32, nullable=false, updatable=false)
    private String objectType;
    @Schema(description="\u5bf9\u8c61\u540d\u79f0")
    @Column(length=64, nullable=false)
    private String objectTypeName;
    @Schema(description="\u5173\u7cfb\u6807\u8bc6")
    @Column(length=32, nullable=false, updatable=false)
    private String relation;
    @Schema(description="\u5173\u7cfb\u540d\u79f0")
    @Column(length=64, nullable=false)
    private String name;
    @Schema(description="\u76ee\u6807\u5bf9\u8c61\u7c7b\u578b")
    @Column(length=32, nullable=false, updatable=false)
    private String targetType;
    @Schema(description="\u76ee\u6807\u5bf9\u8c61\u540d\u79f0")
    @Column(length=64, nullable=false)
    private String targetTypeName;
    @Column(nullable=false, updatable=false)
    @Schema(description="\u521b\u5efa\u65f6\u95f4")
    @DefaultValue(generator="current_time")
    private Long createTime;
    @Column
    @Schema(description="\u8bf4\u660e")
    private String description;
    @Column
    @JsonCodec
    @ColumnType(jdbcType=JDBCType.LONGVARCHAR, javaType=String.class)
    @Schema(description="\u5176\u4ed6\u62d3\u5c55\u4fe1\u606f")
    private Map<String, Object> expands;

    public String getId() {
        if (StringUtils.hasText((String)((String)super.getId()))) {
            return (String)super.getId();
        }
        if (StringUtils.hasText((String)this.objectType) && StringUtils.hasText((String)this.relation) && StringUtils.hasText((String)this.targetType)) {
            this.generateId();
        }
        return (String)super.getId();
    }

    public void generateId() {
        this.setId(DigestUtils.md5Hex((String)String.join((CharSequence)"|", this.objectType, this.relation, this.targetType)));
    }

    public RelationEntity from(String type, String name) {
        this.objectType = type;
        this.objectTypeName = name;
        return this;
    }

    public RelationEntity to(String type, String name) {
        this.targetType = type;
        this.targetTypeName = name;
        return this;
    }

    public RelationEntity relation(String relation, String name) {
        this.relation = relation;
        this.name = name;
        return this;
    }

    public String getObjectType() {
        return this.objectType;
    }

    public String getObjectTypeName() {
        return this.objectTypeName;
    }

    public String getRelation() {
        return this.relation;
    }

    public String getName() {
        return this.name;
    }

    public String getTargetType() {
        return this.targetType;
    }

    public String getTargetTypeName() {
        return this.targetTypeName;
    }

    public Long getCreateTime() {
        return this.createTime;
    }

    public String getDescription() {
        return this.description;
    }

    public Map<String, Object> getExpands() {
        return this.expands;
    }

    public void setObjectType(String objectType) {
        this.objectType = objectType;
    }

    public void setObjectTypeName(String objectTypeName) {
        this.objectTypeName = objectTypeName;
    }

    public void setRelation(String relation) {
        this.relation = relation;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setTargetType(String targetType) {
        this.targetType = targetType;
    }

    public void setTargetTypeName(String targetTypeName) {
        this.targetTypeName = targetTypeName;
    }

    public void setCreateTime(Long createTime) {
        this.createTime = createTime;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setExpands(Map<String, Object> expands) {
        this.expands = expands;
    }
}

