/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.dashboard.supports;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetlinks.community.dashboard.Measurement;
import org.jetlinks.community.dashboard.MeasurementDefinition;
import org.jetlinks.community.dashboard.MeasurementDimension;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class StaticMeasurement
implements Measurement {
    private MeasurementDefinition definition;
    private Map<String, MeasurementDimension> dimensions = new ConcurrentHashMap<String, MeasurementDimension>();

    public StaticMeasurement(MeasurementDefinition definition) {
        this.definition = definition;
    }

    public StaticMeasurement addDimension(MeasurementDimension dimension) {
        this.dimensions.put(dimension.getDefinition().getId(), dimension);
        return this;
    }

    @Override
    public Flux<MeasurementDimension> getDimensions() {
        return Flux.fromIterable(this.dimensions.values());
    }

    @Override
    public Mono<MeasurementDimension> getDimension(String id) {
        return Mono.justOrEmpty((Object)this.dimensions.get(id));
    }

    @Override
    public MeasurementDefinition getDefinition() {
        return this.definition;
    }
}

