/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.dashboard.supports;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.collections.CollectionUtils;
import org.jetlinks.community.dashboard.DashboardObject;
import org.jetlinks.community.dashboard.Measurement;
import org.jetlinks.community.dashboard.ObjectDefinition;
import org.jetlinks.community.dashboard.supports.CompositeMeasurement;
import org.jetlinks.community.dashboard.supports.MeasurementProvider;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class CompositeDashboardObject
implements DashboardObject {
    private ObjectDefinition definition;
    private List<MeasurementProvider> providers = new CopyOnWriteArrayList<MeasurementProvider>();

    CompositeDashboardObject() {
    }

    public void addProvider(MeasurementProvider provider) {
        if (this.definition == null) {
            this.definition = provider.getObjectDefinition();
        }
        this.providers.add(provider);
    }

    @Override
    public ObjectDefinition getDefinition() {
        return this.definition;
    }

    @Override
    public Flux<Measurement> getMeasurements() {
        return Flux.fromIterable(this.providers).flatMap(MeasurementProvider::getMeasurements);
    }

    @Override
    public Mono<Measurement> getMeasurement(String id) {
        return Flux.fromIterable(this.providers).flatMap(provider -> provider.getMeasurement(id)).collectList().filter(CollectionUtils::isNotEmpty).map(CompositeMeasurement::new);
    }
}

