/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.configure.trace;

import io.opentelemetry.exporter.jaeger.JaegerGrpcSpanExporter;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.export.BatchSpanProcessor;
import io.opentelemetry.sdk.trace.export.SimpleSpanProcessor;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.jetlinks.community.configure.trace.LoggingSpanExporter;
import org.jetlinks.core.trace.TraceHolder;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="trace")
public class TraceProperties {
    private boolean enabled = true;
    private Set<String> ignoreSpans;
    private Jaeger jaeger;
    private Logging logging = new Logging();

    public void setIgnoreSpans(Set<String> ignoreSpans) {
        this.ignoreSpans = ignoreSpans;
        for (String ignoreSpan : ignoreSpans) {
            TraceHolder.disable((String)ignoreSpan, (String)"sys-conf");
        }
    }

    public void setEnabled(boolean enabled) {
        if (enabled) {
            TraceHolder.enable();
        } else {
            TraceHolder.disable();
        }
        this.enabled = enabled;
    }

    public List<SpanProcessor> buildProcessors() {
        ArrayList<SpanProcessor> processors = new ArrayList<SpanProcessor>();
        if (this.jaeger != null && this.jaeger.isEnabled()) {
            processors.add(this.jaeger.create());
        }
        return processors;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public Set<String> getIgnoreSpans() {
        return this.ignoreSpans;
    }

    public Jaeger getJaeger() {
        return this.jaeger;
    }

    public Logging getLogging() {
        return this.logging;
    }

    public void setJaeger(Jaeger jaeger) {
        this.jaeger = jaeger;
    }

    public void setLogging(Logging logging) {
        this.logging = logging;
    }

    public static abstract class BatchProcessor {
        private boolean enabled = true;
        private String endpoint;
        private int maxBatchSize = 2048;
        private int maxQueueSize = 512;
        private Duration exporterTimeout = Duration.ofSeconds(30L);
        private Duration scheduleDelay = Duration.ofMillis(100L);

        protected abstract SpanExporter createExporter();

        public SpanProcessor create() {
            return BatchSpanProcessor.builder((SpanExporter)this.createExporter()).setScheduleDelay(100L, TimeUnit.MILLISECONDS).setMaxExportBatchSize(this.maxBatchSize).setMaxQueueSize(this.maxQueueSize).setExporterTimeout(this.exporterTimeout).build();
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public String getEndpoint() {
            return this.endpoint;
        }

        public int getMaxBatchSize() {
            return this.maxBatchSize;
        }

        public int getMaxQueueSize() {
            return this.maxQueueSize;
        }

        public Duration getExporterTimeout() {
            return this.exporterTimeout;
        }

        public Duration getScheduleDelay() {
            return this.scheduleDelay;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        public void setMaxBatchSize(int maxBatchSize) {
            this.maxBatchSize = maxBatchSize;
        }

        public void setMaxQueueSize(int maxQueueSize) {
            this.maxQueueSize = maxQueueSize;
        }

        public void setExporterTimeout(Duration exporterTimeout) {
            this.exporterTimeout = exporterTimeout;
        }

        public void setScheduleDelay(Duration scheduleDelay) {
            this.scheduleDelay = scheduleDelay;
        }
    }

    public static abstract class GrpcProcessor
    extends BatchProcessor {
        private String endpoint;
        private Duration timeout = Duration.ofSeconds(5L);

        @Override
        public String getEndpoint() {
            return this.endpoint;
        }

        public Duration getTimeout() {
            return this.timeout;
        }

        @Override
        public void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        public void setTimeout(Duration timeout) {
            this.timeout = timeout;
        }
    }

    public static class Jaeger
    extends GrpcProcessor {
        @Override
        protected SpanExporter createExporter() {
            return JaegerGrpcSpanExporter.builder().setEndpoint(this.getEndpoint()).setTimeout(this.getTimeout()).build();
        }
    }

    public static class Logging {
        private String name = "jetlinks.trace";

        public SpanProcessor create() {
            return SimpleSpanProcessor.create((SpanExporter)LoggingSpanExporter.create(this.name));
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

