/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.configure.doc;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.info.Contact;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.security.SecurityScheme;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import org.hswebframework.web.api.crud.entity.EntityFactory;
import org.hswebframework.web.crud.web.ResponseMessage;
import org.reactivestreams.Publisher;
import org.springdoc.core.ReturnTypeParser;
import org.springdoc.webflux.core.SpringDocWebFluxConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.MethodParameter;
import org.springframework.core.ResolvableType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Configuration
@AutoConfigureBefore(value={SpringDocWebFluxConfiguration.class})
public class SpringDocCustomizerConfiguration {
    @Bean
    public ReturnTypeParser operationCustomizer(final EntityFactory factory) {
        return new ReturnTypeParser(){

            public Type getReturnType(MethodParameter methodParameter) {
                ParameterizedType parameterizedType;
                Type rawType;
                Type type = super.getReturnType(methodParameter);
                if (type instanceof ParameterizedType && (rawType = (parameterizedType = (ParameterizedType)type).getRawType()) instanceof Class && Publisher.class.isAssignableFrom((Class)rawType)) {
                    Type actualType = parameterizedType.getActualTypeArguments()[0];
                    if (actualType instanceof ParameterizedType) {
                        actualType = ((ParameterizedType)actualType).getRawType();
                    }
                    if (actualType == ResponseEntity.class || actualType == ResponseMessage.class) {
                        return type;
                    }
                    boolean returnList = Flux.class.isAssignableFrom((Class)rawType);
                    return ResolvableType.forClassWithGenerics(Mono.class, (ResolvableType[])new ResolvableType[]{ResolvableType.forClassWithGenerics((Class)factory.getInstanceType(ResponseMessage.class), (ResolvableType[])new ResolvableType[]{returnList ? ResolvableType.forClassWithGenerics(List.class, (ResolvableType[])new ResolvableType[]{ResolvableType.forType((Type)parameterizedType.getActualTypeArguments()[0])}) : ResolvableType.forType((Type)parameterizedType.getActualTypeArguments()[0])})}).getType();
                }
                return type;
            }
        };
    }

    @Bean
    public OpenAPI customOpenAPI() {
        Contact contact = new Contact();
        contact.setName("eebd");
        OpenAPI openAPI = new OpenAPI().info(new Info().title("\u6863\u6848\u5e93\u623f\u667a\u6167\u76d1\u6d4b\u7edf\u4e00\u7ba1\u7406\u5e73\u53f0"));
        openAPI.schemaRequirement("Authorization", this.securityScheme());
        openAPI.addSecurityItem(new SecurityRequirement().addList("Authorization"));
        return openAPI;
    }

    private SecurityScheme securityScheme() {
        SecurityScheme securityScheme = new SecurityScheme();
        securityScheme.setType(SecurityScheme.Type.APIKEY);
        securityScheme.setName("X-Access-Token");
        securityScheme.setIn(SecurityScheme.In.HEADER);
        return securityScheme;
    }
}

