import { defineStore } from 'pinia';




/**
 * 用户信息
 * @methods setDeviceInfos
 */
export const useDeviceInfo = defineStore('deviceInfo', {
    state: () => ({
        deviceInfo: {
            name: '',
            code: '',
            serverAddr: '',
            custodian: '',
            brand: '',
            phone: '',
            tag: [""],
            imgUrl: '',
            communicationStatus: 0,
            runStatus: 0
        },
    }),

    actions: {
        updateDeviceInfo(type: Number) {
          if(type == 1921) {
            this.deviceInfo = {
              name: '精密空调',
              code: 'S2ER2',
              serverAddr: '6号楼1320xxxxxxxx',
              custodian: '张三',
              brand: '',
              phone: '028-xxx-xxx',
              tag: ["标签", "标签"],
              imgUrl: '/device-overview/jmkt.png',
              communicationStatus: 0,
              runStatus: 1
            }
          }
          if(type == 1911) {
            this.deviceInfo = {
              name: '恒湿一体机',
              code: 'S2ER2',
              serverAddr: '6号楼1320xxxxxxxx',
              custodian: '张三',
              brand: '',
              phone: '028-xxx-xxx',
              tag: ["标签", "标签"],
              imgUrl: '/device-overview/hsytj.png',
              communicationStatus: 0,
              runStatus: 1
            }
          }
          if(type == 1901) {
            this.deviceInfo = {
              name: '新风机',
              code: 'S2ER2',
              serverAddr: '6号楼1320xxxxxxxx',
              custodian: '张三',
              brand: '',
              phone: '028-xxx-xxx',
              tag: ["标签", "标签"],
              imgUrl: '/device-overview/xfj.png',
              communicationStatus: 0,
              runStatus: 1
            }
          }
          if(type == 1421) {
            this.deviceInfo = {
              name: '温湿度传感器',
              code: 'S2ER2',
              serverAddr: '6号楼1320xxxxxxxx',
              custodian: '张三',
              brand: '',
              phone: '028-xxx-xxx',
              tag: ["标签", "标签"],
              imgUrl: '/device-overview/wdcgq.png',
              communicationStatus: 0,
              runStatus: 1
            }
          }
          if(type == 1411) {
            this.deviceInfo = {
              name: '空气质量监测',
              code: 'S2ER2',
              serverAddr: '6号楼1320xxxxxxxx',
              custodian: '张三',
              brand: '',
              phone: '028-xxx-xxx',
              tag: ["标签", "标签"],
              imgUrl: '/device-overview/kqzljc.png',
              communicationStatus: 0,
              runStatus: 1
            }
          }
          if(type == 1401) {
            this.deviceInfo = {
              name: '漏水监测',
              code: 'S2ER2',
              serverAddr: '6号楼1320xxxxxxxx',
              custodian: '张三',
              brand: '',
              phone: '028-xxx-xxx',
              tag: ["标签", "标签"],
              imgUrl: '/device-overview/lsjc.png',
              communicationStatus: 0,
              runStatus: 1
            }
          }
          if(type == 1301) {
            this.deviceInfo = {
              name: '门禁一体机',
              code: 'S2ER2',
              serverAddr: '6号楼1320xxxxxxxx',
              custodian: '张三',
              brand: '',
              phone: '028-xxx-xxx',
              tag: ["标签", "标签"],
              imgUrl: '/device-overview/mj.png',
              communicationStatus: 0,
              runStatus: 1
            }
          }
          if(type == 1211) {
            this.deviceInfo = {
              name: '消防系统',
              code: 'S2ER2',
              serverAddr: '6号楼1320xxxxxxxx',
              custodian: '张三',
              brand: '',
              phone: '028-xxx-xxx',
              tag: ["标签", "标签"],
              imgUrl: '/device-overview/xfxt.png',
              communicationStatus: 0,
              runStatus: 1
            }
          }
          if(type == 1201) {
            this.deviceInfo = {
              name: '烟雾探测',
              code: 'S2ER2',
              serverAddr: '6号楼1320xxxxxxxx',
              custodian: '张三',
              brand: '',
              phone: '028-xxx-xxx',
              tag: ["标签", "标签"],
              imgUrl: '/device-overview/ywbj.png',
              communicationStatus: 0,
              runStatus: 1
            }
          }
        },
    },
});
