import { inject } from 'vue'
import type { InjectionKey } from 'vue'

export type ContextType<T> = any;

export const useContext = <T>(
    contextInjectKey: string | InjectionKey<ContextType<T>> = Symbol(),
    defaultValue?: ContextType<T>
): T => {
    return inject(contextInjectKey, defaultValue || ({} as T));
};