import Vue from 'vue'
import InfoWindowVue from '@/views/bigScreen/components/InfoWindow.vue' // 引入地图信息窗体
import markerbg from '@/views/bigScreen/img/roadtitbg.png'
export const mapMixin = {
    data() {
        return {
            map: null,
            bridgeCoordinateList: [], // 地图显示的桥梁坐标信息
            bridgeParams: {
                pageBean: {
                    pageSize: -1,
                },
            },
            massMarks: null, // 桥梁标记点
            markers: [],
            boundaryLineFace: [
                {
                    // 地图省份边界  layerIdl边界线 layerIdf 边界面
                    code: 'SC',
                    layerIdl: '20187ac7367e14034b8c19a40a33fe30',
                    layerIdf: '4394876460f6c3bd34d0615bf04cff47',
                },
                {
                    code: 'AH',
                    layerIdl: 'ef01a0169aaec81e77e9f0048ceb9713',
                    layerIdf: '3dde510c446230cbd4fdd15c5fb85416',
                },
                {
                    code: 'YN',
                    layerIdl: '06fc0230dad437e85d24600e06516587',
                    layerIdf: '031e5e61df73778bce2c2d82a4fc0a1c',
                },
                {
                    code: 'GZ',
                    layerIdl: '6c66cdbaddbcf839a529b03bcee23266',
                    layerIdf: 'd960ce4f0fe3eafeebf02a908e25910b',
                },
                {
                    code: 'CQ',
                    layerIdl: 'dfc9779a51de79b2eb40790f613964e2',
                    layerIdf: 'b37573d5d73f223aa5cf4293efeda3c0',
                },
                {
                    code: 'XJ',
                    layerIdl: 'b6f8c73b2d314bd6e091012fd7698e94',
                    layerIdf: '238a5e9de56faa7385873aaadf3ad67d',
                },
                {
                    code: 'HN',
                    layerIdl: '4edbe95e3ec8786276bb39ce7c42453f',
                    layerIdf: 'c1c5c040257326352d694528b7e33fac',
                },
            ],
            selectLineLayer: [], //已选择（已展示）的线路的id
            allRoadSections: [],
            filterRoadId: [],
            options: [],
            selectSingle: false, //地图跳转到指定路段
            markerDomListID: [],
            markerList: {},
            provinceMarker: [
                {
                    code: 'CQ',
                    zb: [107.569855, 30.367095],
                    id: "1430734631036129280",
                    zoom: 6.8//重庆
                },
                {
                    code: 'SC',
                    zb: [102.928995, 30.52487],
                    id: "1430710034819584000",
                    zoom: 5.8//四川
                },
                {
                    code: 'YN',
                    zb: [101.593103, 25.353375],
                    id: "1494140182780317696",
                    zoom: 6.1//云南
                },
                {
                    code: 'GZ',
                    zb: [106.641243, 27.10797],
                    id: "1497493237982695424",
                    zoom: 6.5//贵州
                },
                {
                    code: 'AH',
                    zb: [117.229929, 32.325398],
                    id: "AH",
                    zoom: 6.5//安徽
                }
            ]
        }
    },
    mounted() {
        // this.initMap() // 高德地图
        this.initMineMap() // MineMap 2D 地图
    },
    created() {
        // 获取路段坐标信息绘制路段
        // this.getRoadCoordinate()
        // 获取桥梁坐标信息标记桥梁位置
        // this.getBridgrCoordinate(this.bridgeParams)
    },
    methods: {

        // 加载mineMap2D地图
        initMineMap() {
            // 全局配置
            minemap.domainUrl = 'https://map.hope.cmet1965.com:58000' /* MineMap根域名地址 */
            /* MineMap矢量数据服务根域名地址 */
            minemap.dataDomainUrl = 'https://map.hope.cmet1965.com:58000'
            /* MineMap矢量数据服务新规范根域名地址 */
            minemap.serverDomainUrl = 'https://map.hope.cmet1965.com:58000'
            /* MineMap底图雪碧图地址 */
            minemap.spriteUrl = ['https://map.hope.cmet1965.com:58000/minemapapi/zsxz/zsxz'] // "./mapresource/sprite/sprite",
            /* MineMap后台服务根地址 */
            minemap.serviceUrl = 'https://map.hope.cmet1965.com:58000/service/'
            // minemap.spriteUrl = [
            //     "https://map.hope.cmet1965.com:58000/minemapapi/zsxz/zsxz",
            //     "./mapresource/sprite/sprite",
            // ];
            // 配置 key、solution
            minemap.key = '30be7831caf84685b94e78727e4ce25f'
            minemap.solution = 16932

            // 初始化地图实例
            this.map = new minemap.Map({
                container: 'map',
                style: 'https://map.hope.cmet1965.com:58000/service/solu/style/id/16932' /* 底图样式 */,
                center: [107.85585, 28.465908] /*地图中心点*/,
                zoom: 7 /*地图默认缩放等级*/,
                pitch: 0 /*地图俯仰角度*/,
                maxZoom: 17 /*地图最大缩放等级*/,
                minZoom: 3 /*地图最小缩放等级*/,
            })

            //   this.map.setLayoutProperty('30be7831caf84685b94e78727e4ce25f', "visibility", "none");

            this.map.on('load', () => {
                this.setHinight()

                // this.getRoadsLngLat()
                // 增加自定义数据源、自定义图层
                // this.addSources()
                // this.addLayers()
                // const layeyId = "linelayer" + '1493834264024846336' + 1;
                // this.map.moveLayer(layeyId, '42fecafad2b371617b5812498e2bba05') //千米桩
            })

        },
        //地图跳转
        jumpTo(priveId) {
            this.provinceMarker.forEach((item) => {
                if (priveId.length >= 2) {

                    if (item.id == priveId[1]) {
                        if (this.map) {
                            this.boundaryLineFace.forEach((el) => {
                                if (item.code == el.code) {
                                    this.map.setLayoutProperty(el.layerIdl, 'visibility', 'visible')
                                    this.map.setLayoutProperty(el.layerIdf, 'visibility', 'visible')
                                }
                                else {
                                    this.map.setLayoutProperty(el.layerIdl, 'visibility', 'none')
                                    this.map.setLayoutProperty(el.layerIdf, 'visibility', 'none')
                                }

                            })
                            // this.$emit('onLoad', this.map)
                        }
                        this.map.flyTo({
                            center: item.zb,
                            zoom: item.zoom,
                        });

                    }
                }
                if (priveId.length == 1 || priveId.length == 0) {
                    this.setHinight()
                    this.map.flyTo({
                        center: [107.85585, 28.465908],
                        zoom: 7,
                    })
                }

            })
        },
        //设置部分省份高亮
        setHinight() {
            if (this.map) {
                this.boundaryLineFace.forEach((el) => {
                    this.map.setLayoutProperty(el.layerIdl, 'visibility', 'visible')
                    this.map.setLayoutProperty(el.layerIdf, 'visibility', 'visible')
                })
                this.$emit('onLoad', this.map)
            }
        },
        //全国路段标注
        getRouteMarke() {
            let params = {
                groupRelation: "AND",
                groupTree: {},
                pageBean: {
                    page: 1,
                    pageSize: -1,
                    showTotal: true
                },
                params: {},
                querys: [

                ]

            }
            this.$http
                .post('${yhxt}/bizRoadMapPoint/v1/query', params)
                .then((res) => {
                    this.allRoadSections = res.data.rows || []
                    let Id = []
                    let test = []
                    this.getLastLevelIds(this.options[0]).forEach((item) => {
                        this.allRoadSections.forEach((ele) => {
                            test.push(ele.sectionId)
                            if (item == ele.sectionId) {
                                Id.push(ele)
                            }
                        })
                    })
                    // console.log('接口获取数组', test);

                    // console.log("全部数组", this.getLastLevelIds(this.options[0]));

                    // console.log("ID", Id);

                    if (Id.length) {
                        Id.forEach((item) => {
                            this.getAddLineLayer(item)
                            this.selectLineLayer.push(item.sectionId)
                        })
                        this.selectLineLayer = [...new Set(this.selectLineLayer)]
                        this.filterUniqueSectionIds(Id).forEach((item) => {


                            // this.selectLineLayer.push(item.sectionId)
                            // this.roadMarker(item)
                        })
                    }
                }
                )
        },
        //线路图层
        getAddLineLayer(item) {
            if (item && item.linePoints) {
                let linePoints = `[${item.linePoints}]`;
                linePoints = JSON.parse(linePoints);
                //       linesource/linelayer/symbolLayerId(数据源/线路/线路上的文字) + 路段id + dir（1是上行 2是下行）
                const sourceId = "linesource" + item.sectionId + item.dir;
                const layeyId = "linelayer" + item.sectionId + item.dir;
                const symbolLayerId = "linesymbollayer" + item.sectionId + item.dir;
                var jsonData = {
                    type: "FeatureCollection",
                    features: [
                        {
                            type: "Feature",
                            geometry: {
                                type: "LineString",
                                coordinates: linePoints,
                            },
                            properties: {
                                title: item.sectionName,
                                kind: item.sectionId,
                            },
                        },
                    ],
                };
                !this.map.getSource(sourceId) &&
                    this.map.addSource(sourceId, {
                        type: "geojson",
                        data: jsonData,
                    });

                let beforeIdtext = "";
                let beforeIdline = "";
                if (this.map.getLayer("point-outer-cluster-0")) {
                    // point-outer-cluster-0 是视频监控的聚合图层
                    beforeIdtext = "point-outer-cluster-0";
                    beforeIdline = "point-outer-cluster-0";
                }
                //  设置addLayer的第二个参数beforeId，表示这个图层显示在beforeId的图层下面
                // if (item.dir == 2) {
                //     beforeIdline = `linesymbollayer${item.sectionId}1`;
                // }
                // 线路图层
                !this.map.getLayer(layeyId) &&
                    this.map.addLayer(
                        {
                            id: layeyId,
                            type: "line",
                            source: sourceId,
                            layout: {
                                "line-join": "round",
                                "line-cap": "round",
                                "border-visibility": "visible", //是否开启线边框
                            },

                            paint: {
                                "line-width": 6,
                                "line-color": {
                                    type: "categorical",
                                    property: "kind",
                                    stops: [
                                        [1, "#7FAFFD"],
                                        [2, "#7FAFFD"],
                                    ],
                                    default: "#7FAFFD", //4DBCFA
                                },
                                "line-border-width": 1, //设置线边框宽度
                                "line-border-opacity": 0.5, //设置线边框透明度
                                "line-border-color": "#fff", //设置线边框颜色
                            },
                        },
                        beforeIdline
                    );
                //绘制线路图层
                // this.getAddTrafficLayer(item);
                //文字（高速路名称）图层
                !this.map.getLayer(symbolLayerId) &&
                    this.map.addLayer(
                        {
                            id: symbolLayerId,
                            type: "symbol",
                            source: sourceId,
                            layout: {
                                "text-field": "{title}",
                                "text-size": 14,
                                "symbol-placement": "line",
                            },
                            paint: {
                                "text-color": "#ffffff",
                                "text-halo-color": "#ffffff",
                                "text-halo-width": 0.3,
                            },
                        },
                        beforeIdtext
                    );
                if (this.isJump) {
                    const centerNum = Math.ceil(linePoints.length / 2);
                    let centerPoint = linePoints[centerNum];
                    this.provinceMarker.forEach((item) => {
                        if (item.id == this.setHinightId) {
                            this.setSingHiNight(item.code)
                        }
                    })
                    // if (setHinightId)
                    // this.provinceMarker.forEach((item) => {
                    //     this.boundaryLineFace.forEach((el) => {
                    //         if (item.id == this.setHinightId && item.code == el.code) {
                    //             console.log('1111111地图显示');

                    //             this.map.setLayoutProperty(el.layerIdl, 'visibility', 'visible')
                    //             // debugger
                    //             this.map.setLayoutProperty(el.layerIdf, 'visibility', 'visible')
                    //         }
                    //         else {
                    //             this.map.setLayoutProperty(el.layerIdl, 'visibility', 'none')
                    //             this.map.setLayoutProperty(el.layerIdf, 'visibility', 'none')
                    //         }
                    //     })
                    // })
                    // 跳转至该线路
                    this.map.flyTo({
                        center: centerPoint,
                        zoom: 9,
                    });
                }
                // const qmz = JSON.parse(localStorage.getItem("mapCLkmz"));
                // this.map.moveLayer(layeyId, 'b5ebe9f4b52d23fb83170b4936b56429') //千米桩
                this.map.moveLayer(layeyId, '1c846138267b20d808d1bd5af60e2388'); //千米桩
                this.map.moveLayer(layeyId, '1947a40c8039e9ade6ac855124b0403d'); //百米桩
            }

        },
        setSingHiNight(code) {
            this.boundaryLineFace.forEach((item) => {
                this.map.setLayoutProperty(item.layerIdl, 'visibility', 'none')
                this.map.setLayoutProperty(item.layerIdf, 'visibility', 'none')
            })
            this.boundaryLineFace.forEach((item) => {
                if (item.code == code) {
                    console.log('地图高亮设置', item);

                    this.map.setLayoutProperty(item.layerIdl, 'visibility', 'visible')
                    this.map.setLayoutProperty(item.layerIdf, 'visibility', 'visible')
                }
                else {
                    this.map.setLayoutProperty(item.layerIdl, 'visibility', 'none')
                    this.map.setLayoutProperty(item.layerIdf, 'visibility', 'none')
                }
            })

        },
        //id去重
        filterUniqueSectionIds(array) {
            const seenSectionIds = new Set();
            const result = [];

            array.forEach(item => {
                if (!seenSectionIds.has(item.sectionId)) {
                    seenSectionIds.add(item.sectionId);
                    result.push(item);
                }
            });

            return result;
        },
        // 路段上浮起来的路段名
        roadMarker(item) {
            if (item && item.linePoints) {
                const linePoints = JSON.parse(`[${item.linePoints}]`);
                const zj = parseInt(linePoints.length / 2);
                const langlat = linePoints[zj];
                //大的marker
                var el = document.createElement("div");
                const w = item.sectionName.length * 16;
                el.id = "marker" + item.sectionId;
                // el.addClass("rodeMarkerDiv")
                el.className = "rodeMarkerDiv";
                el.style["background-image"] = `url(${markerbg})`;
                el.style["background-size"] = `100% 100%`;
                el.style["padding"] = "6px 0";
                el.style["height"] = "74px";
                el.style["width"] = w + "px";
                el.style["text-align"] = "center";
                el.style["font-size"] = "16px";

                var spn = document.createElement("span");
                spn.innerHTML = item.sectionName;
                spn.style["color"] = "#fff";
                spn.style["font-style"] = "italic";
                el.appendChild(spn);

                //小的marker
                var el1 = document.createElement("div");
                const w1 = item.sectionName.length * 12;
                el1.id = "marker" + item.sectionId;
                // el.addClass("rodeMarkerDiv")
                el1.className = "rodeMarkerDiv1";
                el1.style["background-image"] = `url(${markerbg})`;
                el1.style["background-size"] = `100% 100%`;
                el1.style["padding"] = "0";
                el1.style["height"] = "45px";
                el1.style["width"] = w1 + "px";
                el1.style["text-align"] = "center";
                el1.style["font-size"] = "12px";

                var spn1 = document.createElement("span");
                spn1.innerHTML = item.sectionName;
                spn1.style["color"] = "#fff";
                spn1.style["font-style"] = "italic";

                el1.appendChild(spn1);
                // el.style.display = "none";
                el1.style.display = "block";
                //全国显示小图标 否则显示大图标
                // if (this.$store.state.road.selectRoadId) {
                //     el.style.display = "none";
                //     el1.style.display = "block";
                // } else {
                //     el.style.display = "block";
                //     el1.style.display = "none";
                // }

                const halfw = 0 - w / 2;
                const halfw1 = 0 - w1 / 2;
                // var marker = new minemap.Marker(el, { offset: [halfw, -70] })
                //     .setLngLat(langlat)
                //     .addTo(this.map);
                var marker1 = new minemap.Marker(el1, { offset: [halfw1, -40] })
                    .setLngLat(langlat)
                    .addTo(this.map);
                // this.markerList["marker" + item.sectionId] = marker;
                this.markerList["marker1" + item.sectionId] = marker1;
                // this.markerDomListID.push(el);
                this.markerDomListID.push(el1);
            }
        },

        // 地图上标记点
        markPoint(iconSize) {
            let style = [
                {
                    url: require('../img/blue_icon.png'),
                    anchor: new AMap.Pixel(6, 6),
                    size: new AMap.Size(iconSize, iconSize),
                },
                {
                    url: require('../img/yellow_icon.png'),
                    anchor: new AMap.Pixel(6, 6),
                    size: new AMap.Size(iconSize, iconSize),
                },
                {
                    url: require('../img/red_icon_point.png'),
                    anchor: new AMap.Pixel(6, 6),
                    size: new AMap.Size(iconSize, iconSize),
                },
                // {
                //   url: require('../img/cyan-icon.png'),
                //   anchor: new AMap.Pixel(6, 6),
                //   size: new AMap.Size(iconSize, iconSize),
                // },
            ]

            let mass = new AMap.MassMarks(null, {
                opacity: 1,
                zIndex: 111,
                zooms: [3, 19],
                cursor: 'pointer',
                style: style,
            })
            mass.setData(this.bridgeCoordinateList)
            this.massMarks = mass

            let marker = new AMap.Marker({ content: ' ', map: this.map })

            let infoWindow = new AMap.InfoWindow({})

            mass.on('click', (e) => {
                marker.setPosition(e.data.lnglat)
                this.createInfoWindow(infoWindow, e.data)
            })

            mass.setMap(this.map)
            //   this.createInfoWindow(infoWindow, this.bridgeCoordinateList[0])
        },
        // 创建信息窗体
        createInfoWindow(infoWindow, data) {
            let Content = Vue.extend({
                template: '<info-window-vue :infoData=data />',
                name: 'infoWindow',
                components: {
                    'info-window-vue': InfoWindowVue,
                },
                data() {
                    return {
                        data,
                    }
                },
            })

            let component = new Content().$mount()
            infoWindow.setContent(component.$el)
            infoWindow.open(this.map, data.lnglat)
            Vue.prototype.infoWindow = infoWindow
        },
        // 桥梁列表数据得到具体坐标位置
        getBridgrCoordinate(params) {
            this.$http
                .post('${yhxt}/bizBridgeInformation/v1/getJson', params)
                .then((res) => {
                    let data = res.data.rows || []
                    let list = []
                    data.forEach((i) => {
                        if (i.lng && i.lat) {
                            list.push({
                                lnglat: [i.lng, i.lat],
                                style: 3,
                                ...i,
                            })
                        }
                    })
                    this.bridgeCoordinateList = list
                    // 添加点标记
                    console.log("桥梁数据", this.bridgeCoordinateList);

                    this.markPoint(30)
                })
        },
        cleatMarker() {
            this.markers.forEach((item) => {
                item.remove()
                item = null
            })
            this.markers = []
        },
        // minemap 方法
        minemapMarker() {
            // type字段：1：悬索桥  2：斜拉桥  3：梁桥  4：拱桥
            let img = [
                require('../img/icon-bridge-1.png'),
                require('../img/icon-bridge-2.png'),
                require('../img/icon-bridge-3.png'),
                require('../img/icon-bridge-4.png'),
            ]
            // state字段：1：基本完好 2：轻微异常 3：中等异常 4：严重异常
            let img2 = [
                require('../img/icon-point-1.png'),
                require('../img/icon-point-2.png'),
                require('../img/icon-point-3.png'),
                require('../img/icon-point-4.png'),
            ]

            this.bridgeCoordinateList.forEach((item) => {
                // 创建窗体
                // let Content = Vue.extend({
                //   template: '<info-window-vue :infoData=item />',
                //   name: 'infoWindow',
                //   components: {
                //     'info-window-vue': InfoWindowVue,
                //   },
                //   data() {
                //     return {
                //       item,
                //     }
                //   },
                // })

                // 创建div作为标记点
                let el = document.createElement('div')
                el.className = 'map-point'

                let p1 = document.createElement('div');
                p1.className = 'text-box text-box-bg-' + item.state
                p1.innerHTML = item.bridgeName

                let p2 = document.createElement('div');
                p2.className = 'icon-box icon-point-' + item.state

                let p3 = document.createElement('div');
                p3.className = 'icon-bridge icon-bridge-' + item.type

                p2.appendChild(p3);
                el.appendChild(p1);
                el.appendChild(p2);

                // el.id = 'marker'
                // el.style['background-size'] = 'cover'
                // el.style.width = '60px'
                // el.style.height = '60px'
                // el.style['background-image'] = `url(${img2[item.style]})`
                // 标记点位
                let marker = new minemap.Marker(el, { offset: [-10, -10] }).setLngLat(item.lnglat).addTo(this.map)
                this.markers.push(marker)
                // 添加点击事件
                el.addEventListener('click', () => {
                    this.$refs.infoDialog.open(item)
                    //   let component = new Content().$mount().$el
                    //   let popup = new minemap.Popup({
                    //     closeOnClick: true,
                    //     closeButton: true,
                    //     offset: [0, 0],
                    //     anchor: 'top',
                    //   }).setDOMContent(component)
                    //   //panTo方法，以动画的形式将地图的中心位置平移到参数中的目标坐标点，参数为地图坐标点
                    //   this.map.panTo([item.lnglat[0], item.lnglat[1] - 1])
                    //   marker.setPopup(popup)
                })





            })
        },



        //路段过滤
        getLastLevelIds(orgData) {
            let lastLevelIds = []

            function recurse(items) {
                items.forEach((item) => {
                    // 如果当前项没有子项，说明它是最后一层
                    if (!item.chirldren) {
                        lastLevelIds.push(item.id)
                    } else {
                        // 如果有子项，递归遍历子项
                        recurse(item.chirldren)
                    }
                })
            }


            recurse(orgData.chirldren)
            return lastLevelIds
        },
        loadData() {
            this.$http.get('${yhxt}/road/roadmanage/v1/roadTree').then((res) => {
                let data = (res && res.status == 200 && res.data) || []
                this.deepSetChildren(data) // 设置路段的children为null
                this.options = [
                    {
                        isDelete: '0',
                        id: '1419863231459102720',
                        name: '全国',
                        parentId: '0',
                        code: '10',
                        grade: '1',
                        orgKind: 'ogn',
                        demId: '1258608622670319616',
                        orderNo: 145,
                        isMaster: 0,
                        path: '1258608622670319616.1419863231459102720.',
                        pathName: '/中铁建昆仑投资集团',
                        limitNum: 0,
                        exceedLimitNum: 0,
                        disabled: false,
                        chirldren: data,
                    },
                ]
                this.getRouteMarke()
                // this.filterRoadId = this.getLastLevelIds(this.options[0])
                // console.log('this.option', this.getLastLevelIds(this.options[0]))
                // console.log('this.options', this.options)
            })
        },
        deepSetChildren(data) {
            data.forEach((i) => {
                let child = i.chirldren
                if (child && child.length !== 0) {
                    return this.deepSetChildren(child)
                } else {
                    i.chirldren = null
                }
            })
            return data
        },
        selectedRoadList(list) {

            let lastLevelIds = []

            function recurse(items) {
                items.forEach((item) => {
                    // 如果当前项没有子项，说明它是最后一层
                    if (!item.children.length || !item.children) {
                        lastLevelIds.push(item.data.id)
                    } else {
                        // 如果有子项，递归遍历子项
                        recurse(item.children)
                    }
                })
            }

            if (list.children.length) {
                recurse(list.children)
            }
            else {
                lastLevelIds = [list.data.id]
            }
            this.clearRoadLayer()
            this.selectLineLayer = lastLevelIds
            this.selectLineLayer.forEach((item => {
                let url = '${yhxt}' + `/bizRoadMapPoint/v1/road/${item}`
                this.$http.get(url).then((res) => {
                    this.getAddLineLayer(res.data)
                    // this.roadMarker(res.data)

                })
            }))
            return lastLevelIds


        },
        //路图层清除
        clearRoadLayer() {
            //清除已有的线路的图层和路况
            if (this.selectLineLayer.length > 0) {
                for (
                    let index = 0;
                    index < this.selectLineLayer.length;
                    index++
                ) {
                    const sid = this.selectLineLayer[index];
                    this.map.getSource("linesource" + sid + "1") &&
                        this.map.removeSource("linesource" + sid + "1");
                    this.map.getSource("linesource" + sid + "2") &&
                        this.map.removeSource("linesource" + sid + "2");
                    this.map.getLayer("linelayer" + sid + "1") &&
                        this.map.removeLayer("linelayer" + sid + "1");
                    this.map.getLayer("linelayer" + sid + "2") &&
                        this.map.removeLayer("linelayer" + sid + "2");
                    this.map.getLayer("linesymbollayer" + sid + "1") &&
                        this.map.removeLayer("linesymbollayer" + sid + "1");
                    this.map.getLayer("linesymbollayer" + sid + "2") &&
                        this.map.removeLayer("linesymbollayer" + sid + "2");
                    // if (this.selectSingle) {
                    //     // this.markerList["marker" + sid].remove();
                    //     this.markerList["marker1" + sid].remove();
                    // }
                    if (this.markerList["marker1" + sid]) {
                        this.markerList["marker1" + sid].remove()
                    }

                    // console.log('this.mar--->>>', this.markerList["marker1" + sid]);

                }
            }
            this.selectLineLayer = []
            this.markerDomListID = []
        }
    },
}
