import utils from '@/utils.js'
import * as echarts from 'echarts'
export const mixin = {
    data() {
        return {
            params: {
                pageBean: {
                    pageSize: -1,
                },
                querys: [],
            },
            // 桥梁健康统计饼图配置
            brigeHealthConfig: {
                legend: {
                    top: '5%',
                    left: 'center',
                    textStyle: {
                        color: '#fff',
                    },
                },
                color: ['#ff9a00', '#00cbd7', '#0283fc', '#5e5eff'],
                tooltip: {
                    trigger: 'item',
                    formatter: '{b}\n{c}',
                },
                series: {
                    radius: ['35%', '50%'],
                    emphasis: {
                        label: {
                            show: true,
                        },
                    },
                    label: {
                        formatter: (a) => {
                            if (a.value) {
                                return a.name + ' ' + a.value
                            }
                        }, // '{b}\n{c}',
                        show: true,
                        color: '#fff',
                        fontSize: 16,
                    },
                    labelLine: {
                        show: true,
                    },
                },
            },
            // 未处置预警事件信息统计
            untreatedInfo: {
                titleList: [
                    {
                        key: 'tpBridgeName',
                        name: '桥梁名称',
                    },
                    {
                        key: 'eventsDate',
                        name: '预警时间',
                        color: 'green',
                    },
                    {
                        key: 'warnType',
                        name: '预警类型',
                        color: 'red',
                    },
                    {
                        key: 'eventsDescribe',
                        name: '预警信息',
                    },
                ],
                listData: [
                    {
                        name: '林家院子中桥',
                        value: '50',
                        value1: '20',
                        info: '车辆载荷',
                    },
                    {
                        name: '石匣子中桥',
                        value: '50',
                        value1: '20',
                        info: '风速/风向',
                    },
                    {
                        name: '郭家岩大桥',
                        value: '50',
                        value1: '20',
                        info: '结构温度',
                    },
                    {
                        name: '响水洞大桥',
                        value: '50',
                        value1: '20',
                        info: '车辆载荷',
                    },
                    {
                        name: '潼南互通桥',
                        value: '50',
                        value1: '20',
                        info: '钢结构温度',
                    },
                ],
            },
            deviceInfo: {}, // 设备信息统计
            // 设备基础信息统计
            deviceBasicInfo: {
                titleList: [
                    { key: 'bridgeName', name: '名称' },
                    { key: 'roadSegmentName', name: '路线' },
                    { key: 'type', name: '上下行' },
                    { key: 'state', name: '健康状态', color: 'green' },
                ],
                listData: [],
                loading: false,
            },
            bridgeAbnormalCount: {}, // 桥梁健康统计
            warningTotal: [], // 预警事件统计

            /* 2024年2月27日修改 */
            bridgeStatus: {
                titleList: [
                    { key: 'sn', name: '序号' },
                    { key: 'bridgeName', name: '桥梁' },
                    { key: 'device', name: '故障设备' },
                    { key: 'state', name: '健康状态', color: 'green' },
                ],
                listData: [
                    {
                        sn: 1,
                        bridgeName: '长冲大桥',
                        device: 20,
                        state: 4,
                    },
                    {
                        sn: 2,
                        bridgeName: '长岗岭1号大桥',
                        device: 15,
                        state: 3,
                    },
                    {
                        sn: 3,
                        bridgeName: '李家湾大桥',
                        device: 10,
                        state: 2,
                    },
                    {
                        sn: 4,
                        bridgeName: '郁江河特大桥',
                        device: 2,
                        state: 1,
                    },
                    {
                        sn: 5,
                        bridgeName: '涪江大桥',
                        device: 20,
                        state: 1,
                    },
                ],
                loading: false,
            },
            devicePieChart: null,
            devicePieData: [
                {
                    name: '在线设备',
                    value: 102,
                    ratio: 75,
                },
                {
                    name: '离线设备',
                    value: 34,
                    ratio: 25,
                },
            ],
            devicePieOption: null,
            curIndex: 0,
            devicePiecurIndex: 0,
            alarmInfoData: [
                {
                    id: 1,
                    bridgeName: '涪陵大桥',
                    hitchDate: '2023-02-01 10:00:12',
                    hitchReason: '数据传输异常',
                },
                {
                    id: 2,
                    bridgeName: '涪陵大桥',
                    hitchDate: '2023-02-01 10:00:12',
                    hitchReason: '数据传输异常',
                },
                {
                    id: 3,
                    bridgeName: '涪陵大桥',
                    hitchDate: '2023-02-01 10:00:12',
                    hitchReason: '数据传输异常',
                },
                {
                    id: 4,
                    bridgeName: '涪陵大桥',
                    hitchDate: '2023-02-01 10:00:12',
                    hitchReason: '数据传输异常',
                },
                {
                    id: 5,
                    bridgeName: '涪陵大桥',
                    hitchDate: '2023-02-01 10:00:12',
                    hitchReason: '数据传输异常',
                },
            ], // 报警信息数据
            loadObj: {
                scrollFaultData: false,
            },
            loadingColor: 'rgba(6, 46, 106, 0.01)',
            axleloadInfo: {
                titleList: [
                    { key: 'bridgeName', name: '桥梁' },
                    { key: 'prop1', name: '车流量(每天)' },
                    { key: 'prop2', name: '超重车数量' },
                    { key: 'prop3', name: '最大总重量' },
                ],
                listData: [
                    {
                        bridgeName: '长冲大桥',
                        prop1: 20,
                        prop2: 10,
                        prop3: 10,
                    },
                    {
                        bridgeName: '长岗岭1号大桥',
                        prop1: 16,
                        prop2: 8,
                        prop3: 8,
                    },
                    {
                        bridgeName: '李家湾大桥',
                        prop1: 16,
                        prop2: 10,
                        prop3: 8,
                    },
                    {
                        bridgeName: '涪江大桥',
                        prop1: 20,
                        prop2: 14,
                        prop3: 11,
                    },
                    {
                        bridgeName: '郁江河特大桥',
                        prop1: 15,
                        prop2: 12,
                        prop3: 5,
                    },
                ],
            }, // 轴载感知统计数据
            alarmInfoBar: [
                [25, 35, 35, 25, 35],
                [30, 30, 30, 30, 25],
                [10, 13, 15, 13, 15],
            ], // 告警信息分析
            bridgeTotal: 0,//桥梁总数
            warningTotalNumber: 0//处置事件总数
        }
    },
    created() {
        // 获取基础信息统计 - 桥梁类型统计
        this.getBridgeData(this.params)
        // 获取基础信息统计 - 监测设备类型统计
        this.getDeviceCount(this.params)
        // 获取设备信息统计
        this.getDeviceCountTotal(this.params)
        // 获取设备基础信息统计
        this.getDeviceTypeCount(this.params)
        // 获取桥梁健康统计
        this.getBridgeAbnormalCount(this.params)
        // 获取预警事件统计
        this.getWarningCountTotal(this.params)
        // 获取未处置预警统计
        this.getNotDisposedWarn(this.params)
    },
    computed: {
        optionSingleHeightTime() {
            return {
                step: 0.2,
            }
        },
    },
    mounted() {
        // this.drawDevicePieChart()
    },
    methods: {
        // 获取某一个月最后一天
        getLastDay(year, month) {
            const date1 = new Date(year, month, 0)
            return date1.getDate()
        },
        // 获取顶部搜索参数数据组装为查询条件
        getSearchParams() {
            let obj = this.searchForm
            let querys = []
            for (let i in obj) {
                if (obj[i]) {
                    // 年月日处理
                    if (i == 'issueDate') {
                        querys.push(
                            {
                                group: 'main',
                                operation: 'GREAT',
                                property: 'modelDateGreat',
                                relation: 'AND',
                                value: obj[i][0],
                            },
                            {
                                group: 'main',
                                operation: 'LESS',
                                property: 'modelDateLess',
                                relation: 'AND',
                                value: obj[i][1],
                            }
                        )
                    } else {
                        querys.push({
                            group: 'main',
                            operation: 'EQUAL',
                            property: i,
                            relation: 'AND',
                            value: obj[i],
                        })
                    }
                }
            }
            return querys || []
        },
        // 左侧基础信息统计 - 获取桥梁类型统计
        getBridgeData(params) {
            this.$http
                .post('${yhxt}/bizTpBridge/v1/getBridgeCount', params)
                .then((res) => {
                    let data = res.data || {}
                    this.basicList[0].children[0].num = data.suspensionCount // 悬索桥
                    this.basicList[0].children[1].num = data.cableStayedCount // 斜拉桥
                    this.basicList[0].children[2].num = data.girderCount // 梁桥
                    this.basicList[0].children[3].num = data.archCount // 拱桥
                    this.bridgeTotal =
                        Number(data.suspensionCount) +
                        Number(data.cableStayedCount) +
                        Number(data.girderCount) +
                        Number(data.archCount)

                    // 判断查询桥梁类型数据，在地图上显示有数据的桥梁类型
                    // let list = this.basicList[0].children
                    // for (let i in list) {
                    //     if (list[i].num != 0) {
                    //         this.handleClick(list[i])
                    //         return
                    //     }
                    // }
                })
        },
        // 左侧基础信息统计 - 监测设备类型统计
        getDeviceCount(params) {
            this.$http
                .post('${yhxt}/bizTpDevice/v1/getDeviceCount', params)
                .then((res) => {
                    let data = res.data || {}
                    this.deviceList[0].children[0].num = data.vibeCount // 环境设备数量
                    this.deviceList[0].children[1].num = data.motiveCount // 作用设备数量
                    this.deviceList[0].children[2].num = data.structuralCount // 结构响应设备数量
                    this.deviceList[0].children[3].num = data.varyCount // 结构变化数量
                })
        },
        // 获取设备信息统计
        getDeviceCountTotal(params) {
            this.$http
                .post('${yhxt}/bizTpDevice/v1/deviceCountTotal', params)
                .then((res) => {
                    let data = res.data || {}
                    this.deviceInfo = data
                    this.devicePieData[0].value = data.onlineCount
                    this.devicePieData[0].ratio = parseFloat(
                        (data.onlineCount / data.total) * 100
                    ).toFixed(2)
                    this.devicePieData[1].value = data.offlineCount
                    this.devicePieData[1].ratio = parseFloat(
                        (data.offlineCount / data.total) * 100
                    ).toFixed(2)
                })
        },
        getDeviceTypeDetail(item) {
            let params = {
                pageBean: {
                    page: 1,
                    pageSize: -1,
                },
                querys: [
                    {
                        group: 'main',
                        operation: 'EQUAL',
                        property: 'detailTypeName',
                        relation: 'AND',
                        value: item.name,
                    },
                ],
                sorter: [
                    {
                        direction: 'ASC',
                        property: 'trBridgeId',
                    },
                    {
                        direction: 'ASC',
                        property: 'deviceCode',
                    },
                ],
            }
            if (this.activeBridgeId) {
                params.querys.push({
                    group: 'main',
                    operation: 'EQUAL',
                    property: 'tpBridgeId',
                    relation: 'AND',
                    value: this.activeBridgeId,
                })
            }
            this.$http.post('${yhxt}' + '/bizTpDevice/v1/pageVo', params).then((res) => {
                this.deviceDetailData = []
                let data = res.data || {}
                if (data.rows) {
                    this.deviceDetailData = data.rows
                }
                this.$refs.detailDialog.open(item, this.deviceDetailData)
            })
        },

        // 获取设备基础信息统计
        getDeviceTypeCount(params, type) {
            params = utils.deepClone(params)
            if (params.querys.length == 0) {
                params.querys = [
                    // {
                    //     group: 'main',
                    //     operation: 'EQUAL',
                    //     property: 'TYPE_',
                    //     relation: 'AND',
                    //     value: 1,
                    // },
                ]
            }
            let url = '/bizTpBridge/v1/pageVo'
            this.deviceBasicInfo.titleList = [
                { key: 'bridgeName', name: '名称' },
                { key: 'roadSegmentName', name: '路线' },
                { key: 'directionValue', name: '上下行' },
                { key: 'state', name: '健康状态', color: 'green' },
            ]
            if (type && type > 4) {
                url = '/bizTpDevice/v1/getDeviceTypeCount'
                this.deviceBasicInfo.titleList = [
                    { key: 'name', name: '类型' },
                    { key: 'total', name: '数量' },
                    { key: 'onlineCount', name: '在线' },
                    { key: 'offlineCount', name: '离线', color: 'red' },
                ]
                if (this.activeBridgeId) {
                    params.querys.push({
                        group: 'main',
                        operation: 'EQUAL',
                        property: 'TP_BRIDGE_ID_',
                        relation: 'AND',
                        value: this.activeBridgeId,
                    })
                }
            }
            this.deviceBasicInfo.loading = true
            this.$http.post('${yhxt}' + url, params).then((res) => {
                this.deviceBasicInfo.loading = false
                if (type && type > 4) {
                    this.deviceBasicInfo.listData = []
                    let data = res.data || {}
                    for (let i in data) {
                        this.deviceBasicInfo.listData.push({
                            name: i,
                            ...data[i],
                        })
                    }
                } else {
                    let data = res.data.rows || []
                    this.deviceBasicInfo.listData = data
                    // 标记桥梁位置
                    let list = []
                    data.forEach((i) => {
                        if (i.lng && i.lat) {
                            list.push({
                                lnglat: [i.lng, i.lat],
                                style: 0,
                                ...i,
                            })
                        }
                    })
                    this.bridgeCoordinateList = list
                    this.minemapMarker()
                }
            })
        },
        // 获取桥梁健康统计
        getBridgeAbnormalCount(params) {
            this.$http
                .post('${yhxt}/bizTpBridgeHealth/v1/abnormalCount', params)
                .then((res) => {
                    this.bridgeAbnormalCount = res.data || {}
                })
        },
        // 获取预警事件统计
        getWarningCountTotal(params) {
            this.$http
                .post('${yhxt}/bizTpWarningEvents/v1/warningCountTotal', params)
                .then((res) => {
                    let data = res.data || {}
                    // let bData = []
                    // let yData = []
                    // let rData = []
                    // data.forEach(item => {
                    //     if (item.tpBridgeName === '涪江大桥') {
                    //         bData[0] = item.blueHandleCount
                    //         yData[0] = item.yellowHandleCount
                    //         rData[0] = item.redHandleCount
                    //     } else if (item.tpBridgeName === '郁江河特大桥') {
                    //         bData[1] = item.blueHandleCount
                    //         yData[1] = item.yellowHandleCount
                    //         rData[1] = item.redHandleCount
                    //     }
                    // })
                    // console.log("warningTotal", [rData, yData, bData], res.data, data);
                    // this.warningTotal = [rData, yData, bData]
                    let rData = 0
                    let OData = 0
                    let yData = 0
                    data.forEach((item) => {
                        rData = item.redHandleCount || 0
                        yData = item.yellowHandleCount || 0
                        OData = item.blueHandleCount
                    })
                    this.warningTotal = [rData, yData, OData]
                    this.warningTotalNumber = this.warningTotal.reduce((acc, curr) => {
                        return acc + curr
                    }, 0)
                    // console.log('resData', this.warningTotal);


                })
        },
        // 获取未处置预警事件
        getNotDisposedWarn(params) {
            params = utils.deepClone(params)
            if (params.querys.length == 0) {
                params.querys.push({
                    group: 'main',
                    operation: 'EQUAL',
                    property: 'eventsState',
                    relation: 'AND',
                    value: 0,
                })
            }
            this.$http
                .post('${yhxt}/bizTpWarningEvents/v1/pageList', params)
                .then((res) => {
                    let data = res.data.rows
                    this.untreatedInfo.listData = data
                    return
                    // 标记桥梁位置
                    let list = []
                    data.forEach((i) => {
                        if (i.lng && i.lat) {
                            list.push({
                                lnglat: [i.lng, i.lat],
                                style: i.warnType - 1,
                                ...i,
                            })
                        }
                    })
                    this.bridgeCoordinateList = list
                    // 添加点标记(高德地图)
                    // this.markPoint(28)

                    // mineMap2D 地图
                    this.minemapMarker()
                })
        },

        // 设备统计图
        drawDevicePieChart() {
            // chart 已存在则为更新数据
            if (this.devicePieChart) {
                this.devicePieOption.series[0].data = this.devicePieData
                this.devicePieChart.setOption(this.devicePieOption)
            } else {
                // chart 不存在则为初始化数据和图表
                this.devicePieChart = echarts.init(
                    document.getElementById('section-pie-chart')
                )
                this.devicePieOption = {
                    title: {
                        text: this.devicePieData[0].value + ' 个',
                        subtext: this.devicePieData[0].name,
                        x: 'center',
                        y: '38%',
                        textStyle: {
                            color: '#fff',
                            fontSize: '20px',
                            lineHeight: 5,
                        },
                        subtextStyle: {
                            color: '#fff',
                            fontSize: '12px',
                        },
                    },
                    color: ['#55EDB0', '#1A8CFF'],
                    tooltip: {
                        trigger: 'item',
                        backgroundColor: 'rgba(13, 79, 145, 0.9)',
                        borderColor: '#3399FF',
                        confine: true,
                        textStyle: {
                            color: '#fff',
                        },
                        formatter: '{a} <br/>{b} : {c}个 ({d}%)',
                    },
                    series: [
                        {
                            name: '设备统计',
                            type: 'pie',
                            radius: ['77%', '94%'],
                            center: ['50%', '50%'],
                            data: this.devicePieData,
                            label: { show: false },
                            itemStyle: {
                                borderColor: '#0D1722',
                                borderWidth: 4,
                            },
                        },
                    ],
                }
                this.devicePieOption &&
                    this.devicePieChart.setOption(this.devicePieOption)
                window.addEventListener('resize', () => this.devicePieChart.resize())
                this.intervalFaultPie()
            }
            this.devicePieChart.dispatchAction({
                type: 'highlight',
                seriesIndex: 0,
                dataIndex: this.devicePiecurIndex,
            })
        },
        intervalFaultPie() {
            setInterval(() => {
                this.devicePieChart.dispatchAction({
                    type: 'downplay',
                    seriesIndex: 0,
                    dataIndex: this.devicePiecurIndex,
                })
                this.devicePiecurIndex++
                if (this.devicePiecurIndex >= this.devicePieData.length) {
                    this.devicePiecurIndex = 0
                }
                this.devicePieChart.dispatchAction({
                    type: 'highlight',
                    seriesIndex: 0,
                    dataIndex: this.devicePiecurIndex,
                })

                // 设备统计跟随变化统计数量已经名称
                this.devicePieOption.title.text =
                    this.devicePieData[this.devicePiecurIndex].value + ' 个'
                this.devicePieOption.title.subtext =
                    this.devicePieData[this.devicePiecurIndex].name
                this.devicePieOption &&
                    this.devicePieChart.setOption(this.devicePieOption)
            }, 3000)
        },
    },
}
