import htbComponent from '@/components/common/TabsComponent.vue'
export default [
    //工作台
    {
        path: 'workBench',
        name: 'workBench',
        //component: () => import('@/views/WorkBench.vue')
        component: () => import('@/views/WorkBenchCopy.vue'), // 正式的
        // component: () => import('@/views/Home.vue') // 测试配置门户
    },
    // 基础数据 ----> 基础数据
    {
        path: 'basicDataManagement',
        name: 'basicDataManagement',
        component: () => import('@/views/basicDataManagement/BasicDataManagement.vue'),
    },

    //基础数据管理 ----> 路线信息管理
    {
        path: 'routerManagement',
        name: 'routerManagement',
        component: () => import('@/views/basicDataManagement/RouterManagement.vue'),
    },
    //基础数据管理 ----> 路段信息管理
    {
        path: 'sectionManagement',
        name: 'sectionManagement',
        // component: () => import('@/views/basicDataManagement/SectionManagement.vue')
        // component: () => import('@/views/basicDataManagement/children/SectionManagement.vue')
        component: {
            render(c) {
                return c('router-view')
            },
        }, // 三级路由跳转
        redirect: '/frontPlat/sectionManagement',
        children: [
            {
                path: '/frontPlat/sectionManagement',
                name: 'sectionManagement',
                component: () =>
                    import('@/views/basicDataManagement/SectionManagement.vue'),
            },
            {
                path: 'children', // 三级菜单子级【必须】用children，因为在SideMenu.vue这个文件做了判断，根据children判断，选中菜单
                name: 'sectionManagementChildren',
                component: () =>
                    import('@/views/basicDataManagement/children/SectionManagement.vue'),
            },
        ],
    },
    //基础数据管理 ----> 桥梁信息管理
    {
        path: 'bridgeManagement',
        name: 'bridgeManagement',
        // component: () => import('@/views/basicDataManagement/BridgeManagement.vue'),
        component: {
            render(c) {
                return c('router-view')
            },
        }, // 三级路由跳转
        redirect: '/frontPlat/bridgeManagement',
        children: [
            {
                path: '/frontPlat/bridgeManagement',
                name: 'bridgeManagement',
                component: () =>
                    import('@/views/basicDataManagement/BridgeManagement.vue'),
            },
            {
                path: 'children', // 三级菜单子级【必须】用children，因为在SideMenu.vue这个文件做了判断，根据children判断，选中菜单
                name: 'bridgeManagementChildren',
                component: () =>
                    import('@/views/basicDataManagement/children/BridgeManagement.vue'),
            },
        ],
    },
    //基础数据管理 ----> 隧道信息管理
    {
        path: 'tunnelManagement',
        name: 'tunnelManagement',
        // component: () => import('@/views/basicDataManagement/TunnelManagement.vue'),
        component: {
            render(c) {
                return c('router-view')
            },
        }, // 三级路由跳转
        redirect: '/frontPlat/tunnelManagement',
        children: [
            {
                path: '/frontPlat/tunnelManagement',
                name: 'tunnelManagement',
                component: () =>
                    import('@/views/basicDataManagement/TunnelManagement.vue'),
            },
            {
                path: 'children', // 三级菜单子级【必须】用children，因为在SideMenu.vue这个文件做了判断，根据children判断，选中菜单
                name: 'tunnelManagementChildren',
                component: () =>
                    import('@/views/basicDataManagement/children/TunnelManagement.vue'),
            },
        ],
    },
    //基础数据管理 ----> 边坡信息管理
    {
        path: 'sideSlopeManagement',
        name: 'sideSlopeManagement',
        // component: () => import('@/views/basicDataManagement/SideSlopeManagement.vue'),
        component: {
            render(c) {
                return c('router-view')
            },
        }, // 三级路由跳转
        redirect: '/frontPlat/sideSlopeManagement',
        children: [
            {
                path: '/frontPlat/sideSlopeManagement',
                name: 'sideSlopeManagement',
                component: () =>
                    import('@/views/basicDataManagement/SideSlopeManagement.vue'),
            },
            {
                path: 'children', // 三级菜单子级【必须】用children，因为在SideMenu.vue这个文件做了判断，根据children判断，选中菜单
                name: 'sideSlopeManagementChildren',
                component: () =>
                    import(
                        '@/views/basicDataManagement/children/SideSlopeManagement.vue'
                    ),
            },
        ],
    },
    //基础数据管理 ----> 涵洞信息管理
    {
        path: 'culvertManagement',
        name: 'culvertManagement',
        // component: () => import('@/views/basicDataManagement/children/CulvertManagement.vue'),
        component: {
            render(c) {
                return c('router-view')
            },
        }, // 三级路由跳转
        redirect: '/frontPlat/culvertManagement',
        children: [
            {
                path: '/frontPlat/culvertManagement',
                name: 'culvertManagement',
                component: () =>
                    import('@/views/basicDataManagement/CulvertManagement.vue'),
            },
            {
                path: 'children', // 三级菜单子级【必须】用children，因为在SideMenu.vue这个文件做了判断，根据children判断，选中菜单
                name: 'culvertManagementChildren',
                component: () =>
                    import('@/views/basicDataManagement/children/CulvertManagement.vue'),
            },
        ],
    },
    //基础数据——施工人员
    {
        path: 'builder',
        name: 'builder',
        // component: () => import('@/views/basicDataManagement/builder.vue'),
        component: {
            render(c) {
                return c('router-view')
            },
        }, // 三级路由跳转
        redirect: '/frontPlat/builder',
        children: [
            {
                path: '/frontPlat/builder',
                name: 'builder',
                component: () => import('@/views/basicDataManagement/builder.vue'),
            },
            {
                path: 'children', // 三级菜单子级【必须】用children，因为在SideMenu.vue这个文件做了判断，根据children判断，选中菜单
                name: 'builderChildren',
                component: () =>
                    import('@/views/basicDataManagement/children/Builder.vue'),
            },
        ],
    },
    //基础数据管理 ----> 沿线设施管理
    {
        path: 'roadsideFacilitiesManagement',
        name: 'roadsideFacilitiesManagement',
        // component: () => import('@/views/basicDataManagement/RoadsideFacilitiesManagement.vue'),
        component: {
            render(c) {
                return c('router-view')
            },
        }, // 三级路由跳转
        redirect: '/frontPlat/roadsideFacilitiesManagement',
        children: [
            {
                path: '/frontPlat/roadsideFacilitiesManagement',
                name: 'roadsideFacilitiesManagement',
                component: () =>
                    import(
                        '@/views/basicDataManagement/RoadsideFacilitiesManagement.vue'
                    ),
            },
            {
                path: 'children', // 三级菜单子级【必须】用children，因为在SideMenu.vue这个文件做了判断，根据children判断，选中菜单
                name: 'roadsideFacilitiesManagementChildren',
                component: () =>
                    import(
                        '@/views/basicDataManagement/children/RoadsideFacilitiesManagement.vue'
                    ),
            },
        ],
    },
    //基础数据管理 ----> 成本科目管理
    {
        path: 'costAccountManagement',
        name: 'costAccountManagement',
        component: () =>
            import(
                //'@/views/basicDataManagement/CostAccountManagement.vue'
                '@/views/basicDataManagement/CostAccountManagementCopy.vue'
            ),
    },
    //基础数据管理 ----> 工程图纸管理
    {
        path: 'engineeringDrawingsManagement',
        name: 'engineeringDrawingsManagement',
        component: () =>
            import('@/views/basicDataManagement/EngineeringDrawingsManagement.vue'),
    },
    //基础数据管理 ----> 地图工具管理 --> 待定
    {
        path: 'mapToolManagement',
        name: 'mapToolManagement',
        component: () => import('@/views/basicDataManagement/MapToolManagement.vue'),
    },
    //基础数据管理 ----> 公司人员
    {
        path: 'gsry',
        name: 'gsry',
        // component: () => import('@/views/basicDataManagement/children/CulvertManagement.vue'),
        component: {
            render(c) {
                return c('router-view')
            },
        }, // 三级路由跳转
        redirect: '/frontPlat/gsry',
        children: [
            {
                path: '/frontPlat/gsry',
                name: 'gsry',
                component: () =>
                    import('@/views/basicDataManagement/gsry.vue'),
            },
            {
                path: 'children', // 三级菜单子级【必须】用children，因为在SideMenu.vue这个文件做了判断，根据children判断，选中菜单
                name: 'gsryChildren',
                component: () =>
                    import('@/views/basicDataManagement/children/gsry.vue'),
            },
        ],
    },
    // //基础数据管理 ----> 单位管理
    {
        path: 'companyManagement',
        name: 'companyManagement',
        component: htbComponent,
    },
    //基础数据管理 ----> 养护车辆管理
    {
        path: 'carManagement',
        name: 'carManagement',
        // component: htbComponent,
        component: {
            render(c) {
                return c('router-view')
            },
        }, // 三级路由跳转
        redirect: '/frontPlat/carManagement',
        children: [
            {
                path: '/frontPlat/carManagement',
                name: 'carManagement',
                component: () => import('@/views/basicDataManagement/CarManagement.vue'),
            },
            {
                path: 'carManagement', // 三级菜单子级【必须】用children，因为在SideMenu.vue这个文件做了判断，根据children判断，选中菜单
                name: 'carManagementChildren',
                component: htbComponent,
            },
        ],
    },
    //基础数据管理 ----> 考核项目
    {
        path: 'assessmentItems',
        name: 'assessmentItems',
        component: () => import('@/views/basicDataManagement/AssessmentItems.vue'),
    },
    //基础数据管理 ----> 应急物资
    {
        path: 'emergencySupplies',
        name: 'emergencySupplies',
        // component: () => import('@/views/basicDataManagement/EmergencySupplies.vue'),
        component: {
            render(c) {
                return c('router-view')
            },
        }, // 三级路由跳转
        redirect: '/frontPlat/emergencySupplies',
        children: [
            {
                path: '/frontPlat/emergencySupplies',
                name: 'emergencySupplies',
                component: () =>
                    import('@/views/basicDataManagement/EmergencySupplies.vue'),
            },
            {
                path: 'children', // 三级菜单子级【必须】用children，因为在SideMenu.vue这个文件做了判断，根据children判断，选中菜单
                name: 'emergencySuppliesChildren',
                component: () =>
                    import('@/views/basicDataManagement/children/EmergencySupplies.vue'),
            },
        ],
    },
    //基础数据管理 ----> 养护工区
    {
        path: 'maintenanceWorkArea',
        name: 'maintenanceWorkArea',
        // component: () => import('@/views/basicDataManagement/MaintenanceWorkArea.vue'),
        component: {
            render(c) {
                return c('router-view')
            },
        }, // 三级路由跳转
        redirect: '/frontPlat/maintenanceWorkArea',
        children: [
            {
                path: '/frontPlat/maintenanceWorkArea',
                name: 'maintenanceWorkArea',
                component: () =>
                    import('@/views/basicDataManagement/MaintenanceWorkArea.vue'),
            },
            {
                path: 'children', // 三级菜单子级【必须】用children，因为在SideMenu.vue这个文件做了判断，根据children判断，选中菜单
                name: 'maintenanceWorkAreaChildren',
                component: () =>
                    import(
                        '@/views/basicDataManagement/children/MaintenanceWorkArea.vue'
                    ),
            },
        ],
    },
    //基础数据管理 ----> 救援点
    {
        path: 'rescuePoint',
        name: 'rescuePoint',
        // component: () => import('@/views/basicDataManagement/RescuePoint.vue'),
        component: {
            render(c) {
                return c('router-view')
            },
        }, // 三级路由跳转
        redirect: '/frontPlat/rescuePoint',
        children: [
            {
                path: '/frontPlat/rescuePoint',
                name: 'rescuePoint',
                component: () => import('@/views/basicDataManagement/RescuePoint.vue'),
            },
            {
                path: 'children', // 三级菜单子级【必须】用children，因为在SideMenu.vue这个文件做了判断，根据children判断，选中菜单
                name: 'rescuePointChildren',
                component: () =>
                    import('@/views/basicDataManagement/children/RescuePoint.vue'),
            },
        ],
    },
    // 预算管理 ----> 预算管理
    {
        path: 'bugetManagement',
        name: 'bugetManagement',
        component: () => import('@/views/budgetManagement/BugetManagement.vue'),
    },

    //预算管理 ----> 成本预算
    {
        path: 'costBudget',
        name: 'costBudget',
        component: () => import('@/views/budgetManagement/CostBudget.vue'),
    },

    //预算管理 ----> 查询预算
    {
        path: 'budgetQuery',
        name: 'budgetQuery',
        // component: () => import('@/views/budgetManagement/BudgetQuery.vue'),
        component: {
            render(c) {
                return c('router-view')
            },
        }, // 三级路由跳转
        redirect: '/frontPlat/budgetQuery',
        children: [
            {
                path: '/frontPlat/budgetQuery',
                name: 'budgetQuery',
                component: () => import('@/views/budgetManagement/BudgetQuery.vue'),
            },
            {
                path: 'children',
                name: 'BudgetQueryDetail',
                component: () => import('@/views/budgetManagement/children/BudgetQueryDetail.vue'),
            },
        ]
    },
    //预算管理 ----> 预算执行
    {
        path: 'budgetSum',
        name: 'budgetSum',
        // component: () => import('@/views/budgetManagement/budgetSum.vue'),
        component: {
            render(c) {
                return c('router-view')
            },
        }, // 三级路由跳转
        redirect: '/frontPlat/budgetSum',
        children: [
            {
                path: '/frontPlat/budgetSum',
                name: 'budgetSum',
                component: () => import('@/views/budgetManagement/budgetSum.vue'),
            },
            {
                path: 'children', // 三级菜单子级【必须】用children，因为在SideMenu.vue这个文件做了判断，根据children判断，选中菜单
                name: 'budgetSumChildren',
                component: () =>
                    import(
                        '@/views/budgetManagement/children/budgetSumChild.vue'
                    ),
            },
        ],
    },
    // //业务数据管理 ----> 车辆管理
    // {
    //   path: 'carManagement',
    //   name: 'carManagement',
    //   component: () =>
    //     import(
    //       '@/views/businessDataManagement/CarManagement.vue'
    //     )
    // },
    //业务数据管理 ----> 用户管理
    // {
    //   path: 'userManagement',
    //   name: 'userManagement',
    //   component: () =>
    //     import(
    //       '@/views/businessDataManagement/UserManagement.vue'
    //     )
    // },
    //业务数据管理 ----> 用户管理
    //  {
    //   path: 'companyManagement',
    //   name: 'companyManagement',
    //   component: () =>
    //     import(
    //       '@/views/businessDataManagement/CompanyManagement.vue'
    //     )
    // },
    //合同管理 ----> 日常养护合同
    {
        path: 'dailyMaintenanceContract',
        name: 'dailyMaintenanceContract',
        // component: () => import('@/views/contractManagement/DailyMaintenanceContract.vue'),
        component: {
            render(c) {
                return c('router-view')
            },
        }, // 三级路由跳转
        redirect: '/frontPlat/dailyMaintenanceContract',
        children: [
            {
                path: '/frontPlat/dailyMaintenanceContract',
                name: 'dailyMaintenanceContract',
                component: () =>
                    import('@/views/contractManagement/DailyMaintenanceContract.vue'),
            },
            {
                path: 'children', // 三级菜单子级【必须】用children，因为在SideMenu.vue这个文件做了判断，根据children判断，选中菜单
                name: 'dailyMaintenanceContractChildren',
                component: () =>
                    import(
                        '@/views/contractManagement/children/DailyMaintenanceContract.vue'
                    ),
            },
        ],
    },
    //合同管理 ----> 合同查询
    {
        path: 'contractQuery',
        name: 'contractQuery',
        component: () => import('@/views/contractManagement/ContractQuery.vue'),
    },
    //巡查任务 ----> 任务配置
    {
        path: 'taskConfiguration',
        name: 'taskConfiguration',
        component: () => import('@/views/patrolTask/TaskConfiguration.vue'),
    },
    //巡查任务 ----> 任务管理
    {
        path: 'taskManagement',
        name: 'taskManagement',
        component: () => import('@/views/patrolTask/TaskManagement.vue'),
    },
    //巡查任务 ----> 代办巡查
    {
        path: 'agentInspection',
        name: 'agentInspection',
        component: () => import('@/views/patrolTask/AgentInspection.vue'),
    },
    //巡查任务 ----> 已办巡查
    {
        path: 'alreadyPatrol',
        name: 'alreadyPatrol',
        component: () => import('@/views/patrolTask/AlreadyPatrol.vue'),
    },
    //养护检查 -----> 养护检查
    {
        path: 'maintenanceInspection',
        name: 'maintenanceInspection',
        component: () =>
            import('@/views/maintenanceInspection/maintenanceInspection.vue'),
    },
    //养护检查 -----> 巡检流程图
    {
        path: 'patrolFlowChart',
        name: 'patrolFlowChart',
        component: () => import('@/views/maintenanceInspection/PatrolFlowChart.vue'),
    },
    {
        path: 'unitUserManagement',
        name: 'unitUserManagement',
        component: () => import('@/views/uc/UcManager/UserListManager.vue'),
    },
    {
        path: 'unitManagement',
        name: 'unitManagement',
        component: () =>
            import('@/views/basicDataManagement/companyManagement/CompanyManagement.vue'),
    },
    //养护检查 -----> 养护流程图
    {
        path: 'maintenanceFlowChart',
        name: 'maintenanceFlowChart',
        component: () => import('@/views/maintenanceInspection/MaintenanceFlowChart.vue'),
    },
    //养护检查 ----> 日常巡查
    {
        path: 'dailyPatrol',
        name: 'dailyPatrol',
        component: htbComponent,
    },
    //养护检查 ----> 定期检查
    {
        path: 'regularInspection',
        name: 'regularInspection',
        component: htbComponent,
    },
    //养护检查 ----> 经常检查
    {
        path: 'checkFrequently',
        name: 'checkFrequently',
        component: htbComponent,
    },
    //养护检查 ----> 巡检逾期记录
    {
        path: 'overdueRecords',
        name: 'overdueRecords',
        component: () => import('@/views/maintenanceInspection/overdueRecords.vue'),
    },
    {
        path: 'Fretow',
        name: 'Fretow',
        component: () =>
            import('@/views/maintenanceInspection/checkFrequently/Fretow.vue'),
    },
    {
        path: 'DqFretow',
        name: 'DqFretow',
        component: () =>
            import('@/views/maintenanceInspection/regularInspection/DqFretow.vue'),
    },
    {
        path: 'DqSlope',
        name: 'DqSlope',
        component: () =>
            import('@/views/maintenanceInspection/regularInspection/DqSlope.vue'),
    },
    {
        path: 'DqTunnel',
        name: 'DqTunnel',
        component: () =>
            import('@/views/maintenanceInspection/regularInspection/DqTunnel.vue'),
    },
    {
        path: 'FrontorgManager',
        name: 'FrontorgManager',
        component: () =>
            import('@/views/basicDataManagement/companyManagement/CompanyManagement.vue'),
    },
    {
        path: 'DqCulvert',
        name: 'DqCulvert',
        component: () =>
            import('@/views/maintenanceInspection/regularInspection/DqCulvert.vue'),
    },
    {
        path: 'tunnels',
        name: 'tunnels',
        component: () =>
            import('@/views/maintenanceInspection/checkFrequently/tunnels.vue'),
    },
    {
        path: 'slope',
        name: 'slope',
        component: () =>
            import('@/views/maintenanceInspection/checkFrequently/slope.vue'),
    },
    {
        path: 'culverts',
        name: 'culverts',
        component: () =>
            import('@/views/maintenanceInspection/checkFrequently/culverts.vue'),
    },
    {
        path: 'inspectBridge',
        name: 'inspectBridge',
        component: () =>
            import('@/views/structureArchivesManagement/bridgeFolder/inspectBridge.vue'),
    },
    {
        path: 'bridgeDisease',
        name: 'bridgeDisease',
        component: () =>
            import('@/views/structureArchivesManagement/bridgeFolder/bridgeDisease.vue'),
    },
    {
        path: 'inspectTunnel',
        name: 'inspectTunnel',
        component: () =>
            import('@/views/structureArchivesManagement/tunnelFolder/inspectTunnel.vue'),
    },
    {
        path: 'tunnelDisease',
        name: 'tunnelDisease',
        component: () =>
            import('@/views/structureArchivesManagement/tunnelFolder/tunnelDisease.vue'),
    },
    //养护检查 ----> 专项工程检查
    {
        path: 'specialProjectInspection',
        name: 'specialProjectInspection',
        component: htbComponent,
    },
    //养护检查 ----> MOI检查数据
    {
        path: 'mqiCheckData',
        name: 'mqiCheckData',
        component: () => import('@/views/maintenanceInspection/MqiCheckData.vue'),
    },
    //专项巡查 ----> 统计
    {
        path: 'specialInspection',
        name: 'specialInspection',
        component: () => import('@/views/maintenanceInspection/specialInspection.vue'),
    },
    // 病害管理 ----> 病害管理
    {
        path: 'virusManagement',
        name: 'virusManagement',
        component: () => import('@/views/virusManagement/VirusManagement.vue'),
    },
    //病毒管理 ----> 未处理病毒管理
    {
        path: 'UntreatedDisease',
        name: 'UntreatedDisease',
        component: () => import('@/views/virusManagement/UntreatedDisease.vue'),
    },
    //病毒管理 ----> 病毒管理
    {
        path: 'virusManagementChild',
        name: 'virusManagementChild',
        component: () => import('@/views/virusManagement/VirusManagementChild.vue'),
    },
    //病毒管理 ----> 暂存病毒
    {
        path: 'temporaryVirus',
        name: 'temporaryVirus',
        component: () => import('@/views/virusManagement/TemporaryVirus.vue'),
    },
    //病毒管理 ----> 预警配置
    {
        path: 'warnConfig',
        name: 'warnConfig',
        component: () => import('@/views/virusManagement/WarnConfig.vue'),
    },
    // 日常养护 ---> 日常养护
    {
        path: 'dailyMaintenance',
        name: 'dailyMaintenance',
        component: () => import('@/views/dailyMaintenance/DailyMaintenance.vue'),
    },

    //日常养护 ----> 工单信息
    {
        path: 'workOrderInfo',
        name: 'workOrderInfo',
        component: () => import('@/views/dailyMaintenance/WorkOrderInfo.vue'),
    },
    //日常养护 -----> 逾期工单
    {
        path: 'overdueWorkOrders',
        name: 'overdueWorkOrders',
        // component: () => import('@/views/dailyMaintenance/overdueWorkOrders.vue'),
        component: {
            render(c) {
                return c('router-view')
            },
        }, // 三级路由跳转
        redirect: '/frontPlat/overdueWorkOrders',
        children: [
            {
                path: '/frontPlat/overdueWorkOrders',
                name: 'overdueWorkOrders',
                component: () => import('@/views/dailyMaintenance/overdueWorkOrders.vue'),
            },
            {
                path: 'children', // 三级菜单子级【必须】用children，因为在SideMenu.vue这个文件做了判断，根据children判断，选中菜单
                name: 'overdueWorkOrdersChildren',
                component: () =>
                    import(
                        '@/views/dailyMaintenance/children/overdueWorkOrdersChildren.vue'
                    ),
            },
        ],
    },
    //日常养护 ----> 代办工单
    {
        path: 'agencyWorkOrder',
        name: 'agencyWorkOrder',
        component: () => import('@/views/dailyMaintenance/AgencyWorkOrder.vue'),
    },
    //日常养护 ----> 已办工单
    {
        path: 'alreadyWorkOrder',
        name: 'alreadyWorkOrder',
        component: () => import('@/views/dailyMaintenance/AlreadyWorkOrder.vue'),
    },
    //日常养护 ----> 工单台账
    {
        path: 'workOrderBook',
        name: 'workOrderBook',
        component: () => import('@/views/dailyMaintenance/WorkOrderBook.vue'),
    },
    //日常养护 ----> 工单统计
    {
        path: 'workOrderStatistics',
        name: 'workOrderStatistics',
        component: () => import('@/views/dailyMaintenance/WorkOrderStatistics.vue'),
    },
    //日常养护 ----> 养护考核
    {
        path: 'maintenanceAssessment',
        name: 'maintenanceAssessment',
        component: () => import('@/views/dailyMaintenance/MaintenanceAssessment.vue'),
    },
    //日常养护 -----> 查看关联养护工单
    {
        path: 'MainAssessment',
        name: 'MainAssessment',
        component: () => import('@/views/dailyMaintenance/MainAssessment.vue'),
    },
    //日常养护 -----> 日常工作
    {
        path: 'workplan',
        name: 'workplan',
        component: () => import('@/views/dailyMaintenance/workplan.vue'),
    },

    // 工程管理 ----> 工程管理
    {
        path: 'specialProjectManagement',
        name: 'specialProjectManagement',
        component: () =>
            import('@/views/specialProjectManagement/SpecialProjectManagement.vue'),
    },
    // 工程管理 ----> 交工计量支付
    {
        path: 'JGJLZF',
        name: 'JGJLZF',
        component: () => import('@/views/specialProjectManagement/DeliveryPayment.vue'),
    },
    // 工程管理 ----> 过程监督
    {
        path: 'GCJD',
        name: 'GCJD',
        component: () =>
            import('@/views/specialProjectManagement/ProcessSupervision.vue'),
    },
    //专项工程管理 ----> 项目管理
    {
        path: 'projectManagement',
        name: 'projectManagement',
        // component: () => import('@/views/specialProjectManagement/ProjectManagement.vue'),
        component: {
            render(c) {
                return c('router-view')
            },
        }, // 三级路由跳转
        redirect: '/frontPlat/projectManagement',
        children: [
            {
                path: '/frontPlat/projectManagement',
                name: 'projectManagement',
                component: () =>
                    import('@/views/specialProjectManagement/ProjectManagement.vue'),
            },
            {
                path: 'children', // 三级菜单子级【必须】用children，因为在SideMenu.vue这个文件做了判断，根据children判断，选中菜单
                name: 'projectManagementChildren',
                component: () =>
                    import(
                        '@/views/specialProjectManagement/children/ProjectManagement.vue'
                    ),
            },
        ],
    },
    //专项工程管理 ----> 招投标信息
    {
        path: 'biddingInformation',
        name: 'biddingInformation',
        component: () =>
            import('@/views/specialProjectManagement/BiddingInformation.vue'),
    },
    //专项工程管理 ----> 合同信息
    {
        path: 'contractInfo',
        name: 'contractInfo',
        component: () => import('@/views/specialProjectManagement/ContractInfo.vue'),
    },
    //专项工程管理 ----> 开工信息
    {
        path: 'startInfo',
        name: 'startInfo',
        component: htbComponent,
    },
    //专项工程管理 ----> 开工审批
    {
        path: 'approvalWork',
        name: 'approvalWork',
        component: () => import('@/views/specialProjectManagement/approvalWork.vue'),
    },
    //专项工程管理 ----> 安全环保
    {
        path: 'safetyEnvironmentalProtection',
        name: 'safetyEnvironmentalProtection',
        component: htbComponent
        // import('@/views/specialProjectManagement/SafetyEnvironmentalProtection.vue'),
    },
    //专项工程管理 ----> 整改记录
    {
        path: 'alterRecord',
        name: 'alterRecord',
        component: htbComponent
    },
    //专项工程管理 ----> 巡查记录
    {
        path: 'patrolRecord',
        name: 'patrolRecord',
        component: () => import('@/views/specialProjectManagement/PatrolRecord.vue'),
    },
    //专项工程管理 ----> 项目日志
    {
        path: 'projectLog',
        name: 'projectLog',
        component: () => import('@/views/specialProjectManagement/ProjectLog.vue'),
    },
    //专项工程管理 ----> 项目周报月报
    {
        path: 'projectWeekMouth',
        name: 'projectWeekMouth',
        component: () => import('@/views/specialProjectManagement/ProjectWeekMouth.vue'),
    },
    //专项工程管理 ----> 质量管理
    {
        path: 'qualityManagement',
        name: 'qualityManagement',
        component: htbComponent,
    },
    //专项工程管理 ----> 民工管理
    {
        path: 'migrantWorkerManagement',
        name: 'migrantWorkerManagement',
        component: () =>
            import('@/views/specialProjectManagement/MigrantWorkerManagement.vue'),
    },
    //专项工程管理 ----> 交工信息
    {
        path: 'handoverInfo',
        name: 'handoverInfo',
        component: () => import('@/views/specialProjectManagement/HandoverInfo.vue'),
    },
    //专项工程管理 ----> 计量支付
    {
        path: 'meterPayment',
        name: 'meterPayment',
        component: () => import('@/views/specialProjectManagement/MeterPayment.vue'),
    },
    //专项工程管理 ----> 验收信息
    {
        path: 'acceptInfo',
        name: 'acceptInfo',
        component: htbComponent
        //() => import('@/views/specialProjectManagement/AcceptInfo.vue'),
    },
    //专项工程管理 ----> 计量支付
    {
        path: 'projectCount',
        name: 'projectCount',
        component: () => import('@/views/specialProjectManagement/projectCount.vue'),
    },
    //结构物档案管理 ----> 结构物档案管理
    {
        path: 'structureArchivesManagement',
        name: 'structureArchivesManagement',
        component: () =>
            import('@/views/structureArchivesManagement/StructureArchivesManagement.vue'),
    },
    //结构物档案管理 ----> 桥梁档案管理
    {
        path: 'bridgeArchivesManagement',
        name: 'bridgeArchivesManagement',
        component: () =>
            import('@/views/structureArchivesManagement/BridgeArchivesManagement.vue'),
    },
    //结构物档案管理 ----> 隧道档案管理
    {
        path: 'tunnelArchivesManagement',
        name: 'tunnelArchivesManagement',
        component: () =>
            import('@/views/structureArchivesManagement/TunnelArchivesManagement.vue'),
    },
    //结构物档案管理 ----> 涵洞档案管理
    {
        path: 'culvertArchivesManagement',
        name: 'culvertArchivesManagement',
        component: () =>
            import('@/views/structureArchivesManagement/CulvertArchivesManagement.vue'),
    },
    //结构物档案管理 ----> 边坡档案管理
    {
        path: 'slopeArchivesManagement',
        name: 'slopeArchivesManagement',
        component: () =>
            import('@/views/structureArchivesManagement/SlopeArchivesManagement.vue'),
    },
    //健康监测
    {
        path: 'healthMonitoring',
        name: 'healthMonitoring',
        component: () => import('@/views/HealthMonitoring.vue'),
    },
    // 统计报表 ---> 日常养护
    {
        path: 'statisticsDailyMaintenance',
        name: 'statisticsDailyMaintenance',
        component: () => import('@/views/dailyMaintenance/DailyMaintenance.vue'),
    },
    // 统计报表 ----> 基础数据
    {
        path: 'statisticsBasicDataManagement',
        name: 'statisticsBasicDataManagement',
        component: () => import('@/views/basicDataManagement/BasicDataManagement.vue'),
    },
    // 统计报表 ----> 预算管理
    {
        path: 'statisticsBugetManagement',
        name: 'statisticsBugetManagement',
        component: () => import('@/views/budgetManagement/BugetManagement.vue'),
    },
    //统计报表 ---> 道路病害统计
    {
        path: 'roadDiseaseStatistics',
        name: 'roadDiseaseStatistics',
        component: () => import('@/views/statisticalReport/RoadDiseaseStatistics.vue'),
    },
    //统计报表 ---> 日常养护统计
    {
        path: 'dailyMaintenanceStatistics',
        name: 'dailyMaintenanceStatistics',
        component: () =>
            import('@/views/statisticalReport/DailyMaintenanceStatistics.vue'),
    },
    //统计报表 ---> 养护成功科目
    {
        path: 'maintenanceCostAccount',
        name: 'maintenanceCostAccount',
        component: () => import('@/views/statisticalReport/MaintenanceCostAccount.vue'),
    },
    //统计报表 ---> 巡查填报统计
    {
        path: 'patrolFillingStatistics',
        name: 'patrolFillingStatistics',
        component: htbComponent,
    },

    //统计报表 ---> 巡查填报统计_
    {
        path: 'patrolFillingStatistics_',
        name: 'patrolFillingStatistics_',
        component: () => import('@/views/statisticalReport/patrolFillingStatistics_.vue'),
    },
    //统计报表 ---> 桥梁结构统计
    {
        path: 'bridgeStructureStatistics',
        name: 'bridgeStructureStatistics',
        component: () =>
            import('@/views/statisticalReport/BridgeStructureStatistics.vue'),
    },
    //统计报表 ---> 结构物检查情况统计
    {
        path: 'statisticsStructureInspection',
        name: 'statisticsStructureInspection',
        component: () =>
            import('@/views/statisticalReport/StatisticsStructureInspection.vue'),
    },
    //统计报表 ---> 养护检查统计
    {
        path: 'maintenanceInspectionStatistics',
        name: 'maintenanceInspectionStatistics',
        component: htbComponent,
    },
    //统计报表 ---> 专项工程统计
    {
        path: 'specialProjectStatistics',
        name: 'specialProjectStatistics',
        component: () => import('@/views/statisticalReport/specialProjectStatistics.vue'),
    },
    //     //统计报表 ---> 定期检查统计
    // {
    //   path: 'CheckStatisticsRegularly',
    //   name: 'CheckStatisticsRegularly',
    //   component: () =>
    //     import('@/views/statisticalReport/CheckStatisticsRegularly.vue'),
    // },
    //统计报表 ---> 管养信息统计
    {
        path: 'managementInfoStatistics',
        name: 'managementInfoStatistics',
        // component: () =>
        //   import('@/views/statisticalReport/children/ManagementInfoStatistics.vue'),
        component: {
            render(c) {
                return c('router-view')
            },
        }, // 三级路由跳转
        redirect: '/frontPlat/managementInfoStatistics',
        children: [
            {
                path: '/frontPlat/managementInfoStatistics',
                name: 'managementInfoStatistics',
                component: () =>
                    import('@/views/statisticalReport/ManagementInfoStatistics.vue'),
            },
            {
                path: 'children', // 三级菜单子级【必须】用children，因为在SideMenu.vue这个文件做了判断，根据children判断，选中菜单
                name: 'managementInfoStatisticsChildren',
                component: () =>
                    import(
                        '@/views/statisticalReport/children/ManagementInfoStatistics.vue'
                    ),
            },
        ],
    },
    //统计报表 ---> 病害分布及处治效率统计
    {
        path: 'diseaseStatistics',
        name: 'diseaseStatistics',
        component: () => import('@/views/statisticalReport/DiseaseStatistics.vue'),
    },
    //统计报表 ---> 养护巡查统计
    {
        path: 'maintenancePatrolStatistics',
        name: 'maintenancePatrolStatistics',
        component: htbComponent,
        // component: () =>
        //     import('@/views/statisticalReport/MaintenancePatrolStatistics.vue'),
    },
    //统计报表 ---> 养护项目统计
    {
        path: 'mainProjectStatistics',
        name: 'mainProjectStatistics',
        component: () => import('@/views/statisticalReport/MainProjectStatistics.vue'),
    },
    //统计报表 ---> 日常养护任务单统计
    {
        path: 'dailyMainTaskStatistics',
        name: 'dailyMainTaskStatistics',
        component: () => import('@/views/statisticalReport/DailyMainTaskStatistics.vue'),
    },
    //统计报表 ---> 日常养护施工完成统计
    {
        path: 'dialyMainCompletionStatistics',
        name: 'dialyMainCompletionStatistics',
        component: () =>
            import('@/views/statisticalReport/DialyMainCompletionStatistics.vue'),
    },
    //统计报表 ---> 日常养护工程计量支付统计
    {
        path: 'dailyMainEngPayStatistics',
        name: 'dailyMainEngPayStatistics',
        component: () =>
            import('@/views/statisticalReport/DailyMainEngPayStatistics.vue'),
    },
    //统计报表 ---> 日常养护工程计量支付统计汇总
    {
        path: 'summaryWorks',
        name: 'summaryWorks',
        component: () => import('@/views/statisticalReport/SummaryWorks.vue'),
    },
    //统计报表 ---> 养护资金执行情况报表
    {
        path: 'useOfFundsReport',
        name: 'useOfFundsReport',
        component: () => import('@/views/statisticalReport/UseOfFundsReport.vue'),
    },
    //统计报表 ---> 经常检查统计
    {
        path: 'frequentlyCheckStatistics',
        name: 'frequentlyCheckStatistics',
        component: () =>
            import('@/views/statisticalReport/FrequentlyCheckStatistics.vue'),
    },
    //统计报表 ---> 专项养护工程计量支付列表
    {
        path: 'specialPayList',
        name: 'specialPayList',
        component: () => import('@/views/statisticalReport/SpecialPayList.vue'),
    },
    //统计报表 ---> 专项养护工程计量支付汇总统计
    {
        path: 'specialPayStatices',
        name: 'specialPayStatices',
        component: () => import('@/views/statisticalReport/SpecialPayStatices.vue'),
    },
    //统计报表 ---> 验收情况统计
    {
        path: 'checkStatices',
        name: 'checkStatices',
        component: () => import('@/views/statisticalReport/CheckStatices.vue'),
    },
    //统计报表 ---> 验收情况统计
    {
        path: 'monthlyMagazine',
        name: 'monthlyMagazine',
        component: () => import('@/views/statisticalReport/MonthlyMagazine.vue'),
    },
    //统计报表 ---> MQI统计
    {
        path: 'mqiStatistics',
        name: 'mqiStatistics',
        component: () => import('@/views/statisticalReport/MqiStatistics.vue'),
    },
    //地图
    {
        path: 'maptest',
        name: 'maptest',
        component: htbComponent,
    },
    //结构物管理 --> 涵洞检查记录
    {
        path: 'culvertIndex',
        name: 'culvertIndex',
        component: () =>
            import(
                '@/views/structureArchivesManagement/culvertInsepect/CulvertIndex.vue'
            ),
    },
    //结构物管理 --> 涵洞病害记录
    {
        path: 'disease',
        name: 'disease',
        component: () =>
            import('@/views/structureArchivesManagement/culvertInsepect/Disease.vue'),
    },
    //结构物管理 --> 涵洞养护记录
    {
        path: 'curing',
        name: 'curing',
        component: () =>
            import('@/views/structureArchivesManagement/culvertInsepect/Curing.vue'),
    },
    //结构物管理 --> 边坡检查记录
    {
        path: 'slopIndex',
        name: 'slopIndex',
        component: () =>
            import(
                '@/views/structureArchivesManagement/slopeArchives/SlopeArchivesIndex.vue'
            ),
    },
    //结构物管理 --> 边坡病害记录
    {
        path: 'slopDisease',
        name: 'slopDisease',
        component: () =>
            import('@/views/structureArchivesManagement/slopeArchives/DiseaseSlope.vue'),
    },
    //结构物管理 --> 边坡养护记录
    {
        path: 'slopCuring',
        name: 'slopCuring',
        component: () =>
            import('@/views/structureArchivesManagement/slopeArchives/CuringSlope.vue'),
    },
    //IT资源申请 --> 资源申请
    {
        path: 'resourceApply',
        name: 'resourceApply',
        component: () =>
            import('@/views/resourceApply/resourceApply.vue'),
    },
    //IT资源申请 --> 资源审核
    {
        path: 'resourceAudit',
        name: 'resourceAudit',
        component: () =>
            import('@/views/resourceApply/resourceAudit.vue'),
    },
    //IT资源申请 --> 资源执行
    {
        path: 'resourceExecute',
        name: 'resourceExecute',
        component: () =>
            import('@/views/resourceApply/resourceExecute.vue'),
    },
]
