/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.yhxt.specialproject.manager.impl;

import com.artfess.base.context.BaseContext;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.uc.dao.OrgDao;
import com.artfess.uc.model.Org;
import com.artfess.yhxt.basedata.manager.RoadManager;
import com.artfess.yhxt.basedata.model.Road;
import com.artfess.yhxt.budget.manager.YearBudgetDetailedManager;
import com.artfess.yhxt.budget.manager.YearBudgetManager;
import com.artfess.yhxt.budget.model.YearBudget;
import com.artfess.yhxt.budget.model.YearBudgetDetailed;
import com.artfess.yhxt.specialproject.dao.BizEngineeringProjectDao;
import com.artfess.yhxt.specialproject.manager.BizEngineeringAccessoriesManager;
import com.artfess.yhxt.specialproject.manager.BizEngineeringProjectManager;
import com.artfess.yhxt.specialproject.manager.BizProjectContractManager;
import com.artfess.yhxt.specialproject.manager.MeasurementPaymentDetailsManager;
import com.artfess.yhxt.specialproject.manager.MeasurementPaymentManager;
import com.artfess.yhxt.specialproject.model.BizEngineeringAccessories;
import com.artfess.yhxt.specialproject.model.BizEngineeringProject;
import com.artfess.yhxt.specialproject.model.MeasurementPayment;
import com.artfess.yhxt.specialproject.vo.BizEngineeringProjectVo;
import com.artfess.yhxt.specialproject.vo.ProjectMoneyListVO;
import com.artfess.yhxt.specialproject.vo.ProjectMoneyVO;
import com.artfess.yhxt.specialproject.vo.ProjectReportVO;
import com.artfess.yhxt.statistics.vo.Org4ProjectMoneyVO;
import com.artfess.yhxt.statistics.vo.Org4ProjectVO;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BizEngineeringProjectManagerImpl
extends BaseManagerImpl<BizEngineeringProjectDao, BizEngineeringProject>
implements BizEngineeringProjectManager {
    @Resource
    BizEngineeringProjectDao bizEngineeringProjectDao;
    @Resource
    BizEngineeringAccessoriesManager bizEngineeringAccessoriesManager;
    @Resource
    private OrgDao orgDao;
    @Resource
    BaseContext baseContext;
    @Resource
    private RoadManager roadManager;
    @Resource
    private BizProjectContractManager bizProjectContractManager;
    @Resource
    private MeasurementPaymentManager measurementPaymentManager;
    @Resource
    private MeasurementPaymentDetailsManager measurementPaymentDetailsManager;
    @Autowired
    private YearBudgetManager yearBudgetManager;
    @Autowired
    private YearBudgetDetailedManager yearBudgetDetailedManager;

    @Override
    public List<ProjectMoneyListVO> getMoneyListReport(String year, String orgId) {
        ArrayList<ProjectMoneyListVO> vos = new ArrayList<ProjectMoneyListVO>();
        QueryWrapper roadWrapper = new QueryWrapper();
        roadWrapper.eq((Object)"IS_DELE_", (Object)"0");
        roadWrapper.like((Object)"COMPANY_IDS_", (Object)orgId);
        List roads = this.roadManager.list((Wrapper)roadWrapper);
        for (Road road : roads) {
            QueryWrapper queryWrapperYearBudget = new QueryWrapper();
            queryWrapperYearBudget.eq((Object)"IS_DELE_", (Object)"0");
            queryWrapperYearBudget.eq((Object)"ROAD_SEGMENT_ID_", (Object)road.getId());
            queryWrapperYearBudget.eq((Object)"ASCRIPTION_YEAR_", (Object)String.valueOf(year));
            YearBudget yearBudget = (YearBudget)((Object)this.yearBudgetManager.getOne((Wrapper)queryWrapperYearBudget));
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"IS_DELE_", (Object)"0");
            queryWrapper.eq((Object)"ROAD_SEGMENT_ID_", (Object)road.getId());
            queryWrapper.eq((Object)"PROJECT_YEAR_", (Object)year);
            List list = this.list((Wrapper)queryWrapper);
            for (BizEngineeringProject project : list) {
                BigDecimal payMoney = BigDecimal.ZERO;
                ProjectMoneyListVO vo = new ProjectMoneyListVO();
                vo.setRoadName(road.getName());
                vo.setProjectName(project.getProjectName());
                vo.setProjectMoney(project.getProjectMoney());
                if (yearBudget != null) {
                    QueryWrapper detailedQueryWrapper = new QueryWrapper();
                    detailedQueryWrapper.eq((Object)"YEAR_BUDGET_ID_", (Object)yearBudget.getId());
                    detailedQueryWrapper.eq((Object)"IS_DELE_", (Object)"0");
                    detailedQueryWrapper.eq((Object)"BUDGET_CONTENT", (Object)project.getProjectName());
                    List detaileds = this.yearBudgetDetailedManager.list((Wrapper)detailedQueryWrapper);
                    if (detaileds.size() > 0) {
                        List worlMoneyF = detaileds.stream().filter(s -> s != null && s.getImageProgress() != null).map(YearBudgetDetailed::getImageProgress).collect(Collectors.toList());
                        for (BigDecimal pay : worlMoneyF) {
                            payMoney = payMoney.add(pay);
                        }
                    }
                }
                vo.setPayMoney(payMoney);
                if (!payMoney.equals(BigDecimal.ZERO) && !vo.getProjectMoney().equals(BigDecimal.ZERO)) {
                    vo.setPayRate(vo.getPayMoney().divide(vo.getProjectMoney(), 2, 0));
                } else {
                    vo.setPayRate(BigDecimal.ZERO);
                }
                vos.add(vo);
            }
        }
        return vos;
    }

    @Override
    public List<ProjectMoneyVO> getMoneyReport(String year, String orgId) {
        ArrayList<ProjectMoneyVO> vos = new ArrayList<ProjectMoneyVO>();
        QueryWrapper roadWrapper = new QueryWrapper();
        roadWrapper.eq((Object)"IS_DELE_", (Object)"0");
        roadWrapper.like((Object)"COMPANY_IDS_", (Object)orgId);
        List roads = this.roadManager.list((Wrapper)roadWrapper);
        for (Road road : roads) {
            ProjectMoneyVO vo = new ProjectMoneyVO();
            vo.setRoadName(road.getName());
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"IS_DELE_", (Object)"0");
            queryWrapper.eq((Object)"ROAD_SEGMENT_ID_", (Object)road.getId());
            queryWrapper.eq((Object)"PROJECT_YEAR_", (Object)year);
            List list = this.list((Wrapper)queryWrapper);
            BigDecimal payMoney = BigDecimal.ZERO;
            if (list.size() > 0) {
                vo.setProjectCount(list.size());
                vo.setProjectMoney(list.stream().map(p -> p.getProjectMoney()).reduce(BigDecimal.ZERO, BigDecimal::add));
                QueryWrapper queryWrapperYearBudget = new QueryWrapper();
                queryWrapperYearBudget.eq((Object)"IS_DELE_", (Object)"0");
                queryWrapperYearBudget.eq((Object)"ROAD_SEGMENT_ID_", (Object)road.getId());
                queryWrapperYearBudget.eq((Object)"ASCRIPTION_YEAR_", (Object)String.valueOf(year));
                YearBudget yearBudget = (YearBudget)((Object)this.yearBudgetManager.getOne((Wrapper)queryWrapperYearBudget));
                if (yearBudget != null) {
                    for (BizEngineeringProject project : list) {
                        QueryWrapper detailedQueryWrapper = new QueryWrapper();
                        detailedQueryWrapper.eq((Object)"YEAR_BUDGET_ID_", (Object)yearBudget.getId());
                        detailedQueryWrapper.eq((Object)"IS_DELE_", (Object)"0");
                        detailedQueryWrapper.eq((Object)"BUDGET_CONTENT", (Object)project.getProjectName());
                        List detaileds = this.yearBudgetDetailedManager.list((Wrapper)detailedQueryWrapper);
                        if (detaileds.size() <= 0) continue;
                        List worlMoneyF = detaileds.stream().filter(s -> s != null && s.getImageProgress() != null).map(YearBudgetDetailed::getImageProgress).collect(Collectors.toList());
                        for (BigDecimal pay : worlMoneyF) {
                            payMoney = payMoney.add(pay);
                        }
                    }
                }
            } else {
                vo.setProjectMoney(BigDecimal.ZERO);
            }
            vo.setPayMoney(payMoney);
            if (!payMoney.equals(BigDecimal.ZERO) && !vo.getProjectMoney().equals(BigDecimal.ZERO)) {
                vo.setPayRate(payMoney.divide(vo.getProjectMoney(), 2, 0));
            } else {
                vo.setPayRate(BigDecimal.ZERO);
            }
            vos.add(vo);
        }
        return vos;
    }

    @Override
    public List<ProjectReportVO> getReport(String year, String orgId) {
        ArrayList<ProjectReportVO> vos = new ArrayList<ProjectReportVO>();
        QueryWrapper roadWrapper = new QueryWrapper();
        roadWrapper.eq((Object)"IS_DELE_", (Object)"0");
        roadWrapper.like((Object)"COMPANY_IDS_", (Object)orgId);
        List roads = this.roadManager.list((Wrapper)roadWrapper);
        for (Road road : roads) {
            ProjectReportVO vo = new ProjectReportVO();
            vo.setRoadName(road.getName());
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"IS_DELE_", (Object)"0");
            queryWrapper.eq((Object)"ROAD_SEGMENT_ID_", (Object)road.getId());
            queryWrapper.eq((Object)"PROJECT_YEAR_", (Object)year);
            List list = this.list((Wrapper)queryWrapper);
            if (list.size() > 0) {
                vo.setProjectCount(list.size());
                vo.setProjectMoney(list.stream().map(p -> p.getProjectMoney()).reduce(BigDecimal.ZERO, BigDecimal::add));
                List spePoject = list.stream().filter(p -> p.getSpecialType().equals("0")).collect(Collectors.toList());
                List dayPoject = list.stream().filter(p -> p.getSpecialType().equals("1")).collect(Collectors.toList());
                vo.setSpecialCount(spePoject.size());
                vo.setSpecialMoney(spePoject.stream().map(p -> p.getProjectMoney()).reduce(BigDecimal.ZERO, BigDecimal::add));
                vo.setDailyCount(dayPoject.size());
                vo.setDailyMoney(dayPoject.stream().map(p -> p.getProjectMoney()).reduce(BigDecimal.ZERO, BigDecimal::add));
                vo.setStartCount(list.stream().filter(p -> p.getStartupFlag() > 0).collect(Collectors.toList()).size());
                vo.setUnStartCount(list.size() - vo.getStartCount());
                if (vo.getStartCount() > 0) {
                    vo.setStartRate(new BigDecimal(vo.getStartCount()).divide(new BigDecimal(list.size()), 2, 0));
                } else {
                    vo.setStartRate(new BigDecimal(0));
                }
            } else {
                vo.setDailyMoney(new BigDecimal(0));
                vo.setSpecialMoney(new BigDecimal(0));
                vo.setStartRate(new BigDecimal(0));
            }
            vos.add(vo);
        }
        return vos;
    }

    @Override
    public List<Org4ProjectMoneyVO> getProjectMoneyCount(String year) {
        String orgId = StringUtils.isNotEmpty((CharSequence)this.baseContext.getCurrentOrgId()) && !"0".equals(this.baseContext.getCurrentOrgId()) ? this.baseContext.getCurrentOrgId() : "1419863231459102720";
        List<Org4ProjectMoneyVO> lists = new ArrayList<Org4ProjectMoneyVO>();
        ArrayList<Org> rtnList = new ArrayList<Org>();
        QueryWrapper rgQueryWrapper = new QueryWrapper();
        rgQueryWrapper.eq((Object)"is_dele_", (Object)"0");
        List allList = this.orgDao.selectList((Wrapper)rgQueryWrapper);
        List<Org> list = BizEngineeringProjectManagerImpl.getOrgChild(allList, orgId, rtnList);
        for (Org org : list) {
            Org4ProjectMoneyVO fvo = new Org4ProjectMoneyVO();
            BeanUtils.copyProperties((Object)org, (Object)fvo);
            lists.add(fvo);
        }
        lists = BizEngineeringProjectManagerImpl.getMoneyChild(lists, orgId);
        return this.setMoneyCount(lists, year);
    }

    public Org4ProjectMoneyVO newMoneyCount(List<String> ids, Org4ProjectMoneyVO orgVO, String year) {
        QueryWrapper orderQueryWrapper = new QueryWrapper();
        orderQueryWrapper.in((Object)"ROAD_SEGMENT_ID_", ids);
        orderQueryWrapper.eq((Object)"PROJECT_YEAR_", (Object)year);
        orderQueryWrapper.eq((Object)"IS_DELE_", (Object)0);
        List list = this.list((Wrapper)orderQueryWrapper);
        if (list.size() > 0) {
            orgVO.setProjectMoney(list.stream().map(p -> p.getProjectMoney()).reduce(BigDecimal.ZERO, (b1, b2) -> b1.add((BigDecimal)b2)));
            List projectIds = list.stream().map(BizEngineeringProject::getId).collect(Collectors.toList());
            QueryWrapper payQueryWrapper = new QueryWrapper();
            payQueryWrapper.in((Object)"PROJECT_ID_", projectIds);
            payQueryWrapper.eq((Object)"IS_DELE_", (Object)0);
            List payments = this.measurementPaymentManager.list((Wrapper)payQueryWrapper);
            if (payments.size() > 0) {
                List payIdS = payments.stream().map(MeasurementPayment::getId).collect(Collectors.toList());
                QueryWrapper detatilQueryWrapper = new QueryWrapper();
                detatilQueryWrapper.in((Object)"MEASUREMENT_PAYMENT_ID_", payIdS);
                detatilQueryWrapper.isNotNull((Object)"PAID_MONEY_");
                List details = this.measurementPaymentDetailsManager.list((Wrapper)detatilQueryWrapper);
                if (details.size() > 0) {
                    orgVO.setPayMoney(details.stream().map(p -> p.getPaidMoney()).reduce(BigDecimal.ZERO, (b1, b2) -> b1.add((BigDecimal)b2)));
                } else {
                    orgVO.setPayMoney(new BigDecimal("0"));
                }
            } else {
                orgVO.setPayMoney(new BigDecimal("0"));
            }
            if ("4".equals(orgVO.getGrade())) {
                orgVO.setRoadSegmentId(((BizEngineeringProject)((Object)list.get(0))).getRoadSegmentId());
            }
            for (BizEngineeringProject project : list) {
                String regEx = "[^0-9]";
                Pattern p2 = Pattern.compile(regEx);
                Matcher m = p2.matcher(project.getWorkProgress());
                project.setPersent(BigDecimal.valueOf(Double.valueOf(m.replaceAll("").trim())));
            }
            orgVO.setProgress(BizEngineeringProjectManagerImpl.getPercent(list.stream().map(p -> p.getPersent()).reduce(BigDecimal.ZERO, (b1, b2) -> b1.add((BigDecimal)b2)), list.size() * 100));
        } else {
            orgVO.setPayMoney(new BigDecimal("0"));
            orgVO.setProgress("0.00%");
            orgVO.setProjectMoney(new BigDecimal("0"));
        }
        return orgVO;
    }

    public List<Org4ProjectMoneyVO> setMoneyCount(List<Org4ProjectMoneyVO> list, String year) {
        Iterator<Org4ProjectMoneyVO> it = list.iterator();
        while (it.hasNext()) {
            Org4ProjectMoneyVO orgVO = it.next();
            Integer grade = Integer.valueOf(orgVO.getGrade());
            List<String> roadList = new ArrayList<String>();
            if (grade < 4) {
                QueryWrapper roadQueryWrapper = new QueryWrapper();
                roadQueryWrapper.like((Object)"COMPANY_IDS_", (Object)orgVO.getId());
                roadList = this.roadManager.list((Wrapper)roadQueryWrapper).stream().map(Road::getId).collect(Collectors.toList());
            } else if (grade == 4) {
                QueryWrapper roadByNameQueryWrapper = new QueryWrapper();
                roadByNameQueryWrapper.eq((Object)"NAME_", (Object)orgVO.getName());
                roadList = this.roadManager.list((Wrapper)roadByNameQueryWrapper).stream().map(Road::getId).collect(Collectors.toList());
            }
            if (roadList.size() > 0) {
                orgVO = this.newMoneyCount(roadList, orgVO, year);
            } else {
                it.remove();
            }
            if (orgVO.getChirldren().size() <= 0 || Integer.valueOf(orgVO.getGrade()) >= 4) continue;
            this.setMoneyCount(orgVO.getChirldren(), year);
        }
        return list;
    }

    public static List<Org4ProjectMoneyVO> getMoneyChild(List<Org4ProjectMoneyVO> allList, String pCode) {
        ArrayList<Org4ProjectMoneyVO> returnList = new ArrayList<Org4ProjectMoneyVO>();
        for (Org4ProjectMoneyVO entity : allList) {
            if (!pCode.equals(entity.getParentId())) continue;
            entity.setChirldren(BizEngineeringProjectManagerImpl.getMoneyChild(allList, entity.getId()));
            returnList.add(entity);
        }
        return returnList;
    }

    @Override
    public List<Org4ProjectVO> getProjectCount(String year) {
        String orgId = StringUtils.isNotEmpty((CharSequence)this.baseContext.getCurrentOrgId()) && !"0".equals(this.baseContext.getCurrentOrgId()) ? this.baseContext.getCurrentOrgId() : "1419863231459102720";
        List<Org4ProjectVO> lists = new ArrayList<Org4ProjectVO>();
        ArrayList<Org> rtnList = new ArrayList<Org>();
        QueryWrapper rgQueryWrapper = new QueryWrapper();
        rgQueryWrapper.eq((Object)"is_dele_", (Object)"0");
        List allList = this.orgDao.selectList((Wrapper)rgQueryWrapper);
        List<Org> list = BizEngineeringProjectManagerImpl.getOrgChild(allList, orgId, rtnList);
        for (Org org : list) {
            Org4ProjectVO fvo = new Org4ProjectVO();
            BeanUtils.copyProperties((Object)org, (Object)fvo);
            lists.add(fvo);
        }
        lists = BizEngineeringProjectManagerImpl.getChild(lists, orgId);
        return this.setCount(lists, year);
    }

    public List<Org4ProjectVO> setCount(List<Org4ProjectVO> list, String year) {
        Iterator<Org4ProjectVO> it = list.iterator();
        while (it.hasNext()) {
            Org4ProjectVO orgVO = it.next();
            Integer grade = Integer.valueOf(orgVO.getGrade());
            List<String> roadList = new ArrayList<String>();
            if (grade < 4) {
                QueryWrapper roadQueryWrapper = new QueryWrapper();
                roadQueryWrapper.like((Object)"COMPANY_IDS_", (Object)orgVO.getId());
                roadList = this.roadManager.list((Wrapper)roadQueryWrapper).stream().map(Road::getId).collect(Collectors.toList());
            } else if (grade == 4) {
                QueryWrapper roadByNameQueryWrapper = new QueryWrapper();
                roadByNameQueryWrapper.eq((Object)"NAME_", (Object)orgVO.getName());
                roadList = this.roadManager.list((Wrapper)roadByNameQueryWrapper).stream().map(Road::getId).collect(Collectors.toList());
            }
            if (roadList.size() > 0) {
                orgVO = this.newCountWorkOrder(roadList, orgVO, year);
            } else {
                it.remove();
            }
            if (orgVO.getChirldren().size() <= 0 || Integer.valueOf(orgVO.getGrade()) >= 4) continue;
            this.setCount(orgVO.getChirldren(), year);
        }
        return list;
    }

    public static String getPercent(BigDecimal x, int y) {
        double d1 = x.doubleValue();
        double d2 = (double)y * 1.0;
        NumberFormat percentInstance = NumberFormat.getPercentInstance();
        percentInstance.setMinimumFractionDigits(2);
        return percentInstance.format(d1 / d2);
    }

    public Org4ProjectVO newCountWorkOrder(List<String> ids, Org4ProjectVO orgVO, String year) {
        QueryWrapper orderQueryWrapper = new QueryWrapper();
        orderQueryWrapper.in((Object)"ROAD_SEGMENT_ID_", ids);
        orderQueryWrapper.eq((Object)"PROJECT_YEAR_", (Object)year);
        orderQueryWrapper.eq((Object)"IS_DELE_", (Object)0);
        List list = this.list((Wrapper)orderQueryWrapper);
        if (list.size() > 0) {
            orgVO.setProjectMoney(list.stream().map(p -> p.getProjectMoney()).reduce(BigDecimal.ZERO, (b1, b2) -> b1.add((BigDecimal)b2)));
            List projectIds = list.stream().map(BizEngineeringProject::getId).collect(Collectors.toList());
            QueryWrapper contractQueryWrapper = new QueryWrapper();
            contractQueryWrapper.in((Object)"PROJECT_ID_", projectIds);
            contractQueryWrapper.eq((Object)"IS_DELE_", (Object)0);
            contractQueryWrapper.isNotNull((Object)"CONTRACT_AMOUNT_");
            List contracts = this.bizProjectContractManager.list((Wrapper)contractQueryWrapper);
            if (contracts.size() > 0) {
                orgVO.setContractMoney(contracts.stream().map(p -> new BigDecimal(p.getContractAmount())).reduce(BigDecimal.ZERO, (b1, b2) -> b1.add((BigDecimal)b2)));
            } else {
                orgVO.setContractMoney(new BigDecimal("0"));
            }
            QueryWrapper payQueryWrapper = new QueryWrapper();
            payQueryWrapper.in((Object)"PROJECT_ID_", projectIds);
            payQueryWrapper.eq((Object)"IS_DELE_", (Object)0);
            List payments = this.measurementPaymentManager.list((Wrapper)payQueryWrapper);
            if (payments.size() > 0) {
                List payIdS = payments.stream().map(MeasurementPayment::getId).collect(Collectors.toList());
                QueryWrapper detatilQueryWrapper = new QueryWrapper();
                detatilQueryWrapper.in((Object)"MEASUREMENT_PAYMENT_ID_", payIdS);
                detatilQueryWrapper.isNotNull((Object)"PAID_MONEY_");
                List details = this.measurementPaymentDetailsManager.list((Wrapper)detatilQueryWrapper);
                if (details.size() > 0) {
                    orgVO.setPayMoney(details.stream().map(p -> p.getPaidMoney()).reduce(BigDecimal.ZERO, (b1, b2) -> b1.add((BigDecimal)b2)));
                } else {
                    orgVO.setPayMoney(new BigDecimal("0"));
                }
            } else {
                orgVO.setPayMoney(new BigDecimal("0"));
            }
            if ("4".equals(orgVO.getGrade())) {
                orgVO.setRoadSegmentId(((BizEngineeringProject)((Object)list.get(0))).getRoadSegmentId());
            }
            for (BizEngineeringProject project : list) {
                String regEx = "[^0-9]";
                Pattern p2 = Pattern.compile(regEx);
                Matcher m = p2.matcher(project.getWorkProgress());
                project.setPersent(BigDecimal.valueOf(Double.valueOf(m.replaceAll("").trim())));
            }
            orgVO.setProgress(BizEngineeringProjectManagerImpl.getPercent(list.stream().map(p -> p.getPersent()).reduce(BigDecimal.ZERO, (b1, b2) -> b1.add((BigDecimal)b2)), list.size() * 100));
        } else {
            orgVO.setPayMoney(new BigDecimal("0"));
            orgVO.setProgress("0.00%");
            orgVO.setProjectMoney(new BigDecimal("0"));
            orgVO.setContractMoney(new BigDecimal("0"));
        }
        return orgVO;
    }

    public static List<Org> getOrgChild(List<Org> orgList, String parentId, List<Org> rtnList) {
        for (Org org : orgList) {
            if (!parentId.equals(org.getParentId())) continue;
            BizEngineeringProjectManagerImpl.getOrgChild(orgList, org.getId(), rtnList);
            rtnList.add(org);
        }
        return rtnList;
    }

    public static List<Org4ProjectVO> getChild(List<Org4ProjectVO> allList, String pCode) {
        ArrayList<Org4ProjectVO> returnList = new ArrayList<Org4ProjectVO>();
        for (Org4ProjectVO entity : allList) {
            if (!pCode.equals(entity.getParentId())) continue;
            entity.setChirldren(BizEngineeringProjectManagerImpl.getChild(allList, entity.getId()));
            returnList.add(entity);
        }
        return returnList;
    }

    @Override
    public PageList<BizEngineeringProject> queryBizEngineeringProject(QueryFilter<BizEngineeringProject> queryFilter) {
        IPage<BizEngineeringProject> result = ((BizEngineeringProjectDao)this.baseMapper).queryBizEngineeringProject((IPage<BizEngineeringProject>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BizEngineeringProject>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(result);
    }

    @Override
    public BizEngineeringProject getBizEngineeringProjectById(String id) {
        BizEngineeringProject bizEngineeringProject = (BizEngineeringProject)((Object)((BizEngineeringProjectDao)this.baseMapper).selectById((Serializable)((Object)id)));
        return bizEngineeringProject;
    }

    @Override
    public void updateFlag(String ids, Integer flag) {
        List<String> idsList = Arrays.asList(ids.split(","));
        UpdateWrapper updateWrapper = new UpdateWrapper();
        ((UpdateWrapper)updateWrapper.set((Object)"VALID_FLAG_", (Object)flag)).in((Object)"ID_", idsList);
        this.bizEngineeringProjectDao.update(null, (Wrapper)updateWrapper);
    }

    @Override
    public void saveVo(BizEngineeringProjectVo bizEngineeringProjectVo) {
        BizEngineeringProject bizEngineeringProject = bizEngineeringProjectVo.getBizEngineeringProject();
        if (StringUtils.isNotEmpty((CharSequence)this.baseContext.getCurrentOrgId())) {
            bizEngineeringProject.setCompanyId(this.baseContext.getCurrentOrgId());
        }
        if (StringUtils.isNotEmpty((CharSequence)this.baseContext.getCurrentOrgName())) {
            bizEngineeringProject.setCompanyName(this.baseContext.getCurrentOrgName());
        }
        this.create((Model)bizEngineeringProject);
        List<BizEngineeringAccessories> bizEngineeringAccessoriesList = bizEngineeringProjectVo.getBizEngineeringAccessoriesList();
        String sourceId = bizEngineeringProject.getId();
        bizEngineeringAccessoriesList.forEach(s -> {
            s.setSourceId(sourceId);
            s.setValidFlag(1);
        });
        this.bizEngineeringAccessoriesManager.saveOrUpdateBatch(bizEngineeringAccessoriesList);
    }

    @Override
    public void updateVo(BizEngineeringProjectVo bizEngineeringProjectVo) {
        BizEngineeringProject bizEngineeringProject = bizEngineeringProjectVo.getBizEngineeringProject();
        this.update((Model)bizEngineeringProject);
        String sourceId = bizEngineeringProject.getId();
        List<BizEngineeringAccessories> bizEngineeringAccessoriesList = bizEngineeringProjectVo.getBizEngineeringAccessoriesList();
        this.bizEngineeringAccessoriesManager.removeEngineeringAccessories(sourceId);
        bizEngineeringAccessoriesList.forEach(s -> {
            s.setSourceId(sourceId);
            s.setValidFlag(1);
        });
        this.bizEngineeringAccessoriesManager.saveOrUpdateBatch(bizEngineeringAccessoriesList);
    }

    @Override
    public BizEngineeringProjectVo getVo(String id) {
        BizEngineeringProjectVo bizEngineeringProjectVo = new BizEngineeringProjectVo();
        BizEngineeringProject bizEngineeringProject = (BizEngineeringProject)((Object)this.getById((Serializable)((Object)id)));
        List<BizEngineeringAccessories> engineeringAccessories = this.bizEngineeringAccessoriesManager.getEngineeringAccessoriesBySourceId(id);
        bizEngineeringProjectVo.setBizEngineeringProject(bizEngineeringProject);
        bizEngineeringProjectVo.setBizEngineeringAccessoriesList(engineeringAccessories);
        return bizEngineeringProjectVo;
    }
}

