/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.yhxt.File;

import com.artfess.base.annotation.ApiGroup;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/yhxt/api/file"})
@RestController
@Api(tags={"\u6587\u4ef6\u4e0b\u8f7d"})
@ApiGroup(group={"group_biz"})
public class FileDownController {
    private static final Logger log = LoggerFactory.getLogger(FileDownController.class);
    private static Map<Integer, List<String>> fileMap = new HashMap<Integer, List<String>>(16);

    @ApiOperation(value="\u6587\u4ef6-\u6839\u636e\u7c7b\u578b\u4e0b\u8f7d")
    @ApiImplicitParams(value={@ApiImplicitParam(paramType="query", name="fileType", value="\u6587\u4ef6\u7c7b\u578b 1-\u5e94\u6025\u7269\u8d44\u660e\u7ec6\u5bfc\u5165\u6a21\u7248", required=true)})
    @GetMapping(value={"/download"})
    public void download(Integer fileType, HttpServletResponse response) {
        if (null == fileType) {
            throw new RuntimeException("\u8bf7\u9009\u62e9\u6587\u4ef6");
        }
        String exMsg = "\u6839\u636e\u7c7b\u578b\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25";
        List<String> list = fileMap.get(fileType);
        try {
            OutputStream os = null;
            for (String path : list) {
                ClassPathResource resource = new ClassPathResource(path);
                byte[] buffer = new byte[1024];
                InputStream fis = resource.getInputStream();
                BufferedInputStream bis = new BufferedInputStream(fis);
                int i = bis.read(buffer);
                os = response.getOutputStream();
                response.setHeader("content-type", "application/octet-stream");
                response.setContentType("application/octet-stream");
                response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(resource.getFilename(), "UTF-8"));
                while (i != -1) {
                    os.write(buffer, 0, i);
                    i = bis.read(buffer);
                }
                bis.close();
            }
            if (null != os) {
                os.flush();
                os.close();
            }
        }
        catch (Exception e) {
            log.error("\u6839\u636e\u7c7b\u578b\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25", (Throwable)e);
        }
    }

    static {
        fileMap.put(1, Arrays.asList("file/\u5e94\u6025\u7269\u8d44\u660e\u7ec6\u5bfc\u5165\u6a21\u7248.xlsx"));
        fileMap.put(2, Arrays.asList("file/MQI\u5bfc\u5165\u6a21\u7248.xlsx"));
    }
}

