package com.artfess.service.model;

import com.artfess.base.service.InvokeResult;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.IOException;
import java.io.Serializable;
import java.util.List;

/**
 * 调用服务的返回值对象
 *
 * @company 广州宏天软件股份有限公司
 * @author heyifan
 * @email heyf@jee-soft.cn
 * @date 2018年7月3日
 */
@ApiModel(description="调用服务的返回值对象")
public class DefaultInvokeResult implements InvokeResult, Serializable{
	private static final long serialVersionUID = 1L;
	
	@ApiModelProperty(name="obj", notes="单个对象的返回值")
	private Object obj;
	@ApiModelProperty(name="list", notes="列表类型的返回值")
	private List<Object> list;
	@ApiModelProperty(name="ex", notes="调用服务时出现异常")
	private Exception ex;
	@ApiModelProperty(name="json", notes="以json格式返回结果")
	private String json;
	
	// 请求和响应的XML信息，便于调试和日志记录
	private String requestXml;
	private String responseXml;

	public Object getObject() {
		return obj;
	}

	public void setObject(Object obj) {
		this.obj = obj;
	}
	
	public void setList(List<Object> list) {
		this.list = list;
	}
	
	public List<Object> getList(){
		return list;
	}

	public Exception getException() {
		return ex;
	}

	public void setException(Exception ex) {
		this.ex = ex;
	}

	public String getJson() {
		if (StringUtil.isEmpty(json)) {
			try {
				json = JsonUtil.toJson(obj);
			} catch (IOException e) {
			}
		}
		return json;
	}

	public void setJson(String json) {
		this.json = json;
	}

	public Boolean isVoid() {
		return BeanUtils.isEmpty(obj)&&BeanUtils.isEmpty(list);
	}
	
	public Boolean isList(){
		return BeanUtils.isNotEmpty(list);
	}
	
	public Boolean isFault(){
		return BeanUtils.isNotEmpty(ex);
	}

	public String getRequestXml() {
		return requestXml;
	}

	public void setRequestXml(String requestXml) {
		this.requestXml = requestXml;
	}

	public String getResponseXml() {
		return responseXml;
	}

	public void setResponseXml(String responseXml) {
		this.responseXml = responseXml;
	}

}
