package com.artfess.portal.persistence.manager.impl;

import com.artfess.base.cache.CacheManager;
import com.artfess.base.cache.ICache;
import com.artfess.base.cache.setting.CacheSetting;
import com.artfess.portal.persistence.manager.SysRedisCacheManager;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * @Program: edp
 * @Date: 2021/3/9
 * @Author: ZQF
 * @Description: redis 缓存管理
 */
@Service
public class SysRedisCacheManagerImpl implements SysRedisCacheManager {

    private final CacheManager cacheManager;

    private final RedisTemplate<String, Object> redisTemplate;

    public SysRedisCacheManagerImpl(CacheManager cacheManager, RedisTemplate<String, Object> redisTemplate) {
        this.cacheManager = cacheManager;
        this.redisTemplate = redisTemplate;
    }

    @Override
    public Map<String, Object> getAllCache(String key) {
//        Set<String> keys = redisTemplate.keys("*");
        Map<String, Object> map = new HashMap<>();
        // 获取所有缓存名称的集合
        Collection<String> cacheNames = cacheManager.getCacheNames();
        cacheNames.forEach(s -> {
            ICache redis = cacheManager.getCache(s, CacheSetting.buildDefault(s));
            Map<String, Object> keysValues = redis.getKeysValues(s);
            if (Objects.nonNull(keysValues)) {
                map.putAll(keysValues);
            }
        });
        // 根据条件进行筛选
        Map<String, Object> collect = new HashMap<>();
        if (StringUtils.isNotBlank(key)) {
            collect = map.entrySet()
                    .stream()
                    .filter(x -> x.getKey().contains(key))
                    .collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        } else {
            collect = map;
        }

//        ICache redis = cacheManager.getCache("*", CacheSetting.buildDefault("*"));

//        int i = 1;
//        assert keys != null;
//        for (String key : keys) {
////            System.out.println(key);
//            String value = redis.get(key, String.class);
//            if (StringUtils.isBlank(value)) {
//                value = i++ + "";
//            }
//            map.put(key, value);
//        }

//        Map<String, Object> map1 = new HashMap<>();
//        cacheNames.forEach(s -> {
//            System.out.println(s);
//            ICache redis1 = cacheManager.getCache(s, CacheSetting.buildDefault(s));
//            List<Object> rightKeys = redis1.getRightKeys(s);
//            map1.put(s, rightKeys);
//        });
        return collect;
    }

//    @Override
//    public String deleteCache(String cacheKey) {
//        return "success";
//    }
}
