package com.artfess.application.controller;

import com.artfess.application.model.MessageConfig;
import com.artfess.application.model.MsgTemplate;
import com.artfess.application.persistence.manager.MessageConfigManager;
import com.artfess.application.persistence.manager.MsgTemplateManager;
import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.feign.UCFeignService;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.uc.api.service.IUserService;
import com.artfess.uc.manager.OrgManager;
import com.artfess.uc.model.Org;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

/**
 * <pre>
 * 描述：portal_message_config 系统配置类
 * 作者:wangping
 * 日期:2021-06-18 21:34:36
 * 版权：artfess
 * </pre>
 */
@RestController
@RequestMapping(value = "/msg/messageConfig/v1")
@Api(tags = "消息配置")
@ApiGroup(group = {ApiGroupConsts.GROUP_APPLICATION})
public class MessageConfigController extends BaseController<MessageConfigManager,MessageConfig> {
    @Resource
    MessageConfigManager messageConfigManager;
    @Resource
    MsgTemplateManager msgTemplateManager;
    @Autowired
    OrgManager orgService;
    @Resource
    IUserService userService;
    @Resource
    UCFeignService ucFeignService;
    @Resource
    OrgManager orgManager;

    /**
     * 消息配置列表(分页条件查询)数据
     *
     * @param queryFilter
     * @return
     * @throws Exception PageJson
     * @throws
     */
    @PostMapping("/list")
    @ApiOperation(value = "消息配置列表", httpMethod = "POST", notes = "获取消息配置列表")
    public PageList<MessageConfig> list(@ApiParam(name = "queryFilter", value = "查询对象") @RequestBody QueryFilter<MessageConfig> queryFilter) throws Exception {
        return messageConfigManager.query(queryFilter);
    }
    /**
     * 根据ID获取配置
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "getById", method = RequestMethod.GET, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "根据ID获取内容", httpMethod = "GET", notes = "根据ID获取内容")
    public MessageConfig getById(
            @ApiParam(name = "id", value = "id", required = true) @RequestParam String id) {
        MessageConfig messageConfig = messageConfigManager.getById(id);
        return messageConfig;
    }

    /**
     * 新增消息配置
     *
     * @param
     * @return
     * @throws Exception
     * @throws
     */
    @PostMapping(value = "/save")
    @ApiOperation(value = "新增,更新消息配置", httpMethod = "POST", notes = "新增,更新消息配置")
    public CommonResult<String> save(@ApiParam(name = "MessageConfig", value = "消息配置", required = true) @RequestBody MessageConfig messageConfig) throws Exception {
//        IUserService userService = AppUtil.getBean(IUserService.class);
//        List<IUser> list1 = userService.getUserByAccounts("admin,guest");
//        System.out.println(list1);
        String msg = "添加消息配置成功";
        boolean isExist = false;
        if (ObjectUtils.isNotEmpty(messageConfig)) {
            QueryFilter queryFilter = QueryFilter.build().withDefaultPage();
            String id = messageConfig.getId();
            String code = messageConfig.getCode();
            if (StringUtils.isNotBlank(id)) {
                queryFilter.addFilter("id_", id, QueryOP.NOT_IN);
            }
            if (StringUtils.isNotBlank(code)) {
                queryFilter.addFilter("code_", code, QueryOP.EQUAL);
            }
            PageList<MessageConfig> query = baseService.query(queryFilter);
            isExist = query.getRows().size() > 0;
        }
        if (isExist) {
            return new CommonResult<>(false, "配置编号已经存在，添加失败", null);
        } else {
            System.out.println(messageConfig.getUserConfigType());
            if (messageConfig.getUserConfigType() == 2){//判断接收配置是否为固定
                String userStr = messageConfig.getUserStr();
                if (StringUtils.isNotBlank(userStr)){
                    List<Map<String,Object>> list = JsonUtil.toBean(userStr, List.class);
                   String userId = "";
                   String orgId ="";
                   for(Map<String,Object> m : list){
                       String type = String.valueOf(m.get("type"));
                       if("user".equalsIgnoreCase(type)){
                           String codes = String.valueOf(m.get("codes"));
                           if(StringUtils.isBlank(codes)){continue;}
                           ArrayNode userByAccounts = ucFeignService.getUserByAccounts(codes);
                           for (JsonNode userByAccount : userByAccounts) {
                               String id = userByAccount.get("id").toString();
                               if (StringUtils.isNotBlank(id)) {
                                   userId = id.replace("\"", "").replace("\"", "")+",";
                               }

                           }

                      /*     if(userId.lastIndexOf(",")){

                           }*/
                       }
                       if("org".equalsIgnoreCase(type)){
                           String codes = String.valueOf(m.get("codes"));
                           //String[] split = codes.split(",");
                           if(StringUtils.isBlank(codes))continue;
//                           List<String> stringList = Arrays.asList(split);

                           List<Org> userList = this.orgManager.getOrgByAccount(codes);
                           for (Org org : userList) {

                               orgId=  org.getId()+",";
                           }

                       }

                   }
                    int i = userId.lastIndexOf(",");

//                    messageConfig.setOrgId(orgId);
                    messageConfig.setOrgId(orgId.substring(0,orgId.lastIndexOf(",")));
                    //messageConfig.setUserId(userId);
                    messageConfig.setUserId(userId.substring(0,userId.lastIndexOf(",")));
                    }
            }
            if (StringUtil.isEmpty(messageConfig.getId())) {
                baseService.create(messageConfig);
            } else {
                baseService.update(messageConfig);
                msg = "更新消息配置成功";
            }
            return new CommonResult<String>(msg);
        }
    }



    /**
     * 删除消息配置
     *
     * @param id
     * @return
     * @throws Exception
     * @throws
     */
    @DeleteMapping(value = "/remove/{id}")
    @ApiOperation(value = "删除消息配置", httpMethod = "DELETE", notes = "删除消息配置")
    public CommonResult<String> remove(@ApiParam(name = "id", value = "业务主键", required = true) @PathVariable String id) throws Exception {
        String tplKey = messageConfigManager.get(id).getTplKey();
        MsgTemplate msgTemplate = msgTemplateManager.gettypeKey(tplKey);
        if (msgTemplate==null) {
            messageConfigManager.remove(id);
            return new CommonResult<String>(true, "删除成功");
        }else{
            return new CommonResult<String>(false, "该配置已被应用，删除失败！");
        }
    }

    /**
     * 批量删除消息配置
     *
     * @param ids
     * @return
     * @throws Exception
     * @throws
     */
    @DeleteMapping(value = "/removes")
    @ApiOperation(value = "批量删除消息配置", httpMethod = "DELETE", notes = "批量删除消息配置")
    public CommonResult<String> removes(@ApiParam(name = "ids", value = "多个主键之间用逗号分隔", required = true) @RequestParam String... ids) throws Exception {
        String msg = "删除消息分类成功";
        for (int i = 0; i < ids.length; i++) {
            String name = messageConfigManager.get(ids[i]).getName();
            String tplKey = messageConfigManager.get(ids[i]).getTplKey();
            MsgTemplate msgTemplate = msgTemplateManager.gettypeKey(tplKey);
            if (msgTemplate != null) {
                msg = name+"删除消息分类失败";
            }else{
                messageConfigManager.removeByIds(Arrays.asList(ids[i]));
            }
        }
        return new CommonResult<String>(msg);
    }


    @RequestMapping(value = "listJson", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "消息配置列表(分页条件查询)数据", httpMethod = "POST", notes = "消息配置列表(分页条件查询)数据")
    public PageList<MessageConfig> listJson(@ApiParam(name = "queryFilter", value = "通用查询对象") @RequestBody QueryFilter<MessageConfig> queryFilter) throws Exception {
//        queryFilter.addFilter("ucuser.IS_DELE_", User.DELETE_NO, QueryOP.EQUAL, FieldRelation.AND, "delete_group");
//        queryFilter.addFilter("ucuser.STATUS_", User.STATUS_NORMAL, QueryOP.EQUAL, FieldRelation.AND, "delete_group");

        PageList<MessageConfig> sysMsgConfigList = messageConfigManager.queryByTemplateName(queryFilter);
        return sysMsgConfigList;
    }


}
