/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cqxy.projectManagement.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.cqxy.constructionPermit.manager.ConstructionPermitManager;
import com.artfess.cqxy.processManagermant.manager.ProgressManageManager;
import com.artfess.cqxy.processManagermant.manager.ProgressManageReportManager;
import com.artfess.cqxy.processManagermant.model.ProgressManageReport;
import com.artfess.cqxy.projectManagement.manager.ProjectManagementManager;
import com.artfess.cqxy.projectManagement.manager.ProjectPersonnelManager;
import com.artfess.cqxy.projectManagement.model.ProjectManagement;
import com.artfess.cqxy.projectManagement.vo.MergeItemsVo;
import com.artfess.cqxy.projectManagement.vo.ProjectCostConsultationVo;
import com.artfess.cqxy.projectManagement.vo.ProjectLandCostVo;
import com.artfess.cqxy.projectManagement.vo.ProjectParentIdsVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@Api(tags={"\u9879\u76ee\u7ba1\u7406-\u9879\u76ee\u7ba1\u7406\u63a5\u53e3"})
@ApiGroup(group={"group_biz"})
@RequestMapping(value={"/biz/projectManagement/pm/v1"})
public class ProjectManagementController
extends BaseController<ProjectManagementManager, ProjectManagement> {
    private static final Logger log = LoggerFactory.getLogger(ProjectManagementController.class);
    @Autowired
    ProjectPersonnelManager projectPersonnelManager;
    @Autowired
    ProgressManageReportManager progressManageReportManager;
    @Autowired
    ProgressManageManager progressManageManager;
    @Autowired
    private ConstructionPermitManager constructionPermitManager;

    @PostMapping(value={"/save"})
    @ApiOperation(value="S-\u4fdd\u5b58\u6216\u4fee\u6539\u6570\u636e", httpMethod="POST")
    public CommonResult<String> save(@ApiParam(name="pmObject", value="\u9879\u76ee\u7ba1\u7406\u4fe1\u606f\u8868\u5bf9\u8c61") @RequestBody ProjectManagement pmObject) {
        Assert.notNull((Object)pmObject.getProjectCode(), (String)"\u9879\u76ee\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        String msg = "";
        boolean save = false;
        if (pmObject != null && StringUtils.isBlank((CharSequence)pmObject.getParentId())) {
            pmObject.setParentId("root");
        }
        if (StringUtils.isEmpty((CharSequence)pmObject.getId())) {
            pmObject.setIsDele("0");
            pmObject.setValidFlag(1);
            pmObject.setSn(((ProjectManagementManager)this.baseService).createSnNum());
            save = ((ProjectManagementManager)this.baseService).savePm(pmObject);
            msg = save ? "\u6dfb\u52a0\u6210\u529f" : "\u6dfb\u52a0\u5931\u8d25";
        } else {
            save = ((ProjectManagementManager)this.baseService).updateById((Object)pmObject);
            msg = save ? "\u4fee\u6539\u6210\u529f" : "\u4fee\u6539\u5931\u8d25";
        }
        String projectManagerId = pmObject.getProjectManagerId();
        this.projectPersonnelManager.linkUsersByProjectManager(pmObject.getId(), projectManagerId);
        ((ProjectManagementManager)this.baseService).updateHasChildrenByParentId(pmObject.getId());
        return new CommonResult(save, msg);
    }

    @PostMapping(value={"/importExcelData"})
    @ApiOperation(value="S-\u6279\u91cf\u5bfc\u5165Excel\u6570\u636e")
    public CommonResult importExcelData(@ApiParam(value="\u4e0a\u4f20\u6587\u4ef6") @RequestParam(value="file") MultipartFile file, String projectId) {
        ((ProjectManagementManager)this.baseService).importExcelData(file);
        return new CommonResult("\u5bfc\u5165\u6210\u529f");
    }

    @PostMapping(value={"/exportDataToExcel"})
    @ApiOperation(value="S-\u5bfc\u51fa\u6570\u636e\u5230Excel", notes="\u53c2\u6570\u8bf4\u660e\uff1apageBean\u4f20\u5165pageSize\u4e3a-1\u4e0d\u5206\u9875\u67e5\u8be2\u6240\u6709\u6570\u636e\u540e\u5bfc\u51fa\u5230Excel\uff0c\u53ef\u4ee5\u5e26\u5176\u4ed6\u67e5\u8be2\u53c2\u6570\uff0c\u4f46\u662fpageSize\u5fc5\u987b\u4e3a-1")
    public CommonResult exportDataToExcel(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5668") @RequestBody QueryFilter<ProjectManagement> queryFilter, HttpServletResponse response) throws IOException {
        ((ProjectManagementManager)this.baseService).exportDatatoExcel(queryFilter, response);
        return new CommonResult("\u5bfc\u5165\u6210\u529f");
    }

    @PostMapping(value={"/delete"})
    @ApiOperation(value="S-\u5220\u9664\u6570\u636e", httpMethod="POST")
    public CommonResult delete(@ApiParam(name="ids", value="ID\u96c6\u5408") @RequestParam(value="ids") String ids) {
        Assert.notNull((Object)ids, (String)"\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        boolean state = ((ProjectManagementManager)this.baseService).removeByIds(Arrays.asList(ids.split(",")));
        String msg = state ? "\u5220\u9664\u6210\u529f" : "\u5220\u9664\u5931\u8d25";
        return new CommonResult(state, msg);
    }

    @PostMapping(value={"/updateSequence"})
    @ApiOperation(value="S-\u4fee\u6539\u9879\u76ee\u6392\u5e8f\u53f7", notes="\u524d\u7aef\u62d6\u52a8\u8bb0\u5f55\u8fdb\u884c\u6392\u5e8f\uff0c\u90a3\u4e48\u8981\u4f20\u5165\u53d1\u751f\u53d8\u52a8\u7684\u8bb0\u5f55\u7684ID\u53ca\u6392\u5e8f\u53f7\uff0c\u5982\"params\":{\"ID\u503c\":\"\u6392\u5e8f\u53f7\",\"ID\u503c\":\"\u6392\u5e8f\u53f7\"}", httpMethod="POST")
    public CommonResult sort(@ApiParam(name="params", value="\u53c2\u6570\u8bf4\u660e\uff1aKey\uff1aID\uff0cValue\uff1a\u6392\u5e8f\u53f7") @RequestBody HashMap<String, Integer> params) {
        ((ProjectManagementManager)this.baseService).updateSequence(params);
        return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f");
    }

    @PostMapping(value={"/totalEnable/{id}"})
    @ApiOperation(value="S-\u542f\u7981\u7528\u9879\u76ee", httpMethod="POST")
    public CommonResult totalEnable(@ApiParam(name="id", value="\u4e3b\u952eID") @PathVariable String id) {
        ProjectManagement recoded = (ProjectManagement)((Object)((ProjectManagementManager)this.baseService).getById((Serializable)((Object)id)));
        int validFlag = recoded.getValidFlag() == 0 ? 1 : 0;
        recoded.setValidFlag(validFlag);
        boolean update = ((ProjectManagementManager)this.baseService).updateById((Object)recoded);
        String msg = (validFlag == 1 ? "\u542f\u7528" : "\u7981\u7528") + (update ? "\u6210\u529f" : "\u5931\u8d25");
        return new CommonResult(update, msg);
    }

    @PostMapping(value={"/currentProject/{id}"})
    @ApiOperation(value="S-\u8bbe\u4e3a\u5f53\u524d\u9879\u76ee", httpMethod="POST")
    public CommonResult currentProject(@ApiParam(name="id", value="\u4e3b\u952eID") @PathVariable String id) {
        boolean flag = ((ProjectManagementManager)this.baseService).setCurrentProject(id) == 1;
        String msg = flag ? "\u64cd\u4f5c\u6210\u529f" : "\u64cd\u4f5c\u5931\u8d25";
        return new CommonResult(flag, msg);
    }

    @PostMapping(value={"/detail/{id}"})
    @ApiOperation(value="S-\u6839\u636eID\u67e5\u8be2\u8be6\u60c5", httpMethod="POST")
    public CommonResult<ProjectManagement> selectOne(@ApiParam(name="id", value="\u4e3b\u952eID") @PathVariable String id) {
        Assert.notNull((Object)id, (String)"\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        ProjectManagement result = (ProjectManagement)((Object)((ProjectManagementManager)this.baseService).getById((Serializable)((Object)id)));
        boolean state = !BeanUtils.isEmpty((Object)((Object)result));
        return new CommonResult(state, state ? "\u64cd\u4f5c\u6210\u529f" : "\u8be5ID\u6ca1\u6709\u5bf9\u5e94\u6570\u636e", (Object)result);
    }

    @PostMapping(value={"/page"})
    @ApiOperation(value="S-\u5206\u9875\u67e5\u8be2\u6240\u6709\u6570\u636e", notes="\u53c2\u6570\u8bf4\u660e\uff1apageBean\u4f20\u5165pageSize\u4e3a-1\u8868\u793a\u4e0d\u5206\u9875\u67e5\u8be2\uff0c\u5728\u901a\u7528\u67e5\u8be2\u5668\u4e2d\u7684query\u5bf9\u8c61\u7ec4\u4f20\u5165\u67e5\u8be2\u53c2\u6570", httpMethod="POST")
    public CommonResult<PageList<ProjectManagement>> page(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5668") @RequestBody QueryFilter<ProjectManagement> queryFilter) {
        PageList<ProjectManagement> result = ((ProjectManagementManager)this.baseService).queryAllByPage(queryFilter);
        List rows = result.getRows();
        for (ProjectManagement pm : rows) {
            BigDecimal projectOvervie;
            ProgressManageReport overvieByProjectId = this.progressManageReportManager.getProjectOvervieByProjectId(pm.getId());
            if (overvieByProjectId != null) {
                pm.setConstructionProgress(overvieByProjectId.getWeeklyMouthlyWork());
            }
            if ((projectOvervie = this.progressManageManager.geTamountAppropriatedTotalByProjectId(pm.getId())) != null) {
                BigDecimal bigDecimal = projectOvervie.divide(new BigDecimal(10000)).stripTrailingZeros().setScale(0, 5);
                pm.setAccumulatedProjectPayment(bigDecimal);
            }
            if (null == pm.getProjectMoney()) continue;
            pm.setProjectMoney(pm.getProjectMoney().stripTrailingZeros());
        }
        return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f", result);
    }

    @PostMapping(value={"/noFilterPage"})
    @ApiOperation(value="S-\u5206\u9875\u67e5\u8be2\u6240\u6709\u6570\u636e\uff08\u4e0d\u4f1a\u6839\u636e\u7528\u6237\u6743\u9650\u8fc7\u6ee4\u9879\u76ee\uff09", notes="\u53c2\u6570\u8bf4\u660e\uff1apageBean\u4f20\u5165pageSize\u4e3a-1\u8868\u793a\u4e0d\u5206\u9875\u67e5\u8be2\uff0c\u5728\u901a\u7528\u67e5\u8be2\u5668\u4e2d\u7684query\u5bf9\u8c61\u7ec4\u4f20\u5165\u67e5\u8be2\u53c2\u6570", httpMethod="POST")
    public CommonResult<PageList<ProjectManagement>> noFilterPage(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5668") @RequestBody QueryFilter<ProjectManagement> queryFilter) {
        PageList<ProjectManagement> result = ((ProjectManagementManager)this.baseService).noFilterPage(queryFilter);
        return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f", result);
    }

    @PostMapping(value={"/All"})
    @ApiOperation(value="S-\u4e0d\u5206\u9875\u67e5\u8be2\u6240\u6709\u6570\u636e")
    public CommonResult<List<ProjectManagement>> all() {
        QueryFilter queryFilter = QueryFilter.build();
        queryFilter.withDefaultPage();
        List<ProjectManagement> result = ((ProjectManagementManager)this.baseService).queryList((QueryFilter<ProjectManagement>)queryFilter);
        return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f", result);
    }

    @PostMapping(value={"/mergeItems"})
    @ApiOperation(value="S-\u5408\u5e76\u9879\u76ee(\u5c06\u82e5\u5e72\u9879\u76ee\u5408\u5e76\u5230\u4e00\u4e2a\u9879\u76ee\u4e0b)")
    public CommonResult<String> mergeItems(@ApiParam(name="mergeItemsVo", value="\u9879\u76ee\u5408\u5e76VO\u5bf9\u8c61") @RequestBody MergeItemsVo mergeItemsVo) {
        ((ProjectManagementManager)this.baseService).mergeItems(mergeItemsVo);
        return new CommonResult(true, "\u9879\u76ee\u5408\u5e76\u6210\u529f");
    }

    @PostMapping(value={"/splitItems"})
    @ApiOperation(value="S-\u62c6\u5206\u9879\u76ee(\u5c06\u82e5\u5e72\u9879\u76ee\u62c6\u5206\u6210\u72ec\u7acb\u9879\u76ee)")
    public CommonResult<String> splitItems(@ApiParam(name="ids", value="\u9700\u8981\u62c6\u5206\u7684\u9879\u76eeID\uff0c\u591a\u4e2a\u4f7f\u7528\u9017\u53f7\u5206\u9694") @RequestParam(value="ids") String ids) {
        ((ProjectManagementManager)this.baseService).splitItems(ids);
        return new CommonResult(true, "\u9879\u76ee\u62c6\u5206\u6210\u529f");
    }

    @PostMapping(value={"/updateParentIdByIds"})
    @ApiOperation(value="S-\u6839\u636e\u9879\u76eeID\u4fee\u6539\u7236\u9879\u76ee\u7684ID")
    public CommonResult<String> updateParentIdByIds(@ApiParam(name="projectParentIdsVo", value="\u9879\u76ee\u4fee\u6539ParentId\uff0cVO\u5bf9\u8c61") @RequestBody ProjectParentIdsVo projectParentIdsVo) {
        Assert.notNull((Object)projectParentIdsVo, (String)"\u9879\u76eeID\u4e0d\u80fd\u4e3a\u7a7a");
        ((ProjectManagementManager)this.baseService).updateParentIdByIds(projectParentIdsVo.getParentId(), projectParentIdsVo.getIds());
        return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f");
    }

    @PostMapping(value={"/updateCostConsultationById"})
    @ApiOperation(value="S-\u6839\u636e\u9879\u76eeID\u4fee\u6539\u9020\u4ef7\u54a8\u8be2\u5355\u4f4d")
    public CommonResult<String> updateCostConsultationById(@ApiParam(name="projectCostConsultationVo", value="\u9020\u4ef7\u54a8\u8be2\u5355\u4f4dVO") @RequestBody ProjectCostConsultationVo projectCostConsultationVo) {
        Assert.notNull((Object)projectCostConsultationVo, (String)"\u9879\u76eeID\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)projectCostConsultationVo.getId(), (String)"\u9879\u76eeID\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)projectCostConsultationVo.getCostConsultation(), (String)"\u5168\u8fc7\u7a0b\u9020\u4ef7\u54a8\u8be2\u5355\u4f4d");
        ((ProjectManagementManager)this.baseService).updateCostConsultationById(projectCostConsultationVo.getId(), projectCostConsultationVo.getCostConsultation());
        return new CommonResult(true, "\u9020\u4ef7\u54a8\u8be2\u5355\u4f4d\u4fee\u6539\u6210\u529f");
    }

    @PostMapping(value={"/updateLandCostById"})
    @ApiOperation(value="S-\u6839\u636e\u9879\u76eeID\u4fee\u6539\u571f\u5730\u8d39\u7528")
    public CommonResult<String> updateLandCostById(@ApiParam(name="projectLandCostVo", value="\u6839\u636e\u9879\u76eeID\u4fee\u6539\u571f\u5730\u8d39\u7528") @RequestBody ProjectLandCostVo projectLandCostVo) {
        Assert.notNull((Object)projectLandCostVo, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)projectLandCostVo.getId(), (String)"\u9879\u76eeID\u4e0d\u80fd\u4e3a\u7a7a");
        ((ProjectManagementManager)this.baseService).updateLandCostById(projectLandCostVo);
        return new CommonResult(true, "\u571f\u5730\u8d39\u7528\u4fdd\u5b58\u6210\u529f");
    }
}

