package com.artfess.cqxy.contract.model;

import cn.afterturn.easypoi.excel.annotation.Excel;
import cn.afterturn.easypoi.excel.annotation.ExcelTarget;
import com.artfess.base.entity.BizModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.beans.factory.annotation.Value;

import java.io.Serializable;
import java.util.Date;

/**
 * 合同管理表(BizContract)表实体类
 *
 * @author 黎沐华
 * @since 2022-02-26 10:35:03
 */
@Data
@ExcelTarget("self")
@TableName("BIZ_CONTRACT")
@ApiModel(value="合同对象-Contract", description="合同管理表")
public class Contract extends BizModel<Contract> {

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @TableField("PROJECT_ID_")
    @ApiModelProperty(value = "项目ID（关联项目管理表ID）")
    private String projectId;

    @Excel(name = "合同编号_link,合同编号_self")
    @TableField("CONTRACT_NUMBER_")
    @ApiModelProperty(value = "合同编号")
    private String contractNumber;

    @Excel(name = "合同名称_link,合同名称_self")
    @TableField("NAME_")
    @ApiModelProperty(value = "合同名称")
    private String name;

    @Excel(name = "合同类型_self")
    @TableField("TYPE_")
    @ApiModelProperty(value = "合同类别，（使用字典，G1：施工合同，G2：抢修整治，G3：补充协议，J1：安全影响评估，J2：白蚁合同，J3：洪水影响评估，J4：编制项目咨询合同，J5：代理合同，J6：地址灾害危险性评估合同，J7：方案报告编制合同，J8：防雷装置安全监测监测合同，J9：工程概算审核，J10：工程概算审核表，J11：工程质量检测合同，J12：官网内窥监测合同，J13：规划设计合同，J14：规划咨询合同，J15：洪水影响评价合同，J16：环境检测影响评价合同，J17：环境检测服务合同，J18：技术服务合同，J19：监理合同，J20：勘察合同，J21：检测合同，J22：勘察设计合同，J23：勘察外业见证合同，J24：勘察文件审核合同，J25：桥荷载试验合同，J26：设计合同，J27：设计补充协议，J28：审查合同，J29：施工图设计合同，J30：施工图设计文件审核合同，J31：试验监测技术服务合同，J32：消防设施监测合同，J33：续签合同，J34：预算编制合同，J35：预算审核合同，J36：造价咨询合同，J37：造价审核合同，J38：招标代理合同，J39：资产评估委托合同，J40：质量监测合同，J41：咨询合同，F1：安全管理协议，F2：机械设备租赁服务合同，F3：应急救援协议，F4：咨询服务合同，C1：采购合同，P1：安全保护协议，P2：电费结算协议，P3：工程合同，P4：技术咨询合同，P5：监理合同，P6：临时供用电合同，P7：施工合同，P8：占绿补偿，1：其他）")
    private String type;

    //    @Excel(name="合同类别值")
    @TableField("TYPE_VALUE_")
    @ApiModelProperty(value = "合同类别值，（合同类型下拉选择后的中文值）")
    private String typeValue;

    @Excel(name="签订日期_self",format = "yyyy-MM-dd")
    @TableField("CONTRACT_DATE_")
    @ApiModelProperty(value = "签订日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date contractDate;

    @Excel(name="合同金额(元)_self")
    @TableField("CONTRACT_AMOUNT_")
    @ApiModelProperty(value = "合同金额（元）")
    private String contractAmount;

    @Excel(name="结算方式_self")
    @TableField("SECOND_LEVEL_TYPE_")
    @ApiModelProperty(value = "结算方式（使用字典，1：包干，2：暂定）")
    private String secondLevelType;

    @Excel(name="备注_self")
    @TableField("ESTABLISHMENT_REMARKS_")
    @ApiModelProperty(value = "备注")
    private String establishmentRemarks;

    @Excel(name="发包方式_self")
    @TableField("BIDDING_CHARGE_TYPE_")
    @ApiModelProperty(value = "发包方式，使用字典，1：公开招标，2：邀请招标:3：公开比选:4：邀请比选:5：中介机构库:6：网上超市系统:7：直接委托")
    private String biddingChargeType;

    @Excel(name="决策依据_self")
    @TableField("DECISION_DOCUMENTS_")
    @ApiModelProperty(value = "决策依据")
    private String decisionDocuments;

//    @Excel(name="合同涉及事项_self")
    @TableField("CONTRACT_INVOLVED_")
    @ApiModelProperty(value = "合同涉及事项，（默认为项目名称）")
    private String contractInvolved;

    @Excel(name="合同分类_self")
    @TableField("MOLD_")
    @ApiModelProperty(value = "合同分类，（使用字典，1：G-工程类，2：J-技术类合同，3：F-服务类合同，4：C-采购类合同，5：P-配套类合同，6：其他）")
    private String mold;

    @TableField("MOLD_VALUE_")
    @ApiModelProperty(value = "合同分类值，（合同分类下拉选择后的中文值）")
    private String moleValue;

//    @Excel(name="甲方\n默认西永微电园_self")
    @TableField("FIRST_PARTY_")
    @ApiModelProperty(value = "甲方，（默认为重庆西永微电子产业园区开发有限公司）")
    @Value("重庆西永微电子产业园区开发有限公司")
    private String firstParty;

    @Excel(name="乙方单位_self")
    @TableField("SECOND_PARTY_")
    @ApiModelProperty(value = "乙方单位")
    private String secondParty;

//    @Excel(name="第三方_self")
    @TableField("THIRD_PARTY_")
    @ApiModelProperty(value = "第三方")
    private String thirdParty;

//    @Excel(name="唯一编号")
    @TableField("UNIQUE_NUMBER_")
    @ApiModelProperty(value = "唯一编号，（由后端生成，按照年月+0000001 自增方式）")
    private String uniqueNumber;

//    @Excel(name="约定完成日期_self",format = "yyyy-MM-dd")
    @TableField("END_DATE_")
    @ApiModelProperty(value = "约定完成日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date endDate;

    @Excel(name="合同异常记录_self")
    @TableField("CONTRACT_EXCEPTION_LOG_")
    @ApiModelProperty(value = "合同异常记录")
    private String contractExceptionLog;

    @Excel(name="合同执行进度_self")
    @TableField("CONTRACT_SCHEDULE_")
    @ApiModelProperty(value = "合同执行进度")
    private String contractSchedule;

//    @Excel(name="留存份数_self")
    @TableField("CONTRACT_COPIES_NUM_")
    @ApiModelProperty(value = "留存份数")
    private Integer contractCopsNum;

//    @Excel(name="保证金_self")
    @TableField("RETENTION_MONEY_")
    @ApiModelProperty(value = "保证金")
    private String retentionMoney;

    @Excel(name="合同约定付款方式")
    @TableField("TREATY_CONTENTS_")
    @ApiModelProperty(value = "合同约定付款方式")
    private String treatyContents;

//    @Excel(name="合同领取人_self")
    @TableField("CONTRACT_KEEPER_")
    @ApiModelProperty(value = "合同领取人")
    private String contractKeeper;

    @Excel(name="合同存放处_self")
    @TableField("CONTRACT_STORAGE_")
    @ApiModelProperty(value = "合同存放处")
    private String contractStorage;

    @Excel(name="合同经办人_self")
    @TableField("CONTRACT_RECEIVER_")
    @ApiModelProperty(value = "合同经办人）")
    private String contractReceiver;

    @Excel(name="收款人及账号、电话")
    @TableField("PAYEE_ACCOUNT_PHONE_")
    @ApiModelProperty(value = "收款人及账号、电话")
    private String payeeAccountPhone;

    @TableField("PAYEE_")
    @ApiModelProperty(value = "收款人")
    private String payee;

    @TableField("PAYEE_ACCOUNT_")
    @ApiModelProperty(value = "收款人账号")
    private String payeeAccount;

//    @Excel(name="收款人联系电话")
    @TableField("PAYEE_CONTACT_PHONE_")
    @ApiModelProperty(value = "开户行")
    private String payeeContactPhone;

    /**
     * 获取主键值
     *
     * @return 主键值
     */
    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "Contract{" +
                "id='" + id + '\'' +
                ", projectId='" + projectId + '\'' +
                ", contractNumber='" + contractNumber + '\'' +
                ", name='" + name + '\'' +
                ", secondLevelType='" + secondLevelType + '\'' +
                ", biddingChargeType=" + biddingChargeType +
                ", decisionDocuments='" + decisionDocuments + '\'' +
                ", contractInvolved='" + contractInvolved + '\'' +
                ", type='" + type + '\'' +
                ", typeValue='" + typeValue + '\'' +
                ", mold='" + mold + '\'' +
                ", moleValue='" + moleValue + '\'' +
                ", firstParty='" + firstParty + '\'' +
                ", secondParty='" + secondParty + '\'' +
                ", thirdParty='" + thirdParty + '\'' +
                ", uniqueNumber='" + uniqueNumber + '\'' +
                ", contractAmount='" + contractAmount + '\'' +
                ", contractDate=" + contractDate +
                ", endDate=" + endDate +
                ", contractExceptionLog='" + contractExceptionLog + '\'' +
                ", contractSchedule='" + contractSchedule + '\'' +
                ", contractCopsNum=" + contractCopsNum +
                ", retentionMoney='" + retentionMoney + '\'' +
                ", treatyContents='" + treatyContents + '\'' +
                ", contractKeeper='" + contractKeeper + '\'' +
                ", contractStorage='" + contractStorage + '\'' +
                ", contractReceiver='" + contractReceiver + '\'' +
                ", establishmentRemarks='" + establishmentRemarks + '\'' +
                '}';
    }

}

