package com.artfess.cqxy.completionAcceptance.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cqxy.completionAcceptance.model.RecordAcceptance;
import com.baomidou.mybatisplus.extension.service.IService;
import com.artfess.cqxy.completionAcceptance.model.RecordAcceptance;
import org.apache.ibatis.annotations.Param;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;

/**
 * 竣工验收 - 联合备案验收表(BizRecordAcceptance)表服务接口
 *
 * @author 黎沐华
 * @since 2022-03-07 14:28:02
 */
public interface RecordAcceptanceManager extends BaseManager<RecordAcceptance> {

    boolean deleteByIds(List<String> ids);

    /**
     * 导入Excel数据
     * @param file 文件
     * @param projectId 项目ID
     */
    void importExcelData(MultipartFile file, String projectId);

    /**
     * 导出数据到Excel文件
     * @param queryFilter 通用查询器
     * @param response 响应对象
     * @throws IOException IO异常
     */
    void exportDatatoExcel(QueryFilter<RecordAcceptance> queryFilter, HttpServletResponse response) throws IOException;

    /**
     * 通过ID获取数据，关联项目信息，不能使用原生查询
     * @param id ID
     * @return 一条数据
     */
    RecordAcceptance getById(@Param("id") String id);

    /**
     * 分页查询所有数据
     * @param queryFilter 通用查询器
     * @return 数据集合
     */
    PageList<RecordAcceptance> queryAllByPage(QueryFilter<RecordAcceptance> queryFilter);

    /**
     * 通过项目ID修改项目ID
     *
     * @param oldProjectIds
     * @param newProjectId
     *
     */
    void updateProjectIdByProiectId(String oldProjectIds, String newProjectId);
}

