package com.artfess.cqxy.projectManagement.model;


import cn.afterturn.easypoi.excel.annotation.Excel;
import cn.afterturn.easypoi.excel.annotation.ExcelTarget;
import com.artfess.base.annotation.BigDecimalFormat;
import com.artfess.base.entity.BizModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 项目管理表(BizProjectManagement)表实体类
 *
 * @author 黎沐华
 * @since 2022-02-10 15:43:43
 */
@Data
@ExcelTarget("self")
@TableName("BIZ_PROJECT_MANAGEMENT")
@ApiModel(value="项目管理-项目管理对象-ProjectManagement", description="项目管理表")
public class ProjectManagement extends BizModel<ProjectManagement> {

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    // 注解支持 name_id 的形式，以不同的ID来区分不同的表现形式
    // 如果没有匹配的ID，则不处理该字段；
    // 在导出关联穿透配置@ExcelEntity(id = "xxx") 配置一个差异于自身导出的id，即可实现关联导出特定字段
//    @Excel(name = "项目代码_link,项目代码_self")
    @Excel(name = "项目代码,项目代码_self")
    @TableField("PROJECT_CODE_")
    @NotNull(message = "项目代码不能为空")
    @ApiModelProperty(value = "项目代码")
    private String projectCode;

    @Excel(name = "项目名称_link,项目名称_self")
    @TableField("PROJECT_NAME_")
    @ApiModelProperty(value = "项目名称")
    private String projectName;

    @Excel(name = "项目负责人_self")
    @TableField("PROJECT_MANAGER_")
    @ApiModelProperty(value = "项目负责人")
    private String projectManager;

//    @Excel(name = "建设模式_self")
    @TableField("PROJECT_MODEL_")
    @ApiModelProperty(value = "建设模式（使用字典，1：自建，2：委托代建，3：BT模式，4：BOT模式，5：BOOT模式，6：BOOT模式，7：BOO模式，8：BLT模式，9：TOT模式，10：ROT模式，11：O&M模式，12：MC模式，13：其它）")
    private String projectModel;

    @Excel(name = "项目类型_self")
    @TableField("PROJECT_TYPE_")
    @ApiModelProperty(value = "项目类型（使用字典，1：市政设施，2：房建项目，3：其它）")
    private String projectType;

    @Excel(name = "项目金额(万元)_self")
    @TableField("PROJECT_MONEY_")
    @ApiModelProperty(value = "项目金额(万元)")
    @BigDecimalFormat
    private BigDecimal projectMoney;

//    @Excel(name = "项目状态枚举值_self")
    @TableField("PROJECT_STATUS_VALUE")
    @ApiModelProperty(value = "项目状态枚举值")
    private String projectStatusValue;

    @Excel(name = "项目状态_self")
    @TableField("PROJECT_STATUS_")
    @ApiModelProperty(value = "项目状态（1：决策，2：立项：3：可研，4：规划，5：初设，6：概算，7：施工图，8：招投标，9：合同，10：施工许可，11：工程施工，12：竣工验收，13：结算，14：决算，15：移交）")
    private String projectStatus;

    @Excel(name = "累计已完成投资(万元)_self")
    @TableField("ACCUMULATED_PROJECT_PAYMENT_")
    @ApiModelProperty(value = "累计已完成投资（万元）")
    //原 累计支付工程款
    @BigDecimalFormat
    private BigDecimal accumulatedProjectPayment;

    @Excel(name = "建设规模及内容_self")
    @TableField("CONSTRUCTION_PROGRESS_")
    @ApiModelProperty(value = "建设规模及内容")
    // 原 施工进度（当前进度）
    private String constructionProgress;

//    @Excel(name = "工程属性_self")
    @TableField("PROJECT_NATURE_")
    @ApiModelProperty(value = "工程属性（使用字典，1：道路，2：安置房，3：厂房，4：仓库，5：公租房，6：广场，7：土石方，8：围网，9：研发楼，10：停车场，11：消防站，12：研发，13：其它）")
    private String projectNature;

    @TableField("PROJECT_MANAGER_ID_")
    @ApiModelProperty(value = "项目负责人_ID")
    private String projectManagerId;

//    @Excel(name = "项目地址_self")
    @TableField("PROJECT_ADDRESS_")
    @ApiModelProperty(value = "项目地址")
    private String projectAddress;

//    @Excel(name = "项目规模及内容_self")
    @TableField("PROJECT_CONTENT_")
    @ApiModelProperty(value = "项目规模及内容")
    private String projectContent;

//    @Excel(name = "立项审批机关_self")
    @TableField("PROJECT_APPROVAL_AUTHORITY_")
    @ApiModelProperty(value = "立项审批机关（使用字典，1：市发改委，2：区发改委）")
    private String projectApprovalAuthority;

//    @Excel(name = "可研估算总投资(万元)_self")
    @TableField("FEASIBILITY_STUDY_ESTIMATE_")
    @ApiModelProperty(value = "可研估算总投资(万元)")
    @BigDecimalFormat
    private BigDecimal feasibilityStudyEstimate;

//    @Excel(name = "初设概算总投资_self")
    @TableField("PRELIMINARY_ESTIMATE_")
    @ApiModelProperty(value = "初设概算总投资")
    @BigDecimalFormat
    private BigDecimal preliminaryEstimate;

    @Excel(name = "建设时间_self",format = "yyyy-MM-dd")
    @TableField("COMMENCEMENT_TIME_")
    @ApiModelProperty(value = "建设时间")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date commencementTime;

//    @Excel(name = "完工时间_self",format = "yyyy-MM-dd")
    @TableField("COMPLETION_TIME_")
    @ApiModelProperty(value = "完工时间")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date completionTime;

//    @Excel(name = "竣工验收时间_self",format = "yyyy-MM-dd")
    @TableField("COMPLETION_ACCEPTANCE_TIME_")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @ApiModelProperty(value = "竣工验收时间")
    private Date completionAcceptanceTime;

//    @Excel(name = "质保到期时间_self",format = "yyyy-MM-dd")
    @TableField("WARRANTY_EXPIRATION_TIME_")
    @ApiModelProperty(value = "质保到期时间")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date warrantyExpirationTime;

    @TableField("OWNER_UNIT_ID_")
    @ApiModelProperty(value = "业主单位ID")
    private String ownerUnitId;

//    @Excel(name = "业主单位_self")
    @TableField("OWNER_UNIT_")
    @ApiModelProperty(value = "业主单位")
    private String ownerUnit;

    @TableField("RESPONSIBLE_UNIT_ID_")
    @ApiModelProperty(value = "责任单位ID")
    private String responsibleUnitId;

//    @Excel(name = "责任单位_self")
    @TableField("RESPONSIBLE_UNIT_")
    @ApiModelProperty(value = "责任单位")
    private String responsibleUnit;

//    @Excel(name = "地勘单位ID_self")
    @TableField("GEOLOGICAL_PROSPECTING_UNIT_ID_")
    @ApiModelProperty(value = "地勘单位ID")
    private String geologicalProspectingUnitId;

//    @Excel(name = "地勘单位_self")
    @TableField("GEOLOGICAL_PROSPECTING_UNIT_")
    @ApiModelProperty(value = "地勘单位")
    private String geologicalProspectingUnit;

    @TableField("DESIGN_UNIT_ID_")
    @ApiModelProperty(value = "设计单位ID")
    private String designUnitId;

//    @Excel(name = "设计单位_self")
    @TableField("DESIGN_UNIT_")
    @ApiModelProperty(value = "设计单位")
    private String designUnit;

    @TableField("SUPERVISOR_UNIT_ID_")
    @ApiModelProperty(value = "监理单位ID")
    private String supervisorUnitId;

//    @Excel(name = "监理单位_self")
    @TableField("SUPERVISOR_UNIT_")
    @ApiModelProperty(value = "监理单位")
    private String supervisorUnit;

    @TableField("CONSTRUCT_UNIT_ID_")
    @ApiModelProperty(value = "施工单位ID")
    private String constructUnitId;

//    @Excel(name = "施工单位_self")
    @TableField("CONSTRUCT_UNIT_")
    @ApiModelProperty(value = "施工单位")
    private String constructUnit;

//    @Excel(name = "报送结算金额(万元)_self")
    @TableField("SUBMITTED_SETTLEMENT_AMOUNT_")
    @ApiModelProperty(value = "报送结算金额(万元)")
    private String submittedSettlementAmount;

//    @Excel(name = "内部审计审定结算金额(万元)_self")
    @TableField("INTERNAL_APPROVED_SETTLEMENT_AMOUNT_")
    @ApiModelProperty(value = "内部审计审定结算金额(万元)")
    private String internalApprovedSettlementAmount;

//    @Excel(name = "社会审计方式_self")
    @TableField("SOCIAL_AUDIT_TYPE_")
    @ApiModelProperty(value = "社会审计方式（使用字典，1：全过程造价跟踪，2：单项结算审核）")
    private String socialAuditType;

//    @Excel(name = "社会审计中介名称_self")
    @TableField("SOCIAL_AUDIT_INTERMEDIARY_")
    @ApiModelProperty(value = "社会审计中介名称")
    private String socialAuditIntermediary;

//    @Excel(name = "社会审计审定金额_self")
    @TableField("SOCIAL_AUDIT_MONEY_")
    @ApiModelProperty(value = "社会审计审定金额")
    private String socialAuditMoney;

//    @Excel(name = "国家审计机关_self")
    @TableField("STATE_AUDIT_OFFICE_")
    @ApiModelProperty(value = "国家审计机关(使用字典：1：投资处，2：交通处)")
    private String stateAuditOffice;

//    @Excel(name = "国家审计审定金额_self")
    @TableField("STATE_AUDIT_MONEY_")
    @ApiModelProperty(value = "国家审计审定金额")
    private String stateAuditMoney;

//    @Excel(name = "决算审核机构_self")
    @TableField("FINAL_ACCOUNT_AUDIT_MECHANISM_")
    @ApiModelProperty(value = "决算审核机构")
    private String finalAccountAuditMechanism;

//    @Excel(name = "决算审定金额(万元)_self")
    @TableField("FINAL_ACCOUNT_AUDIT_MONEY_")
    @ApiModelProperty(value = "决算审定金额(万元)")
    private String finalAccountAuditMoney;

//    @Excel(name = "占合同金额比例_self")
    @TableField("PROPORTION_CONTRACT_AMOUNT_")
    @ApiModelProperty(value = "占合同金额比例（计算公式：累计支付工程款  / 合同金额 × 100%）")
    private String proportionContractAmount;

//    @Excel(name = "占审定结算金额比例_self")
    @TableField("SOCIAL_AUDIT_MONEY_AMOUNT_")
    @ApiModelProperty(value = "占审定结算金额比例（计算公式：累计支付工程款  / 社会审计审定金额）")
    private String socialAuditMoneyAmount;

//    @Excel(name = "合同编号_self")
    @TableField("CONTRACT_SIGNING_")
    @ApiModelProperty(value = "合同编号")
    private String contractSigning;

//    @Excel(name = "合同金额_self")
    @TableField("CONTRACT_AMOUNT_")
    @ApiModelProperty(value = "合同金额")
    @BigDecimalFormat
    private BigDecimal contractAmount;

//    @Excel(name = "备注_self")
    @TableField("REMARKS_")
    @ApiModelProperty(value = "备注")
    private String remarks;

    @TableField("SETTLEMENT_INFO_")
    @ApiModelProperty(value = "结算情况")
    private String settlementInfo;

    @TableField("SN_")
    @ApiModelProperty(value = "排序号")
    private Integer sn;

    @TableField("VALID_FLAG_")
    @ApiModelProperty(value = "启用禁用，（使用字典，1：有效（默认值），0：无效），除了项目管理列表界面,其他界面全部查询,启用状态的项目数据")
    private Integer validFlag;

    @TableField("CURRENT_PROJECT_")
    @ApiModelProperty(value = "是否为当前项目（使用字典，0：否(默认值)，1：是）")
    private Integer currentProject;

    @ApiModelProperty(value = "是否有子项目")
    @TableField("HAS_CHILDREN_")
    private String hasChildren;

    @ApiModelProperty(value = "父项目ID")
    @TableField("PARENT_ID_")
    private String parentId;

    //    @Excel(name = "责任单位_self")
    @TableField("COST_CONSULTATION_")
    @ApiModelProperty(value = "全过程造价咨询单位")
    private String costConsultation;

    @TableField(exist = false)
    @ApiModelProperty(value = "工程施工进度(用于渲染统计图表中施工进度统计图中工程施工的进度条)")
    private List<Double> projectConstructionProgress;

    //    @Excel(name = "责任单位_self")
    @TableField("LAND_AREA_")
    @ApiModelProperty(value = "土地面积")
    private String landArea;

    //    @Excel(name = "责任单位_self")
    @TableField("LAND_UNIT_")
    @ApiModelProperty(value = "土地面积单位")
    private String landUnit;

    //    @Excel(name = "责任单位_self")
    @TableField("LAND_PRICE_")
    @ApiModelProperty(value = "土地单价（单位：万元）")
    @BigDecimalFormat
    private BigDecimal landPrice;

    //    @Excel(name = "责任单位_self")
    @TableField("LAND_TOTAL_PRICE_")
    @ApiModelProperty(value = "土地总价（单位：万元）")
    @BigDecimalFormat
    private BigDecimal landTotalPrice;

    @TableField("PROJECT_SCALE_")
    @Excel(name = "建设规模（㎡/m）_self")
    @ApiModelProperty(value = "建设规模",notes = "如果项目类型是房建工程、装修改造工程、市政配套工程、生态环保工程、新基建就调取【项目管理-编制-立项备案】中建筑面积字段、如果项目类型是市政道路就调取【项目管理-编制-立项备案】中建筑长度字段")
    private String projectScale;

    /**
     * 获取主键值
     * @return 主键值
     */
    @Override
    protected Serializable pkVal() {return this.id;}

    @Override
    public String toString() {
        return "ProjectManagement{" +
                "id='" + id + '\'' +
                ", projectCode='" + projectCode + '\'' +
                ", projectName='" + projectName + '\'' +
                ", projectMoney='" + projectMoney + '\'' +
                ", projectModel='" + projectModel + '\'' +
                ", projectType=" + projectType +
                ", projectNature=" + projectNature +
                ", projectManager='" + projectManager + '\'' +
                ", projectAddress='" + projectAddress + '\'' +
                ", projectContent='" + projectContent + '\'' +
                ", projectApprovalAuthority=" + projectApprovalAuthority +
                ", feasibilityStudyEstimate='" + feasibilityStudyEstimate + '\'' +
                ", preliminaryEstimate='" + preliminaryEstimate + '\'' +
                ", commencementTime=" + commencementTime +
                ", completionTime=" + completionTime +
                ", completionAcceptanceTime=" + completionAcceptanceTime +
                ", warrantyExpirationTime=" + warrantyExpirationTime +
                ", ownerUnitId='" + ownerUnitId + '\'' +
                ", ownerUnit='" + ownerUnit + '\'' +
                ", responsibleUnitId='" + responsibleUnitId + '\'' +
                ", responsibleUnit='" + responsibleUnit + '\'' +
                ", geologicalProspectingUnitId='" + geologicalProspectingUnitId + '\'' +
                ", geologicalProspectingUnit='" + geologicalProspectingUnit + '\'' +
                ", designUnitId='" + designUnitId + '\'' +
                ", designUnit='" + designUnit + '\'' +
                ", supervisorUnitId='" + supervisorUnitId + '\'' +
                ", supervisorUnit='" + supervisorUnit + '\'' +
                ", constructUnitId='" + constructUnitId + '\'' +
                ", constructUnit='" + constructUnit + '\'' +
                ", submittedSettlementAmount='" + submittedSettlementAmount + '\'' +
                ", internalApprovedSettlementAmount='" + internalApprovedSettlementAmount + '\'' +
                ", socialAuditType=" + socialAuditType +
                ", socialAuditIntermediary='" + socialAuditIntermediary + '\'' +
                ", socialAuditMoney='" + socialAuditMoney + '\'' +
                ", stateAuditOffice='" + stateAuditOffice + '\'' +
                ", stateAuditMoney='" + stateAuditMoney + '\'' +
                ", finalAccountAuditMechanism='" + finalAccountAuditMechanism + '\'' +
                ", finalAccountAuditMoney='" + finalAccountAuditMoney + '\'' +
                ", accumulatedProjectPayment='" + accumulatedProjectPayment + '\'' +
                ", proportionContractAmount='" + proportionContractAmount + '\'' +
                ", socialAuditMoneyAmount='" + socialAuditMoneyAmount + '\'' +
                ", projectStatusValue=" + projectStatusValue +
                ", projectStatus='" + projectStatus + '\'' +
                ", contractSigning='" + contractSigning + '\'' +
                ", contractAmount=" + contractAmount +
                ", constructionProgress='" + constructionProgress + '\'' +
                ", remarks='" + remarks + '\'' +
                ", settlementInfo='" + settlementInfo + '\'' +
                ", sn=" + sn +
                ", validFlag=" + validFlag +
                ", currentProject=" + currentProject +
                '}';
    }
}

