package com.artfess.cqxy.designEstimate.model;


import cn.afterturn.easypoi.excel.annotation.Excel;
import cn.afterturn.easypoi.excel.annotation.ExcelEntity;
import com.artfess.base.entity.BizModel;
import com.artfess.cqxy.projectManagement.model.ProjectManagement;
import com.artfess.cqxy.universal.model.Accessory;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 设计概算 - 施工图设计表(BizConstructionDrawingDesign)表实体类
 * @author 黎沐华
 * @since 2022-02-15 18:13:17
 */
@Data
@TableName("BIZ_CONSTRUCTION_DRAWING")
@ApiModel(value="设计概算-施工图设计对象ConstructionDrawing", description="施工图设计表")
public class ConstructionDrawing extends BizModel<ConstructionDrawing> {

    // 关联项目的信息放在开头，以便在导出时先导出项目中的配置，而不用进行额外的位置配置
    @ExcelEntity(id = "link")
    @TableField(exist = false)
    @ApiModelProperty(value = "关联的项目信息")
    private ProjectManagement projectInfo;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @TableField("PROJECT_ID_")
    @ApiModelProperty(value = "项目ID（关联项目管理表ID）")
    private String projectId;

    @Excel(name = "设计单位")
    @TableField("NAME_")
    @ApiModelProperty(value = "设计单位")
    private String name;

//    @Excel(name = "项目主管总工")
    @TableField("CONSTRUCTION_LENGTH_")
    @ApiModelProperty(value = "项目主管总工")
    private String constructionLength;

//    @Excel(name = "审核人")
    @TableField("CONSTRUCTION_UNIT_")
    @ApiModelProperty(value = "审核人")
    private String constructionUnit;

    @Excel(name = "主要负责人")
    @TableField("DESIGN_SPEED_")
    @ApiModelProperty(value = "主要负责人")
    private String designSpeed;

    @Excel(name = "设计负责人")
    @TableField("CONSTRUCTION_WIDTH_")
    @ApiModelProperty(value = "设计负责人")
    private String constructionWidth;

//    @Excel(name = "审定人")
    @TableField("PROPOSED_LOCATION_")
    @ApiModelProperty(value = "审定人")
    private String proposedLocation;

    @Excel(name = "备注")
    @TableField("ESTABLISHMENT_REMARKS_")
    @ApiModelProperty(value = "备注")
    private String establishmentRemarks;

//    @Excel(name = "工程编号")
    @TableField("DOCUMENT_NUMBER_")
    @ApiModelProperty(value = "工程编号")
    private String documentNumber;

//    @Excel(name = "设计阶段")
    @TableField("SURVEY_UNIT_")
    @ApiModelProperty(value = "设计阶段，（使用字典，1：施工图设计，2，其他）")
    private String surveyUnit;

//    @Excel(name = "工程规模")
    @TableField("DESIGN_UNIT_")
    @ApiModelProperty(value = "工程规模，（使用字典，1，大型，2：中型，3：小型）")
    private String designUnit;

//    @Excel(name = "管理级别")
    @TableField("REVIEW_BODY_")
    @ApiModelProperty(value = "管理级别，（使用字典，1：公司管，2：院（分院）管）")
    private String reviewBody;

//    @Excel(name = "发证机关\n默认：住房和城乡建设部")
    @TableField("ESTABLISHMENT_APPROVAL_UNIT_")
    @ApiModelProperty(value = "发证机关（默认值：住房和城乡建设部）")
    private String establishmentApprovalUnit="住房和城乡建设部";

//    @Excel(name = "发证日期",format = "yyyy-MM-dd")
    @TableField("ESTABLISHMENT_DATE_")
    @ApiModelProperty(value = "发证日期（日期格式：2020-07-21）")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date establishmentDate;

//    @Excel(name = "设计证书号")
    @TableField("PRELIMINARY_DESIGN_NUMBER_")
    @ApiModelProperty(value = "设计证书号")
    private String preliminaryDesignNumber;

//    @Excel(name = "主要设计人")
    @TableField("CONSTRUCTION_SCALE_")
    @ApiModelProperty(value = "主要设计人")
    private String constructionScale;

//    @Excel(name = "设计文件组成")
    @TableField("CERTIFICATE_NO_")
    @ApiModelProperty(value = "设计文件组成")
    private String certificateNo;

    @TableField(exist = false)
    @ApiModelProperty(value = "附件信息")
    private List<Accessory> accessoryInfo;

    /**
     * 获取主键值
     * @return 主键值
     */
    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "ConstructionDrawingDesign{" +
                "id='" + id + '\'' +
                ", projectId='" + projectId + '\'' +
                ", name='" + name + '\'' +
                ", documentNumber='" + documentNumber + '\'' +
                ", preliminaryDesignNumber='" + preliminaryDesignNumber + '\'' +
                ", establishmentApprovalUnit='" + establishmentApprovalUnit + '\'' +
                ", establishmentDate=" + establishmentDate +
                ", constructionLength='" + constructionLength + '\'' +
                ", constructionWidth='" + constructionWidth + '\'' +
                ", designSpeed='" + designSpeed + '\'' +
                ", proposedLocation='" + proposedLocation + '\'' +
                ", constructionScale='" + constructionScale + '\'' +
                ", constructionUnit='" + constructionUnit + '\'' +
                ", surveyUnit='" + surveyUnit + '\'' +
                ", designUnit='" + designUnit + '\'' +
                ", reviewBody='" + reviewBody + '\'' +
                ", certificateNo='" + certificateNo + '\'' +
                ", establishmentRemarks='" + establishmentRemarks + '\'' +
                ", projectInfo=" + projectInfo +
                ", accessoryInfo=" + accessoryInfo +
                '}';
    }
}

