package com.artfess.cqxy.contract.model;

import cn.afterturn.easypoi.excel.annotation.Excel;
import cn.afterturn.easypoi.excel.annotation.ExcelEntity;
import cn.afterturn.easypoi.excel.annotation.ExcelTarget;
import com.artfess.base.annotation.BigDecimalFormat;
import com.artfess.base.entity.BizModel;
import com.artfess.cqxy.projectManagement.model.ProjectManagement;
import com.artfess.cqxy.universal.model.Accessory;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.beans.factory.annotation.Value;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 合同管理-资金计划表（FundPlan）实体类
 *
 * @author 荣涛
 * @since 2022-07-07 10:35:03
 */
@Data
@ExcelTarget("self")
@TableName("BIZ_FUND_PLAN")
@ApiModel(value="合同管理-资金计划对象-FundPlan", description="合同管理-资金计划表表")
public class FundPlan extends BizModel<FundPlan> {

    // 关联项目的信息放在开头，以便在导出时先导出项目中的配置，而不用进行额外的位置配置
    @ExcelEntity(id = "link")
    @TableField(exist = false)
    @ApiModelProperty(value = "关联的项目信息")
    private ProjectManagement projectInfo;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @TableField("PROJECT_ID_")
    @ApiModelProperty(value = "项目ID（关联项目管理表ID）")
    private String projectId;

    @Excel(name = "费用名称")
    @TableField("PURPOSE_")
    @ApiModelProperty(value = "费用名称")
    private String purpose;

    @Excel(name = "单位名称")
    @TableField("UNIT_NAME_")
    @ApiModelProperty(value = "单位名称")
    private String unitNname;

    @Excel(name="计划日期_self",format = "yyyy-MM")
    @TableField("PLAN_DATE_")
    @ApiModelProperty(value = "计划日期（日期格式为yyyy-MM，前端默认为当月）")
    @JsonFormat(pattern = "yyyy-MM", timezone = "GMT+8")
    private Date contractDate;

    @Excel(name="金额(元)_self")
    @TableField("PLAN_AMOUNT_")
    @ApiModelProperty(value = "金额（万元）")
    @BigDecimalFormat
    private BigDecimal contractAmount;

    @Excel(name="是否本年度新开工项目_self")
    @TableField("HAS_NEW_")
    @ApiModelProperty(value = "是否本年度新开工项目")
    private String hasNew;

    @Excel(name="是否本年度专项债申报项目_self")
    @TableField("HAS_SPECIAL_")
    @ApiModelProperty(value = "是否本年度专项债申报项目")
    private String hasSpecial;

    @Excel(name = "备注")
    @TableField("REMARKS_")
    @ApiModelProperty(value = "备注")
    private String remarks;

    @TableField(exist = false)
    @ApiModelProperty(value = "附件信息")
    private List<Accessory> accessoryInfo;

    @ExcelEntity(id = "link")
    @TableField(exist = false)
    @ApiModelProperty(value = "关联的合同信息")
    private Contract contractInfo;

    @Excel(name="合同ID")
    @TableField("CONTRACT_ID_")
    @ApiModelProperty(value = "合同ID（关联合同表ID）")
    private String contractId;

    @Excel(name="合同名称")
    @TableField("CONTRACT_NAME_")
    @ApiModelProperty(value = "合同名称（关联合同表名称）")
    private String contractName;

    /**
     * 获取主键值
     *
     * @return 主键值
     */
    @Override
    protected Serializable pkVal() {
        return this.id;
    }
}

