/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cqxy.processManagermant.manager.impl;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import com.artfess.base.context.BaseContext;
import com.artfess.base.feign.SystemConfigFeignService;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.cqxy.processManagermant.dao.ProgressManageEpidemicControlDao;
import com.artfess.cqxy.processManagermant.manager.ProgressManageEpidemicControlManager;
import com.artfess.cqxy.processManagermant.model.ProgressManageEpidemicControl;
import com.artfess.cqxy.projectManagement.enums.ProjectStatusEnum;
import com.artfess.cqxy.projectManagement.manager.ProjectManagementManager;
import com.artfess.cqxy.projectManagement.model.ProjectManagement;
import com.artfess.cqxy.search.enums.FunctionEnum;
import com.artfess.cqxy.search.manager.GlobalRetrievalManager;
import com.artfess.cqxy.search.model.GlobalRetrieval;
import com.artfess.cqxy.universal.manager.AccessoryManager;
import com.artfess.cqxy.universal.model.Accessory;
import com.artfess.cqxy.utils.BizUtils;
import com.artfess.poi.util.ExcelUtil;
import com.artfess.sysConfig.persistence.manager.SysDictionaryManager;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ProgressManageEpidemicControlManagerImpl
extends BaseManagerImpl<ProgressManageEpidemicControlDao, ProgressManageEpidemicControl>
implements ProgressManageEpidemicControlManager {
    @Autowired
    private AccessoryManager accessoryManager;
    @Autowired
    private SystemConfigFeignService scfs;
    @Autowired
    private SysDictionaryManager sdm;
    @Autowired
    private ProjectManagementManager pmm;
    @Autowired
    private BaseContext baseContext;
    @Autowired
    private GlobalRetrievalManager grm;

    public boolean saveOrUpdate(ProgressManageEpidemicControl entity) {
        boolean save = StringUtils.isEmpty((CharSequence)entity.getId());
        boolean savedMain = super.saveOrUpdate((Object)entity);
        ArrayList<Accessory> flag = entity.getAccessoryInfo();
        ArrayList<Accessory> accessoryList = null == flag ? new ArrayList<Accessory>() : flag;
        for (Accessory ele : accessoryList) {
            ele.setSourceId(entity.getId());
            ele.setProjectId(entity.getProjectId());
            ele.setDirectory(ProjectStatusEnum.nine.getCode());
            ele.setGroup("ProgressManageEpidemicControl");
            ele.setNode(ProjectStatusEnum.nine.getCode());
            ele.setCreateBy(this.baseContext.getCurrentUserId());
            ele.setCreateName(this.baseContext.getCurrentUserName());
            ele.setCreateTime(LocalDateTime.now());
        }
        this.accessoryManager.removeBySourceId(entity.getId());
        boolean saveAcc = accessoryList.size() == 0 || this.accessoryManager.saveAccess(accessoryList);
        this.pmm.updateStatusById(entity.getProjectId(), Integer.valueOf(ProjectStatusEnum.eleven.getCode()));
        GlobalRetrieval globalRetrieval = this.grm.getByBizId(entity.getId());
        this.handleRetrieval(save || BeanUtils.isEmpty((Object)((Object)globalRetrieval)) ? new GlobalRetrieval() : globalRetrieval, entity);
        return savedMain && saveAcc;
    }

    private void handleRetrieval(GlobalRetrieval globalRetrieval, ProgressManageEpidemicControl entity) {
        ProjectManagement projectManagement = (ProjectManagement)((Object)this.pmm.getById((Serializable)((Object)entity.getProjectId())));
        globalRetrieval.setProjectId(entity.getProjectId());
        globalRetrieval.setProjectName(projectManagement.getProjectName());
        globalRetrieval.setPersonCharge(projectManagement.getProjectManager());
        globalRetrieval.setArchivesType(1);
        globalRetrieval.setBizDataId(entity.getId());
        globalRetrieval.setFunctionCode(FunctionEnum.twentyTwo.getCode());
        globalRetrieval.setFunctionName(FunctionEnum.twentyTwo.getName());
        globalRetrieval.setBizTableName(FunctionEnum.twentyTwo.getTableName());
        globalRetrieval.setDetailsRoteUrl(FunctionEnum.twentyTwo.getTableRoteUrl());
        globalRetrieval.setTableRoteUrl(FunctionEnum.twentyTwo.getTableRoteUrl());
        globalRetrieval.setTableApiUrl(FunctionEnum.twentyTwo.getTableApiUrl());
        globalRetrieval.setDetailsApiUrl(FunctionEnum.twentyTwo.getDetailsApiUrl());
        globalRetrieval.setFunctionPath(FunctionEnum.twentyTwo.getFunctionPath());
        globalRetrieval.setDocumentNumber(entity.getEpidemicControlCode());
        globalRetrieval.setSearchTitle(entity.getEpidemicControlCode() + "_" + entity.getEpidemicControlUser() + "_" + entity.getProgressDescription() + "_" + entity.getEpidemicControlView() + "_" + entity.getRemarks());
        this.grm.saveOrUpdate((Object)globalRetrieval);
    }

    @Override
    public boolean deleteByIds(List<String> ids) {
        for (String ele : ids) {
            this.grm.remove(1, ele);
        }
        return this.removeByIds(ids);
    }

    @Override
    public ProgressManageEpidemicControl getById(String id) {
        ProgressManageEpidemicControl result = ((ProgressManageEpidemicControlDao)this.baseMapper).getById(id);
        result.setAccessoryInfo(this.accessoryManager.getAccessoryBySourceId(id));
        return result;
    }

    @Override
    public PageList<ProgressManageEpidemicControl> queryAllByPage(QueryFilter<ProgressManageEpidemicControl> queryFilter) {
        BizUtils.handleFilter(queryFilter, "bpmec", "pm");
        IPage<ProgressManageEpidemicControl> result = ((ProgressManageEpidemicControlDao)this.baseMapper).queryAllByPage((IPage<ProgressManageEpidemicControl>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<ProgressManageEpidemicControl>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        List records = result.getRecords();
        for (ProgressManageEpidemicControl ele : records) {
            ele.setAccessoryInfo(this.accessoryManager.getAccessoryBySourceId(ele.getId()));
        }
        return new PageList(result);
    }

    @Override
    public void importExcelData(MultipartFile file, String projectId) {
        Assert.notNull((Object)projectId, (String)"\u9879\u76eeID\u4e0d\u80fd\u4e3a\u7a7a");
        try {
            InputStream inputStream = file.getInputStream();
            Workbook workbook = WorkbookFactory.create((InputStream)inputStream);
            Sheet sheetAt = workbook.getSheetAt(0);
            for (Row row : sheetAt) {
                if (row.getRowNum() == 0) continue;
                ProgressManageEpidemicControl data = new ProgressManageEpidemicControl();
                data.setProgressDescription(null == row.getCell(0) ? row.createCell(0).getStringCellValue() : row.getCell(0).getStringCellValue());
                data.setEpidemicControlView(null == row.getCell(1) ? row.createCell(1).getStringCellValue() : row.getCell(1).getStringCellValue());
                Date date = null == row.getCell(2) ? row.createCell(2).getDateCellValue() : row.getCell(2).getDateCellValue();
                data.setEpidemicControlDate(null == date ? new Date() : date);
                data.setEpidemicControlUser(null == row.getCell(3) ? row.createCell(3).getStringCellValue() : row.getCell(3).getStringCellValue());
                data.setRemarks(null == row.getCell(4) ? row.createCell(4).getStringCellValue() : row.getCell(4).getStringCellValue());
                data.setEpidemicControlCode(null == row.getCell(5) ? row.createCell(5).getStringCellValue() : row.getCell(5).getStringCellValue());
                data.setProjectId(projectId);
                ((ProgressManageEpidemicControlDao)this.baseMapper).insert((Object)data);
                this.handleRetrieval(new GlobalRetrieval(), data);
            }
            workbook.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void exportDatatoExcel(QueryFilter<ProgressManageEpidemicControl> queryFilter, HttpServletResponse response) throws IOException {
        String fileName = "\u8fc7\u7a0b\u7ba1\u7406-\u8fdb\u5ea6\u7ba1\u7406-\u75ab\u60c5\u9632\u63a7-\u5bfc\u51fa\u7ed3\u679c";
        BizUtils.handleFilter(queryFilter, "bpmec", "pm");
        List data = ((ProgressManageEpidemicControlDao)this.baseMapper).queryAllByPage((IPage<ProgressManageEpidemicControl>)this.convert2IPage(new PageBean(Integer.valueOf(0), Integer.valueOf(-1), Boolean.valueOf(false))), (Wrapper<ProgressManageEpidemicControl>)this.convert2Wrapper(queryFilter, this.currentModelClass())).getRecords();
        if (null == data || data.size() == 0) {
            throw new RuntimeException("\u6ca1\u6709\u8981\u5bfc\u51fa\u7684\u7684\u6570\u636e\uff01");
        }
        ExportParams exportParams = BizUtils.getExportParams(fileName);
        fileName = fileName + ".xlsx";
        Workbook workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, ProgressManageEpidemicControl.class, (Collection)data);
        ExcelUtil.downloadExcel((Workbook)workbook, (String)fileName, (HttpServletResponse)response);
    }

    @Override
    public void updateProjectIdByProiectId(String oldProjectIds, String newProjectId) {
        UpdateWrapper wrapper = (UpdateWrapper)new UpdateWrapper().set(StringUtils.isNotBlank((CharSequence)newProjectId), "PROJECT_ID_", (Object)newProjectId).in((Object)"PROJECT_ID_", Arrays.asList(oldProjectIds.split(",")));
        this.update((Wrapper)wrapper);
    }
}

