package com.artfess.uc.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.base.query.PageBean;
import com.artfess.uc.model.Matrix;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;

/**
 * 
 * <pre> 
 * 描述：矩阵管理 处理接口
 * 构建组：x7
 * 作者:pangq
 * 邮箱:pangq@jee-soft.cn
 * 日期:2020-06-05 10:24:44
 * 版权：广州宏天软件股份有限公司
 * </pre>
 */
public interface MatrixManager extends BaseManager<Matrix>{

	Matrix getByCode(String code);

	/**
	 * 判断code是否唯一
	 * @param code
	 * @param id
	 * @return
	 */
	Boolean isCodeExist(String code, String id);

	void saveMatrix(Matrix matrix);

	/**
	 * 逻辑删除
	 * @param ids
	 */
	void deleLogical(String[] ids);

	/**
	 * 发布矩阵：创建或更新物理表
	 * @param id
	 * @throws SQLException 
	 */
	void publish(String id) throws SQLException;

	Matrix getDetail(String id);

	/**
	 * 获取列表数据
	 * @param matrixId
	 * @param pageBean
	 * @return
	 * @throws Exception
	 */
	Map<String, Object> getData(String matrixId, PageBean pageBean) throws Exception ;
	/**
	 * 根据主键获取单条数据
	 * @param matrixId
	 * @param pk
	 * @return
	 * @throws Exception
	 */
	Map<String, Object> getOneData(String matrixId, String pk) throws Exception;
	/**
	 * 获取空白的数据
	 * @param matrixId
	 * @param pk
	 * @return
	 */
	Map<String, Object> getBlankOneData(String matrixId);
	/**
	 * 保存数据
	 * @param matrixId
	 * @param data
	 * @throws IOException
	 */
	void saveData(String matrixId, String data) throws Exception;

	void dataRemove(String matrixId, String[] ids);

	List<Map<String, Object>> getUsers(Map<String, Object> params)  throws Exception;
}
