package com.artfess.uc.controller;

import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.util.StringUtil;
import com.artfess.uc.manager.HolidayTimeManager;
import com.artfess.uc.model.HolidayTime;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;

/**
 * 
 * <pre> 
 * 描述：假期时间 控制器类
 * 构建组：x7
 * 作者:qiuxd
 * 邮箱:heyf@jee-soft.cn
 * 日期:2020-08-04 11:04:36
 * 版权：广州宏天软件股份有限公司
 * </pre>
 */
@RestController
@RequestMapping(value="/uc/holidayTime/v1")
@Api(tags="holidayTimeController")
public class HolidayTimeController extends BaseController<HolidayTimeManager,HolidayTime>{
	@Resource
	HolidayTimeManager holidayTimeManager;
	
    /**
	 * 新增假期时间
	 * @param holidayTime
	 * @throws Exception 
	 * @return
	 * @exception 
	 */
	@PostMapping(value="save")
	@ApiOperation(value = "新增,更新假期时间数据", httpMethod = "POST", notes = "新增,更新假期时间数据")
	public CommonResult<String> save(@ApiParam(name="holidayTime",value="假期时间业务对象", required = true)@RequestBody HolidayTime holidayTime) throws Exception{
		String msg = "添加假期时间成功";
		if(StringUtil.isEmpty(holidayTime.getId())){
			holidayTimeManager.create(holidayTime);
		}else{
			holidayTimeManager.update(holidayTime);
			 msg = "更新假期时间成功";
		}
		return new CommonResult<String>(msg);
	}
	
	/**
	 * 批量删除假期时间记录
	 * @param ids
	 * @throws Exception 
	 * @return
	 * @exception 
	 */
	@DeleteMapping(value="/remove")
	@ApiOperation(value = "批量删除假期时间记录", httpMethod = "DELETE", notes = "批量删除假期时间记录")
	public CommonResult<String> removes(@ApiParam(name="ids",value="业务主键数组,多个业务主键之间用逗号分隔", required = true)@RequestParam String...ids) throws Exception{
		holidayTimeManager.removeByIds(ids);
		return new CommonResult<String>(true, "批量删除成功");
	}
}
