package com.artfess.cqxy.processManagermant.model;


import cn.afterturn.easypoi.excel.annotation.Excel;
import cn.afterturn.easypoi.excel.annotation.ExcelEntity;
import com.artfess.base.annotation.BigDecimalFormat;
import com.artfess.base.entity.BizModel;
import com.artfess.cqxy.contract.model.Contract;
import com.artfess.cqxy.projectManagement.model.ProjectManagement;
import com.artfess.cqxy.universal.model.Accessory;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 过程管理 - 进度管理 - 工程月报(BizProgressManageReport)表实体类
 *
 * @author 黎沐华
 * @since 2022-03-11 17:46:51
 */
@Data
@TableName("BIZ_PROGRESS_MANAGE_REPORT")
@ApiModel(value="过程管理-进度管理-工程月报-ProgressManageReport", description="过程管理-进度管理-工程月报表")
public class ProgressManageReport extends BizModel<ProgressManageReport> {

    // 关联项目的信息放在开头，以便在导出时先导出项目中的配置，而不用进行额外的位置配置
    @ExcelEntity(id = "link")
    @TableField(exist = false)
    @ApiModelProperty(value = "关联的项目信息")
    private ProjectManagement projectInfo;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @TableField("PROJECT_ID_")
    @ApiModelProperty(value = "项目ID（关联项目管理表ID）")
    private String projectId;

    @TableField("CONTRACT_ID_")
    @ApiModelProperty(value = "关联合同ID（关联合同信息表）")
    private String contractId;

//    @ExcelEntity(id = "link")
    @TableField(exist = false)
    @ApiModelProperty(value = "关联的合同信息")
    private Contract contractInfo;

    @Excel(name = "合同名称")
    @TableField("NAME_")
    @ApiModelProperty(value = "合同名称")
    private String contractName;

    @Excel(name = "审定日期",format = "yyyy-MM-dd")
    @TableField("PORT_DATE_")
    @ApiModelProperty(value = "审定日期，（日期格式，yyy-MM-dd，默认为当天）")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date portDate;

    @Excel(name = "审定支付金额(元)", numFormat = "#")
    @TableField("PROGRESS_DESCRIPTION_")
    @ApiModelProperty(value = "审定支付金额")
    @BigDecimalFormat
    private BigDecimal progressDescription;

    @Excel(name = "工程进度")
    @TableField("IMAGE_PROGRESS_")
    @ApiModelProperty(value = "工程进度（百分比）")
    private String imageProgress;

    @Excel(name = "本月产值", numFormat = "#")
    @TableField("ENGINEERING_CHANGE_")
    @ApiModelProperty(value = "本月产值")
    @BigDecimalFormat
    private BigDecimal engineeringChange;

    @Excel(name = "累计总投资(元)", numFormat = "#")
    @TableField("PROJECT_OVERVIEW")
    @ApiModelProperty(value = "累计总投资")
    @BigDecimalFormat
    private BigDecimal projectOvervie;

//    @Excel(name = "填报类型")
    @TableField("PORT_TYPE_")
    @ApiModelProperty(value = "填报类型，（使用数据字典，1：周报，2：月报(默认值)）")
    private String portType;

    @Excel(name = "形象进度")
    @TableField("WEEKLY_MOUTHLY_WORK_")
    @ApiModelProperty(value = "形象进度")
    private String weeklyMouthlyWork;

    @Excel(name = "备注")
    @TableField("REMARKS_")
    @ApiModelProperty(value = "备注")
    private String remarks;

//    @Excel(name = "填报方")
    @TableField("PORT_UNIT_")
    @ApiModelProperty(value = "填报方，使用数据字典，1：业主方，2：监理方，3：设计方，4：施工方")
    private String portUnit;

//    @Excel(name = "经办人")
    @TableField("PORT_USER_NAME_")
    @ApiModelProperty(value = "经办人")
    private String portUserName;

//    @Excel(name = "下步计划")
    @TableField("NEXT_STEP_PLAN_")
    @ApiModelProperty(value = "下步计划")
    private String nextStepPlan;

    @Excel(name = "投资计算比例")
    @TableField("INVESTMENT_RATIO_")
    @ApiModelProperty(value = "投资计算比例（默认0.75）")
    private String investmentRatio;

    @TableField(exist = false)
    @ApiModelProperty(value = "附件信息")
    private List<Accessory> accessoryInfo;

    /**
     * 获取主键值
     *
     * @return 主键值
     */
    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "ProgressManageReport{" +
                "id='" + id + '\'' +
                ", projectId='" + projectId + '\'' +
                ", contractInfo=" + contractInfo +
                ", contractId=" + contractId +
                ", portType=" + portType +
                ", portDate=" + portDate +
                ", portUnit=" + portUnit +
                ", portUserName='" + portUserName + '\'' +
                ", imageProgress='" + imageProgress + '\'' +
                ", projectOvervie='" + projectOvervie + '\'' +
                ", progressDescription='" + progressDescription + '\'' +
                ", weeklyMouthlyWork='" + weeklyMouthlyWork + '\'' +
                ", engineeringChange='" + engineeringChange + '\'' +
                ", nextStepPlan='" + nextStepPlan + '\'' +
                ", remarks='" + remarks + '\'' +
                ", projectInfo=" + projectInfo +
                ", accessoryInfo=" + accessoryInfo +
                '}';
    }

}

