package com.artfess.cqxy.processManagermant.dao;

import com.artfess.cqxy.processManagermant.model.QualityInspection;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import org.apache.ibatis.annotations.Param;
import com.artfess.cqxy.processManagermant.model.QualityInspection;

/**
 * 过程管理 - 质量管理-质量巡检(BizQualityInspection)表数据库访问层
 *
 * @author 黎沐华
 * @since 2022-03-03 11:38:43
 */
public interface QualityInspectionDao extends BaseMapper<QualityInspection> {

    /**
     * 通过ID获取数据，关联项目信息，不能使用原生查询
     * @param id ID
     * @return 一条数据
     */
    QualityInspection getById(@Param("id") String id);

    /**
     * 分页查询所有数据
     * @param convert2IPage 分页对象
     * @param convert2Wrapper 查询参数
     * @return 数据集合
     */
    IPage<QualityInspection> queryAllByPage(IPage<QualityInspection> convert2IPage, @Param(Constants.WRAPPER) Wrapper<QualityInspection> convert2Wrapper);

}

