package com.artfess.cqxy.universal.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.logging.log4j.core.config.plugins.validation.constraints.Required;
import org.springframework.web.multipart.MultipartFile;
import java.io.Serializable;

/**
 * @author 黎沐华
 * @date 2022/2/16 18:35
 */
@ApiModel(value = "上传Chunk对象")
public class Chunk implements Serializable {

    @ApiModelProperty("当前文件块，从1开始")
    private Integer chunkNumber;

    @ApiModelProperty("分块大小")
    private Integer chunkSize;

    @ApiModelProperty("当前分块大小")
    private Integer currentChunkSize;

    @ApiModelProperty("总大小")
    private Long totalSize;

    @ApiModelProperty("文件标识")
    private String identifier;

    @ApiModelProperty("文件名")
    private String filename;

    @ApiModelProperty("相对路径")
    private String relativePath;

    @ApiModelProperty("桶中文件夹路径，以功能分类，不配置则默认放在default下")
    private String bizPath;

    @ApiModelProperty("总块数")
    private Integer totalChunks;

    @Required()
    @ApiModelProperty("二进制文件")
    private MultipartFile file;

    @Override
    public String toString() {
        return "Chunk{" +
                "chunkNumber=" + chunkNumber +
                ", chunkSize=" + chunkSize +
                ", currentChunkSize=" + currentChunkSize +
                ", totalSize=" + totalSize +
                ", identifier='" + identifier + '\'' +
                ", filename='" + filename + '\'' +
                ", relativePath='" + relativePath + '\'' +
                ", bizPath='" + bizPath + '\'' +
                ", totalChunks=" + totalChunks +
                ", file=" + file +
                '}';
    }

    public Integer getChunkNumber() {
        return chunkNumber;
    }

    public void setChunkNumber(Integer chunkNumber) {
        this.chunkNumber = chunkNumber;
    }

    public Integer getChunkSize() {
        return chunkSize;
    }

    public void setChunkSize(Integer chunkSize) {
        this.chunkSize = chunkSize;
    }

    public Integer getCurrentChunkSize() {
        return currentChunkSize;
    }

    public void setCurrentChunkSize(Integer currentChunkSize) {
        this.currentChunkSize = currentChunkSize;
    }

    public Long getTotalSize() {
        return totalSize;
    }

    public void setTotalSize(Long totalSize) {
        this.totalSize = totalSize;
    }

    public String getIdentifier() {
        return identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public String getFilename() {
        return filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getRelativePath() {
        return relativePath;
    }

    public void setRelativePath(String relativePath) {
        this.relativePath = relativePath;
    }

    public String getBizPath() {
        return bizPath;
    }

    public void setBizPath(String bizPath) {
        this.bizPath = bizPath;
    }

    public Integer getTotalChunks() {
        return totalChunks;
    }

    public void setTotalChunks(Integer totalChunks) {
        this.totalChunks = totalChunks;
    }

    public MultipartFile getFile() {
        return file;
    }

    public void setFile(MultipartFile file) {
        this.file = file;
    }
}
