package com.artfess.cqxy.projectManagement.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryField;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.cqxy.projectManagement.dao.DirectoryManagementDao;
import com.artfess.cqxy.projectManagement.manager.DirectoryManagementManager;
import com.artfess.cqxy.projectManagement.model.DirectoryManagement;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;

/**
 * 目录管理表(BizDirectoryManagement)表服务实现类
 * @author 黎沐华
 * @since 2022-02-16 09:04:12
 */
@Service
public class DirectoryManagementImpl extends BaseManagerImpl<DirectoryManagementDao, DirectoryManagement> implements DirectoryManagementManager {

    @Override
    public List<DirectoryManagement> getByParentId(String pCode) {
        return baseMapper.getByParentId(pCode);
    }

    @Override
    public PageList<DirectoryManagement> queryChildNodeByPage(QueryFilter<DirectoryManagement> queryFilter) {
        // 限制父节点编码不能为空
        String pCode = null;
        List<QueryField> test = queryFilter.getQuerys();
        for (QueryField ele : test){
            if("bdm.PCODE_".equals(ele.getProperty())) {
                pCode = String.valueOf(ele.getValue());
                break;
            }
        }
        Assert.notNull(pCode,"父节点编码不能为空！");
        queryFilter.addFilter("bdm.IS_DELE_","0", QueryOP.EQUAL);
        IPage<DirectoryManagement> result =
                baseMapper.queryChildNodeByPage(
                        convert2IPage(queryFilter.getPageBean()),
                        convert2Wrapper(queryFilter, currentModelClass()));

        return new PageList<>(result);
    }

    @Override
    public boolean removeByIds(Collection<? extends Serializable> idList) {
        List<DirectoryManagement> data = baseMapper.selectBatchIds(idList);
        boolean flag = super.removeByIds(idList);
        for (DirectoryManagement ele:data) {
            //没有子节点则修改父节点的 是否有子节点状态，如果选的子节点都是一个父节点的，将会造成资源浪费，可优化
            if(getByParentId(ele.getPcode()).size()==0){
                changeHasChildNode(ele, false);
            }
        }
        return flag;
    }

    @Override
    public void changeHasChildNode(DirectoryManagement data, boolean flag) {
        int num = flag?
                    baseMapper.updateChildNodeStatus(data.getPcode(),"1") :
                    baseMapper.updateChildNodeStatus(data.getPcode(), "0");
    }

}

