package com.artfess.cqxy.ledger.model;

import com.artfess.base.entity.BizNoModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.List;

/**
 *
 *
 * @author baseli
 * @since 2022年6月5日20:00:42
 */
@Data
@TableName("biz_menu_field_temp")
@ApiModel(value="菜单功能自定义模板对象-MenuFieldTemp", description="菜单功能自定义模板对象")
public class MenuFieldTemp extends BizNoModel<MenuFieldTemp> {

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @TableField("PROJECT_ID_")
    @ApiModelProperty(value = "项目id")
    private String projectId;

    @TableField("PROJECT_NAME_")
    @ApiModelProperty(value = "项目名称")
    private String projectName;

    @TableField("NAME_")
    @ApiModelProperty(value = "模板名称")
    private String name;

    @TableField("DESCRIBE_")
    @ApiModelProperty(value = "模板描述")
    private String describe;

    @TableField(exist = false)
    @ApiModelProperty(value = "模板对应字段集合")
    private List<MenuCustomizeField> menuCustomizeFieldList;

//    @TableField("MENU_ALIAS_")
//    @ApiModelProperty(value = "菜单别名（用于查询对应菜单字段）")
//    private String menuAlias;
//
//    @TableField("MENU_ALIAS_NAME_")
//    @ApiModelProperty(value = "菜单中文名")
//    private String menuAliasName;
//
//    @TableField("TABLE_")
//    @ApiModelProperty(value = "表名（英文）")
//    private String table;
//
//    @TableField("TABLE_NAME_")
//    @ApiModelProperty(value = "表名（中文）")
//    private String tableName;
//
//    @TableField("FIELD_")
//    @ApiModelProperty(value = "字段名称（英文）")
//    private String field;
//
//    @TableField("FIELD_NAME_")
//    @ApiModelProperty(value = "字段名称（中文）")
//    private String fieldName;
//
//    @TableField("FIELD_TYPE_VALUE_")
//    @ApiModelProperty(value = "字段类型,（字典值，1：字符串，2：整数，3：浮点数，4:大数据，5：日期（年月日），6：日期时间（年月日时分秒），7：时间戳，8：枚举）")
//    private String fieldTypeValue;
//
//    @TableField("FIELD_TYPE_NAME_")
//    @ApiModelProperty(value = "字段类型名称")
//    private String fieldTypeName;
//
//    @TableField("DIC_KEY_")
//    @ApiModelProperty(value = "字典key")
//    private String dicKey;
    
    @TableField("SN_")
    @ApiModelProperty(value = "排序号")
    private BigInteger sn;

    @TableField("REMARKS_")
    @ApiModelProperty(value = "备注")
    private String remarks;

    /**
     * 获取主键值
     *
     * @return 主键值
     */
    @Override
    protected Serializable pkVal() {
        return this.id;
    }

}

