package com.artfess.cqxy.bidManagement.model;

import cn.afterturn.easypoi.excel.annotation.Excel;
import cn.afterturn.easypoi.excel.annotation.ExcelEntity;
import com.artfess.base.entity.BizModel;
import com.artfess.cqxy.projectManagement.model.ProjectManagement;
import com.artfess.cqxy.universal.model.Accessory;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 招投标管理 - 清单限价 - 编制(BiddingPriceLimit)表实体类
 *
 * @author 黎沐华
 * @since 2022-04-08 11:08:42
 */
@Data
@TableName("BIZ_BIDDING_PRICE_LIMIT")
@ApiModel(value="招投标管理-清单限价-编制对象-BiddingPriceLimit", description="清单限价-编制表")
public class BiddingPriceLimit extends BizModel<BiddingPriceLimit> {

    // 关联项目的信息放在开头，以便在导出时先导出项目中的配置，而不用进行额外的位置配置
    @ExcelEntity(id = "link")
    @TableField(exist = false)
    @ApiModelProperty(value = "关联的项目信息")
    private ProjectManagement projectInfo;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @TableField("PROJECT_ID_")
    @ApiModelProperty(value = "项目ID（关联项目管理表ID）")
    private String projectId;

    @Excel(name = "清单信息名称")
    @TableField("NAME_")
    @ApiModelProperty(value = "清单信息名称")
    private String name;

    @Excel(name = "编制单位")
    @TableField("TENDEREE_")
    @ApiModelProperty(value = "编制单位")
    private String tenderee;

    @Excel(name = "编制日期", format = "yyyy-MM-dd")
    @TableField("TENDEREE_DATE_")
    @ApiModelProperty(value = "编制日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date tendereeDate;

    @Excel(name = "编制金额", type = 10, numFormat = "0.00")
    @TableField("PRICE_CEILING_")
    @ApiModelProperty(value = "编制金额")
    private BigDecimal priceCeiling;

    @Excel(name = "备注")
    @TableField("ESTABLISHMENT_REMARKS_")
    @ApiModelProperty(value = "备注")
    private String establishmentRemarks;

//    @Excel(name = "文号")
    @TableField("DOC_NUMBER_")
    @ApiModelProperty(value = "文号（如有）")
    private String docNumber;

//    @Excel(name = "业主单位\n默认西永微电产业园")
    @TableField("OWNER_UNIT_")
    @ApiModelProperty(value = "业主单位（默认值：重庆西永微电子产业园区开发有限公司）")
    private String ownerUnit;

//    @Excel(name = "经办人")
    @TableField("HANDLER_")
    @ApiModelProperty(value = "经办人（默认值：选择项目后将项目负责人填入）")
    private String handler;

//    @Excel(name = "项目概况")
    @TableField("PROJECT_OVERVIEW_")
    @ApiModelProperty(value = "项目概况（默认值：选择项目后将项目规模及内容填入）")
    private String projectOverview;

    @TableField(exist = false)
    @ApiModelProperty(value = "附件信息")
    private List<Accessory> accessoryInfo;

    public BiddingPriceLimit() {
        ownerUnit = "重庆西永微电子产业园区开发有限公司";
    }

    /**
     * 获取主键值
     * @return 主键值
     */
    @Override
    protected Serializable pkVal() {
        return this.id;
    }
}

