package com.artfess.cqxy.processManagermant.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.cqxy.processManagermant.model.ProgressManage;
import com.artfess.cqxy.processManagermant.vo.AppropriatedlVo;
import com.artfess.cqxy.processManagermant.vo.ProgressManageTotalVo;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.api.ApiController;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.artfess.cqxy.processManagermant.model.ProgressManage;
import com.artfess.cqxy.processManagermant.manager.ProgressManageManager;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

/**
 * 过程管理 - 进度管理(BizProgressManage)表控制层
 *
 * @author 黎沐华
 * @since 2022-03-04 16:49:30
 */
@Slf4j
@RestController
@Api(tags = "施工管理-进度管理-工程支付接口")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
@RequestMapping("/biz/processManagement/progressManage/v1")
public class ProgressManageController extends BaseController<ProgressManageManager, ProgressManage> {

    /**
     * 保存或修改数据
     * @param progressManage 实体对象
     * @return 新增或更新结果
     */
    @PostMapping("/save")
    @ApiOperation(value = "S-保存或修改数据",httpMethod = "POST")
    public CommonResult<ProgressManage> insert(@RequestBody ProgressManage progressManage) {
        log.debug("进度管理-保存或修改数据接口请求参数：{}", progressManage);
        Assert.notNull(progressManage.getProjectId(),"项目ID不能为空");
//        Assert.notNull(progressManage.getContractId(),"合同ID不能为空");
        boolean save = baseService.saveOrUpdateEntity(progressManage);
        return new CommonResult<>(true, "数据保存成功！", progressManage);
    }

    /**
     * 批量导入Excel数据
     * @param file Excel文件
     */
    @PostMapping("/importExcelData")
    @ApiOperation(value = "S-批量导入Excel数据")
    public CommonResult importExcelData (
            @ApiParam("上传文件") @RequestParam("file") MultipartFile file,
            @ApiParam("项目ID") @RequestParam("projectId") String projectId,
            @ApiParam("合同ID") @RequestParam("contractId") String contractId/**,
            @ApiParam("登记员ID") @RequestParam("registerPersonId") String registerPersonId,
            @ApiParam("登记员名称") @RequestParam("registerPersonName") String registerPersonName*/){
        log.debug("批量导入Excel数据接口请求参数：{}",file, projectId,contractId);
        baseService.importExcelData(file, projectId,contractId);
        return new CommonResult<>("导入成功");
    }

    /**
     * 导出数据到Excel
     * @param queryFilter 通用查询器
     * @param response 响应对象
     * @return 通用结果
     * @throws IOException IO异常
     */
    @PostMapping("/exportDataToExcel")
    @ApiOperation(value = "S-导出数据到Excel",notes = "参数说明：查询器只使到了query组传参，其他都可以不要，查询条件要带上表别名：主表 bcm、副表 pm；传入pm.ID_导出该项目下的数据，否则将导出所有数据")
    public CommonResult exportDataToExcel (@ApiParam(name = "queryFilter",value = "通用查询器")@RequestBody QueryFilter<ProgressManage> queryFilter, HttpServletResponse response) throws IOException {
        log.debug("导出数据到Excel接口请求参数：{}",queryFilter,response);
        baseService.exportDataToExcel(queryFilter,response);
        return new CommonResult<>("导出成功");
    }

    /**
     * 导出数据到西永微电园公司项目拨（付）款申请审批单
     * @param id 通用查询器
     * @param response 响应对象
     * @return 通用结果
     * @throws IOException IO异常
     */
    @GetMapping("/exportApprovalForm")
    @ApiOperation(value = "S-导出项目拨（付）款申请审批单",notes = "参数说明：传入数据ID，导出对应的审批单")
    public CommonResult exportApprovalForm (@ApiParam(name = "id",value = "数据ID") @RequestParam String id, HttpServletResponse response) throws IOException {
        Assert.notNull(id, "ID不能为空！");
        // 定义自己的导出数据和格式，这里只是调用了导出数据列表的方法
        baseService.exportApprovalForm(id ,response);
        return new CommonResult<>("导出成功");
    }

    /**
     * 删除数据
     * @param ids 主键集合
     * @return 删除结果
     */
    @PostMapping("/delete")
    @ApiOperation(value = "S-删除数据",httpMethod = "POST")
    public CommonResult delete(@ApiParam(name = "ids",value = "ID集合") @RequestParam("ids") String ids) {
        log.debug("进度管理-删除数据接口请求参数：{}", ids);
        Assert.notNull(ids,"主键集合不能为空");
        boolean state = baseService.deleteByIds(Arrays.asList(ids.split(",")));
        String msg = state ? "删除成功" : "删除失败";
        log.debug("进度管理-删除数据接口响应结果：{}", msg);
        return new CommonResult<String>(state, msg);
    }

    /**
     * 通过主键查询单条数据
     * @param id 主键
     * @return 单条数据
     */
    @PostMapping("/detail/{id}")
    @ApiOperation(value = "S-根据ID查询详情",httpMethod = "POST")
    public CommonResult<ProgressManage> selectOne(@ApiParam(name = "id",value = "主键ID") @PathVariable String id) {
        log.debug("进度管理-根据ID查询详情 接口请求参数：{}", id);
        Assert.notNull(id,"主键不能为空");
        ProgressManage result = baseService.getById(id);
        boolean state = !BeanUtils.isEmpty(result);
        log.debug("进度管理-根据ID查询详情 接口响应结果：{}", result);
        return new CommonResult<ProgressManage>(state, state?"操作成功":"该ID没有对应数据", result);
    }

    /**
     * 分页查询所有数据
     * @param queryFilter 通用查询器
     * @return 分页数据
     */
    @PostMapping("/page")
    @ApiOperation(value = "S-分页查询所有数据",notes = "参数说明：在通用查询器中的query对象组传入查询参数，查询条件要带上表别名：主表-进度管理信息 bcm、副表-项目信息 pm、副表-合同信息 bc；传入pm.ID_ 项目ID 以切换项目",httpMethod = "POST")
    public CommonResult<PageList<ProgressManage>> selectAll(@ApiParam(name = "queryFilter",value = "通用查询器")@RequestBody QueryFilter<ProgressManage> queryFilter) {
        log.debug("进度管理-分页查询所有数据接口请求参数：{}", queryFilter);
        PageList<ProgressManage> result = baseService.queryAllByPage(queryFilter);
        log.debug("进度管理-分页查询所有数据接口响应结果：{}", result);
        return new CommonResult<>(true,"操作成功",result);
    }


    @PostMapping("/getAppropriatedl")
    @ApiOperation(value = "S-根据项目ID获取已拨款额(获取所有用途的已拨款)",httpMethod = "POST")
    public CommonResult<BigDecimal> getAppropriatedl(@ApiParam(name = "appropriatedlVo",value = "已拨款额查询参数VO")
                                                         @RequestBody AppropriatedlVo appropriatedlVo) {
        Assert.notNull(appropriatedlVo, "参数不能为空！");
        Assert.notNull(appropriatedlVo.getProjectId(), "项目ID不能为空！");
        BigDecimal result = baseService.getAmountAppropriatedl(appropriatedlVo);
        return new CommonResult<BigDecimal>(true, "已拨款额查询成功", result.stripTrailingZeros() );
    }

//    @PostMapping("/getAmountAppropriatedl")
//    @ApiOperation(value = "S-根据项目ID获取已拨款额(只获取用途为工程款的已拨款额)",httpMethod = "POST")
//    public CommonResult<BigDecimal> getAmountAppropriatedl(@ApiParam(name = "appropriatedlVo",value = "已拨款额查询参数VO")
//                                                               @RequestBody AppropriatedlVo appropriatedlVo) {
//        Assert.notNull(appropriatedlVo, "参数不能为空！");
//        Assert.notNull(appropriatedlVo.getProjectId(), "项目ID不能为空！");
//        BigDecimal result = baseService.getAppropriatedl(appropriatedlVo.getProjectId(), appropriatedlVo.getRegisterDate());
//        return new CommonResult<BigDecimal>(true, "已拨款额查询成功", result.stripTrailingZeros() );
//    }
//
//    @PostMapping("/getNotAppropriatedl")
//    @ApiOperation(value = "S-根据项目ID获取已拨款额(获取除开工程款以外的已拨款)",httpMethod = "POST")
//    public CommonResult<BigDecimal> getNotAppropriatedl(@ApiParam(name = "appropriatedlVo",value = "已拨款额查询参数VO")
//                                                            @RequestBody AppropriatedlVo appropriatedlVo) {
//        Assert.notNull(appropriatedlVo, "参数不能为空！");
//        Assert.notNull(appropriatedlVo.getProjectId(), "项目ID不能为空！");
//        BigDecimal result = baseService.getNotAppropriatedl(appropriatedlVo.getProjectId(), appropriatedlVo.getRegisterDate());
//        return new CommonResult<BigDecimal>(true, "已拨款额查询成功", result.stripTrailingZeros() );
//    }





    /**
     * 通过项目ID查询支付汇总情况
     * @param progressManageTotalVo 项目ID
     * @return 单条数据
     */
    @PostMapping("/getProgressManageTotalByProjectId")
    @ApiOperation(value = "S-根据项目ID查询支付汇总数据（查看界面）",httpMethod = "POST")
    public CommonResult<ProgressManageTotalVo> getProgressManageTotalByProjectId(
            @ApiParam(name = "progressManageTotalVo",value = "根据项目ID查询支付汇总数据参数VO")
            @RequestBody ProgressManageTotalVo progressManageTotalVo) {
        Assert.notNull(progressManageTotalVo,"参数不能为空");
        Assert.notNull(progressManageTotalVo.getProjectId(),"项目ID不能为空");
        return new CommonResult<ProgressManageTotalVo>(true, "数据查询成功",
                baseService.getProgressByProjectId(progressManageTotalVo));
    }

    /**
     * 通过项目ID查询有收款单位、账号、开户行的支付单子
     * @param projectId 项目ID
     * @return 单条数据
     */
    @GetMapping("/getProgressManageByProjectId/{projectId}")
    @ApiOperation(value = "S-根据项目ID查询有收款单位、账号、开户行的支付单子）",httpMethod = "GET")
    public CommonResult<ProgressManage> getProgressManageByProjectId(
            @ApiParam(name = "projectId",value = "项目ID") @PathVariable String projectId) {
        Assert.notNull(projectId,"参数不能为空");
        return new CommonResult<ProgressManage>(true, "数据查询成功",
                baseService.getProgressManageByProjectId(projectId));
    }




    @PostMapping("/recalManage")
    @ApiOperation(value = "多线程重算工程支付",httpMethod = "POST")
    public void recalManage(String projectId) {
        baseService.recalManage(projectId);

    }

}

