package com.artfess.report.bigScreen.model;

import com.artfess.base.entity.AutoFillModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

/**
 * 可视化数据源配置表
 *
 * @company 阿特菲斯
 * @author 超级管理员
 * @since 2021-07-12
 */
@ApiModel(value="BladeVisualDb对象", description="可视化数据源配置表")
@TableName("blade_visual_db")
public class BladeVisualDb extends AutoFillModel<BladeVisualDb> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "名称")
    @TableField("name_")
    private String name;

    @ApiModelProperty(value = "驱动类")
    @TableField("driver_class_")
    private String driverClass;

    @ApiModelProperty(value = "连接地址")
    @TableField("url_")
    private String url;

    @ApiModelProperty(value = "用户名")
    @TableField("username_")
    private String username;

    @ApiModelProperty(value = "密码")
    @TableField("password_")
    private String password;

    @ApiModelProperty(value = "备注")
    @TableField("remark_")
    private String remark;

    @ApiModelProperty(value = "状态")
    @TableField("status_")
    private Integer status;

    @ApiModelProperty(value = "是否已删除")
    @TableField("is_dele_")
    private String isDele;


    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public String getDriverClass() {
        return driverClass;
    }

    public void setDriverClass(String driverClass) {
        this.driverClass = driverClass;
    }
    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }
    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }
    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }
    public String getIsDele() {
        return isDele;
    }


    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "BladeVisualDb{" +
            "id=" + id +
            ", name=" + name +
            ", driverClass=" + driverClass +
            ", url=" + url +
            ", username=" + username +
            ", password=" + password +
            ", remark=" + remark +
            ", status=" + status +
            ", isDele=" + isDele +
        "}";
    }
}
