/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.security.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.HttpUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.security.manager.SysAuthorizationManager;
import com.artfess.security.model.SysAuthorization;
import com.artfess.security.util.AuthorCheck;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/uc/AuthorizationModel/v1"})
@Api(tags={"\u7cfb\u7edf\u7248\u6743\u6388\u6743"})
@ApiGroup(group={"group_uc"})
public class SysAuthorizationController
extends BaseController<SysAuthorizationManager, SysAuthorization> {
    public static final String ROOT_PATH = System.getProperty("user.dir");
    public static final String DATA_TEMP_FILE = "tempFile";
    public static final String TEMP_DATA_EXCEL = ROOT_PATH + File.separator + "tempFile";
    @Resource
    SysAuthorizationManager systemAuthorizationManager;
    @Autowired
    private AuthorCheck authorCheck;

    @PostMapping(value={"/listJson"})
    @ApiOperation(value="\u6570\u636e\u5217\u8868", httpMethod="POST", notes="\u83b7\u53d6\u5217\u8868")
    public PageList<SysAuthorization> list(@ApiParam(name="queryFilter", value="\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<SysAuthorization> queryFilter) throws Exception {
        List sorter = queryFilter.getSorter();
        queryFilter.setSorter(sorter);
        return this.systemAuthorizationManager.query(queryFilter);
    }

    @GetMapping(value={"/getJson"})
    @ApiOperation(value="\u6570\u636e\u8be6\u60c5", httpMethod="GET", notes="\u6570\u636e\u8be6\u60c5")
    public SysAuthorization get(@ApiParam(name="id", value="\u4e1a\u52a1\u5bf9\u8c61\u4e3b\u952e", required=true) @RequestParam String id) throws Exception {
        return (SysAuthorization)this.systemAuthorizationManager.get((Serializable)((Object)id));
    }

    @PostMapping(value={"save"})
    @ApiOperation(value="\u65b0\u589e,\u66f4\u65b0\u6570\u636e", httpMethod="POST", notes="\u65b0\u589e,\u66f4\u65b0\u6570\u636e")
    public CommonResult<String> save(@ApiParam(name="SysSystemAuthorization", value="\u4e1a\u52a1\u5bf9\u8c61", required=true) @RequestBody SysAuthorization sysAuthorization) throws Exception {
        String msg = "\u6dfb\u52a0\u6210\u529f";
        if (StringUtil.isEmpty((String)sysAuthorization.getId())) {
            this.systemAuthorizationManager.create((Model)sysAuthorization);
        } else {
            this.systemAuthorizationManager.update((Model)sysAuthorization);
            msg = "\u66f4\u65b0\u6210\u529f";
        }
        return new CommonResult(msg);
    }

    @DeleteMapping(value={"/remove"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u8bb0\u5f55", httpMethod="DELETE", notes="\u6279\u91cf\u5220\u9664\u8bb0\u5f55")
    public CommonResult<String> removes(String ... ids) throws Exception {
        this.systemAuthorizationManager.removeByIds(ids);
        return new CommonResult(true, "\u5220\u9664\u6210\u529f");
    }

    public void downloadFileLic(HttpServletResponse response) throws Exception {
        String path = this.systemAuthorizationManager.systemCreateFile();
        if (StringUtils.isEmpty((CharSequence)path)) {
            // empty if block
        }
        File file = new File(path);
        HttpUtil.downLoadFile((HttpServletResponse)response, (String)path, (String)file.getName());
    }

    public CommonResult<String> uploadFileLic(@ApiParam(name="file", value="\u4e0a\u4f20\u7684\u6587\u4ef6\u6d41") @RequestBody MultipartFile file, HttpServletResponse response) {
        try {
            String filePath = TEMP_DATA_EXCEL;
            File upload = new File(filePath);
            if (!upload.exists() && !upload.isDirectory()) {
                upload.mkdirs();
            }
            File dest = new File(TEMP_DATA_EXCEL + File.separator + ".lic");
            try {
                file.transferTo(dest);
            }
            catch (FileNotFoundException e) {
                return new CommonResult(false, "\u6ca1\u6709\u627e\u5230\u6388\u6743\u6587\u4ef6\uff1a" + e.getMessage());
            }
            catch (IOException e) {
                return new CommonResult(false, "\u6ca1\u6709\u627e\u5230\u6388\u6743\u6587\u4ef6\uff1a" + e.getMessage());
            }
            SysAuthorization entity = this.authorCheck.redFileToObject(dest);
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"DEPT_NAME_", (Object)entity.getDeptName());
            SysAuthorization systemAuthorization = (SysAuthorization)((Object)this.systemAuthorizationManager.getOne((Wrapper)queryWrapper));
            if (systemAuthorization != null) {
                entity.setId(systemAuthorization.getId());
            }
            this.systemAuthorizationManager.saveOrUpdate((Object)entity);
            return new CommonResult(true, "\u4e0a\u4f20\u6210\u529f");
        }
        catch (Exception e) {
            return new CommonResult(false, e.getMessage());
        }
    }

    @PostMapping(value={"/downloadAuthorizationFile"})
    @ApiOperation(value="\u4e0b\u8f7d\u6388\u6743\u6587\u4ef6")
    @ApiImplicitParam(name="id", value="id", required=true)
    public void downloadAuthorizationFile(HttpServletResponse response, HttpServletRequest request, String id) throws Exception {
        String path = this.systemAuthorizationManager.createDesFile(id);
        File file = new File(path);
        HttpUtil.downLoadFile((HttpServletResponse)response, (String)path, (String)file.getName());
    }

    @PostMapping(value={"/uploadAuthorizationFile"})
    @ApiOperation(value="\u4e0a\u4f20\u6388\u6743\u6587\u4ef6")
    public CommonResult<String> uploadAuthorizationFile(HttpServletResponse response, @ApiParam(name="file", value="\u4e0a\u4f20\u7684\u6587\u4ef6\u6d41") @RequestBody MultipartFile file) {
        try {
            String filePath = TEMP_DATA_EXCEL;
            File upload = new File(filePath);
            if (!upload.exists() && !upload.isDirectory()) {
                upload.mkdirs();
            }
            File dest = new File(AuthorCheck.FILE_PATH);
            try {
                file.transferTo(dest);
            }
            catch (IOException e) {
                return new CommonResult(false, e.getMessage());
            }
            return new CommonResult(true, "\u4e0a\u4f20\u6210\u529f");
        }
        catch (Exception e) {
            return new CommonResult(false, e.getMessage());
        }
    }

    private boolean checkExt(String fileExt) {
        String[] types;
        for (String type : types = new String[]{"data", "lic"}) {
            if (!fileExt.toLowerCase().endsWith(type.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    @PostMapping(value={"/querySystemAuthorization"})
    @ApiOperation(value="\u67e5\u8be2\u6388\u6743\u4fe1\u606f")
    public SysAuthorization querySystemAuthorization() {
        try {
            SysAuthorization resultCode = this.authorCheck.redFileToObject();
            return resultCode;
        }
        catch (Exception e) {
            return null;
        }
    }

    @PostMapping(value={"/checkSystemAuthorization"})
    @ApiOperation(value="\u767b\u5f55\u9875\u5224\u65ad\u662f\u5426\u663e\u793a\u4e0a\u4f20\u6388\u6743\u7801\u6309\u94ae")
    public CommonResult<String> checkSystemAuthorization() {
        try {
            String resultCode = this.authorCheck.newCheck();
            return new CommonResult(true, resultCode);
        }
        catch (Exception e) {
            return new CommonResult(false, e.getMessage());
        }
    }

    @PostMapping(value={"/systemStartCreateFile"})
    @ApiOperation(value="\u7cfb\u7edf\u542f\u52a8\u7684\u65f6\u5019\u9ed8\u8ba4\u751f\u6210\u4e00\u4e2a\u4e34\u65f6\u6388\u6743\u6587\u4ef6")
    public void systemStartCreateFile() throws Exception {
        this.systemAuthorizationManager.systemStartCreateFile();
    }
}

