package com.artfess.form.model;

import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * @program: cqgs
 * @Date: 2020/9/26 15:20
 * @Author: ZQF
 * @Description: 元件管理-取值函数维护表
 */
@Data
@ApiModel(value = "ComponentFunction对象",description = "元件管理-取值函数维护表")
@TableName("sys_component_function")
public class ComponentFunctionEntity extends BaseModel<ComponentFunctionEntity> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(name = "id", notes = "主键")
    @TableId("id_")
    protected String id;

    @TableField("FUN_NAME")
    @ApiModelProperty("函数名称")
    private String funName;

    @TableField("FUN_TYPE")
    @ApiModelProperty("函数类型（1：SESSION取值函数 2：系统取值函数 3：用户自定义取值函数）")
    private Integer funType;

    @TableField("FUN_MEMO")
    @ApiModelProperty("函数用途")
    private String funMemo;

    @TableField("FUN_QZ_CODE")
    @ApiModelProperty("函数取值方法")
    private String funQzCode;


    @TableField("FUN_DETAILS")
    @ApiModelProperty("函数代码串（动态获取后解析执行函数）")
    private String funDetails;

    @TableField("sn_")
    @ApiModelProperty("排序")
    private Integer sn;

}
