package com.artfess.cqxy.bidManagement.model;

import cn.afterturn.easypoi.excel.annotation.Excel;
import cn.afterturn.easypoi.excel.annotation.ExcelEntity;
import com.artfess.base.entity.BizModel;
import com.artfess.cqxy.projectManagement.model.ProjectManagement;
import com.artfess.cqxy.universal.model.Accessory;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 招投标管理 - 投标管理表(BidManagement)表实体类
 *
 * @author 黎沐华
 * @since 2022-04-08 15:34:31
 */
@Data
@TableName("BIZ_BID_MANAGEMENT")
@ApiModel(value="招投标管理-投标管理对象-BidManagement", description="投标管理表")
public class BidManagement extends BizModel<BidManagement> {

    // 关联项目的信息放在开头，以便在导出时先导出项目中的配置，而不用进行额外的位置配置
    @ExcelEntity(id = "link")
    @TableField(exist = false)
    @ApiModelProperty(value = "关联的项目信息")
    private ProjectManagement projectInfo;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @TableField("PROJECT_ID_")
    @ApiModelProperty(value = "项目ID（关联项目管理表ID）")
    private String projectId;

    @TableField("NAME_")
    @ApiModelProperty(value = "项目名称")
    private String name;

    @Excel(name = "文件编号")
    @TableField("DOCUMENT_NUMBER_")
    @ApiModelProperty(value = "文件编号")
    private String documentNumber;

    @Excel(name = "项目概况")
    @TableField("PROJECT_OVERVIEW_")
    @ApiModelProperty(value = "项目概况")
    private String projectOverview;

    @Excel(name = "招标单位")
    @TableField("TENDEREE_")
    @ApiModelProperty(value = "招标单位")
    private String tenderee;

    @Excel(name = "招标负责人")
    @TableField("BIDDING_CHARGE_PERSON_")
    @ApiModelProperty(value = "招标负责人")
    private String biddingChargePerson;

    @Excel(name = "招标代理机构")
    @TableField("BIDDING_AGENCY_")
    @ApiModelProperty(value = "招标代理机构")
    private String biddingAgency;

    @Excel(name = "招标日期",format = "yyyy-MM-dd")
    @TableField("BIDDING_DATE_")
    @ApiModelProperty(value = "招标日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date biddingDate;

    @Excel(name = "招标限价（单位：万元）", type = 10, numFormat = "0.00")
    @TableField("BIDDING_FIXED_PRICE_")
    @ApiModelProperty(value = "招标限价（单位：万元）")
    private String biddingFixedPrice;

    @Excel(name = "招标范围")
    @TableField("BIDDING_RANGE_")
    @ApiModelProperty(value = "招标范围")
    private String biddingRange;

    @Excel(name = "监理单位")
    @TableField("CONSTRUCTION_CONTROL_UNIT_")
    @ApiModelProperty(value = "监理单位")
    private String constructionControlUnit;

    @Excel(name = "检测单位")
    @TableField("TESTING_UNIT_")
    @ApiModelProperty(value = "检测单位")
    private String testingUnit;

    @Excel(name = "计划工期")
    @TableField("PLANNED_CONSTRUCTION_PERIOD_")
    @ApiModelProperty(value = "计划工期")
    private String plannedConstructionPeriod;

    @Excel(name = "投标金额")
    @TableField("BID_AMOUNT_")
    @ApiModelProperty(value = "投标金额")
    private String bidAmount;

    @Excel(name = "投标日期",format = "yyyy-MM-dd")
    @TableField("BID_DATE_")
    @ApiModelProperty(value = "投标日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date bidDate;

    @Excel(name = "是否中标")
    @TableField("BID_OF_")
    @ApiModelProperty(value = "是否中标，（使用字典：0：未中标，1：已中标）")
    private String bidOf;

    @Excel(name = "备注")
    @TableField("ESTABLISHMENT_REMARKS_")
    @ApiModelProperty(value = "备注")
    private String establishmentRemarks;

    @TableField(exist = false)
    @ApiModelProperty(value = "附件信息")
    private List<Accessory> accessoryInfo;
    
    /**
     * 获取主键值
     * @return 主键值
     */
    @Override
    protected Serializable pkVal() {
        return this.id;
    }
}

