package com.artfess.cqxy.processManagermant.model;


import cn.afterturn.easypoi.excel.annotation.Excel;
import cn.afterturn.easypoi.excel.annotation.ExcelEntity;
import com.artfess.base.entity.BizModel;
import com.artfess.cqxy.projectManagement.model.ProjectManagement;
import com.artfess.cqxy.universal.model.Accessory;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 过程管理 - 质量管理-质量巡检(BizQualityInspection)表实体类
 *
 * @author 黎沐华
 * @since 2022-03-03 11:38:43
 */
@Data
@TableName("BIZ_QUALITY_INSPECTION")
@ApiModel(value="过程管理-质量管理-质量巡检对象-QualityInspection", description="过程管理-质量管理-质量巡检表")
public class QualityInspection extends BizModel<QualityInspection> {

    // 关联项目的信息放在开头，以便在导出时先导出项目中的配置，而不用进行额外的位置配置
    @ExcelEntity(id = "link")
    @TableField(exist = false)
    @ApiModelProperty(value = "关联的项目信息")
    private ProjectManagement projectInfo;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @TableField("PROJECT_ID_")
    @ApiModelProperty(value = "项目ID（关联项目管理表ID）")
    private String projectId;

    @Excel(name = "巡检编号")
    @TableField("QUALITY_CODE_")
    @ApiModelProperty(value = "巡检编号，（由后台生成，生成格式：ZLXJ+年月日+01，01表示按天自增）")
    private String qualityCode;

    @TableField("QUALITY_USER_ID_")
    @ApiModelProperty(value = "质检员ID")
    private String qualityUserId;

    @Excel(name = "质检员姓名")
    @TableField("QUALITY_USER_NAME_")
    @ApiModelProperty(value = "质检员姓名")
    private String qualityUserName;

    @Excel(name = "检查部位")
    @TableField("QUALITY_INSPECT_POSITION_")
    @ApiModelProperty(value = "检查部位")
    private String qualityInspectPosition;

    @Excel(name = "检查情况")
    @TableField("CHECK_SITUATION_")
    @ApiModelProperty(value = "检查情况")
    private String checkSituation;

//    @Excel(name = "纠正预防措施")
    @TableField("PREVENTION_MEASURES_")
    @ApiModelProperty(value = "纠正预防措施")
    private String preventionMeasures;

    @Excel(name = "备注")
    @TableField("REMARKS_")
    @ApiModelProperty(value = "备注")
    private String remarks;

    @TableField(exist = false)
    @ApiModelProperty(value = "附件信息")
    private List<Accessory> accessoryInfo;

    /**
     * 获取主键值
     * @return 主键值
     */
    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "QualityInspection{" +
                "id='" + id + '\'' +
                ", projectId='" + projectId + '\'' +
                ", qualityCode='" + qualityCode + '\'' +
                ", qualityUserId='" + qualityUserId + '\'' +
                ", qualityUserName='" + qualityUserName + '\'' +
                ", qualityInspectPosition='" + qualityInspectPosition + '\'' +
                ", checkSituation='" + checkSituation + '\'' +
                ", preventionMeasures='" + preventionMeasures + '\'' +
                ", remarks='" + remarks + '\'' +
                ", projectInfo=" + projectInfo +
                ", accessoryInfo=" + accessoryInfo +
                '}';
    }
}

