package com.artfess.cqxy.ledger.vo;

import com.artfess.base.annotation.BigDecimalFormat;
import com.artfess.cqxy.projectManagement.model.ProjectManagement;
import com.artfess.cqxy.utils.BizUtils;
import com.artfess.sysConfig.persistence.param.DictModel;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @author Limuhua
 * @date 2022/3/15 15:36
 */
@Data
@ApiModel(value="台账-项目信息台账对象-ProjectLedgerVo")
public class ProjectLedgerVo{

    @ApiModelProperty(value = "项目类型（使用字典）")
    private Integer projectType;

    @ApiModelProperty(value = "项目名称")
    private String projectName;

    @ApiModelProperty(value = "项目状态（使用字典：1：决策阶段，2：立项阶段：3：可研规划阶段，4：初步设计阶段，5：概算阶段，6：施工图设计阶段，7：环评阶段，8：水保阶段，9：招投标阶段，10：施工许可审批阶段，11：施工阶段，12：竣工验收阶段，13：结算阶段，14：决算阶段，15：已完成）")
    private String projectStatus;

    @ApiModelProperty(value = "项目负责人")
    private String projectManager;

    @ApiModelProperty(value = "决策文件类型 / 决策依据，可多选（使用字典，1：党委会，2：董事会，3：总经理办公会，4：请示，5：中标通知书，6：其他）")
    private String decisionBasisType;

    @ApiModelProperty(value = "责任单位")
    private String responsibleUnit;

    @ApiModelProperty(value = "地勘单位")
    private String geologicalProspectingUnit;

    @ApiModelProperty(value = "设计单位")
    private String designUnit;

    @ApiModelProperty(value = "监理单位")
    private String supervisorUnit;

    @ApiModelProperty(value = "施工单位")
    private String constructUnit;

    @ApiModelProperty(value = "合同金额")
    @BigDecimalFormat
    private BigDecimal contractAmount;

    @ApiModelProperty(value = "招标方式/发包方式，（使用字典：1：公开招标，2：直接委托，3：走流程，4其他）")
    private String biddingChargeType;

    @ApiModelProperty(value = "建设地址")
    private String projectAddress;

    @ApiModelProperty(value = "项目规模及内容")
    private String projectContent;

    @ApiModelProperty(value = "开工时间")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date commencementTime;

    @ApiModelProperty(value = "完工时间")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date completionTime;

    @ApiModelProperty(value = "项目金额(万元)/总投资")
    private String projectMoney;

//    @ApiModelProperty(value = "可研估算总投资(万元)")
//    @BigDecimalFormat
//    private BigDecimal feasibilityStudyEstimate;
//
//    @ApiModelProperty(value = "初设概算总投资")
//    @BigDecimalFormat
//    private BigDecimal preliminaryEstimate;

    public static ProjectLedgerVo convertVo(ProjectManagement data,ProjectLedgerVo tran, List<DictModel> dType, List<DictModel> chargeType, List<DictModel> pStatus){
        ProjectLedgerVo temp = new ProjectLedgerVo();
        temp.setProjectType(Integer.valueOf(data.getProjectType()));
        temp.setProjectName(data.getProjectName());
        temp.setProjectStatus(BizUtils.getDicValueByCode(pStatus, data.getProjectStatus()));
        temp.setProjectManager(data.getProjectManager());
        temp.setResponsibleUnit(data.getOwnerUnit());
        temp.setGeologicalProspectingUnit(data.getGeologicalProspectingUnit());
        temp.setDesignUnit(data.getDesignUnit());
        temp.setSupervisorUnit(data.getSupervisorUnit());
        temp.setConstructUnit(data.getConstructUnit());
        temp.setContractAmount(null != tran.getContractAmount()?tran.getContractAmount():BigDecimal.ZERO);
        temp.setProjectAddress(null!=tran.getProjectAddress()?tran.getProjectAddress():"");
        temp.setProjectContent(null!=tran.getProjectContent()?tran.getProjectContent():"");
        temp.setCommencementTime(data.getCommencementTime());
        temp.setCompletionTime(data.getCompletionTime());
        temp.setProjectMoney(null != data.getProjectMoney()?data.getProjectMoney().stripTrailingZeros().toPlainString(): "0");
//        temp.setFeasibilityStudyEstimate(data.getFeasibilityStudyEstimate());
//        temp.setPreliminaryEstimate(data.getPreliminaryEstimate());
        temp.setDecisionBasisType(BizUtils.getDicValueByCode(chargeType, tran.getDecisionBasisType()));
        temp.setBiddingChargeType(BizUtils.getDicValueByCode(dType, tran.getBiddingChargeType()));
        return temp;
    }

    @Override
    public String toString() {
        return "ProjectLedgerVo{" +
                "projectType=" + projectType +
                ", projectName='" + projectName + '\'' +
                ", projectStatus='" + projectStatus + '\'' +
                ", projectManager='" + projectManager + '\'' +
                ", decisionBasisType='" + decisionBasisType + '\'' +
                ", responsibleUnit='" + responsibleUnit + '\'' +
                ", geologicalProspectingUnit='" + geologicalProspectingUnit + '\'' +
                ", designUnit='" + designUnit + '\'' +
                ", supervisorUnit='" + supervisorUnit + '\'' +
                ", constructUnit='" + constructUnit + '\'' +
                ", contractAmount=" + contractAmount +
                ", biddingChargeType=" + biddingChargeType +
                ", projectAddress='" + projectAddress + '\'' +
                ", projectContent='" + projectContent + '\'' +
                ", commencementTime=" + commencementTime +
                ", completionTime=" + completionTime +
                ", projectMoney='" + projectMoney + '\'' +
//                ", feasibilityStudyEstimate='" + feasibilityStudyEstimate + '\'' +
//                ", preliminaryEstimate='" + preliminaryEstimate + '\'' +
                '}';
    }

}
