package com.artfess.base.webSocket;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;

/**
 * @author 陈实
 * @Package com.artfess.base.webSocket
 * @date 2021/9/16 9:59
 * @Description:心跳包测试处理类
 */
public class HeartBeatHandler extends ChannelInboundHandlerAdapter {
    private int lossConnectCount = 0;
    @Override
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof IdleStateEvent){
            IdleStateEvent event = (IdleStateEvent)evt;
            if (event.state()== IdleState.READER_IDLE){
                System.out.println("读空闲");
            }else if(event.state()== IdleState.WRITER_IDLE){
                System.out.println("写空闲");
            }else if(event.state()== IdleState.ALL_IDLE){
                System.out.println("读写都空闲你，关闭通道");
                lossConnectCount ++;
                if (lossConnectCount > 2){
                    ctx.channel().close();
                }
            }
        }else {
            super.userEventTriggered(ctx,evt);
        }
    }
}
