package com.artfess.xqxt.meeting.vo;

import com.artfess.base.entity.BizModel;
import com.artfess.uc.model.UserGroup;
import com.artfess.xqxt.meeting.model.Meeting;
import com.artfess.xqxt.meeting.model.MeetingPlace;
import com.artfess.xqxt.meeting.model.MeetingUser;
import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiOperation;
import lombok.Data;

import java.time.LocalDateTime;
import java.util.List;

@Data
@ApiOperation(value = "会议实体类VO")
public class MeetingVO extends BizModel<MeetingVO> {
    @ApiModelProperty("主键ID")
    private String id;

    @ApiModelProperty("会议主题")
    private String theme;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("开始时间")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private LocalDateTime startTime;

    @ApiModelProperty("会议时长,单位分钟")
    private Integer duration;

    @ApiModelProperty("结束时间")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private LocalDateTime endTime;

    @ApiModelProperty("提醒人员类别")
    private Integer remindUser;

    @ApiModelProperty("主持人")
    private String host;

    @ApiModelProperty("开会密码")
    private String password;

    @ApiModelProperty("是否开启等候室（0是1否）")
    private Integer isWaitRoom;

    @ApiModelProperty("是否允许成员在主持人进会前加入（0是1否）")
    private Integer isOpen;

    @ApiModelProperty("提醒时间类别")
    private String remindTime;

    @ApiModelProperty("静音类别")
    private Integer mute;

    @ApiModelProperty("入会成员限制")
    private Integer limitUser;

    @ApiModelProperty("是否开启水印（0是1否）")
    private Integer isWatermark;

    @ApiModelProperty("会议类型,1:普通会议，2：视频会议")
    private Integer meetingType;

    @ApiModelProperty("会议状态")
    private Integer meetingStatus;

    @ApiModelProperty("删除状态")
    private Integer idDele;

    @ApiModelProperty("创建人")
    private String createName;

    @ApiModelProperty("创建人ID")
    private String createBy;

    @ApiModelProperty("是否发送消息")
    private Integer isSend;

    @ApiModelProperty("会议内容")
    @TableField("CONTENT_")
    private String content;

    @ApiModelProperty("会议轮训状态(0：轮训开启，1：轮训关闭)")
//    @TableField("ROTATION_STATUS_")
    private Integer rotationStatus;

    @ApiModelProperty("分组")
    private List<UserGroup> userGroups;

    @ApiModelProperty("参会人")
    private List<MeetingUser> users;

    @ApiModelProperty("会议室")
    private List<MeetingPlace> places;


    @ApiModelProperty("会议编号")
//    @TableField("CONFERENCE_NUMBER_")
    private String conferenceNumber;

    @ApiModelProperty("支持录播，true：支持，false：不支持")
//    @TableField("IF_RECORD_")
    private Boolean ifRecord;

    @ApiModelProperty("录制状态，Recording 录制中 Pause 暂停")
//    @TableField("RECORD_STATE_")
    private String recordState;

    @ApiModelProperty("是否处于锁定状态， true 锁定 false 非锁定")
//    @TableField("LOCK_STATE_")
    private Boolean lockState;

    @ApiModelProperty("会议控制模式， chairman ：主席控制，director：导演控制， vas：声控")
//    @TableField("CONFCTRL_MODE_")
    private String confCtrlMode;

    @ApiModelProperty("广播源会场 ID")
//    @TableField("BOARDCASTER_")
    private String boardcaster;

    @ApiModelProperty("辅视频源会场 ID")
//    @TableField("DUAL_BOARDCASTER_")
    private String dualBoardcaster;

    @ApiModelProperty("主席会场 ID")
//    @TableField("CHAIRMAN_")
    private String chairman;

    @ApiModelProperty("是否 UP 模式 up：UP 会议 normal：普通会议")
//    @TableField("IF_UP_MODE_")
    private String ifUpMode;

    @ApiModelProperty("会议多画面模式： auto:自动控制多画面 manual:手动控制")
//    @TableField("MULTI_PICCTRL_MODE_")
    private String multiPicCtrlMode;

    @ApiModelProperty("最大画面数 1~25")
//    @TableField("MAX_PIC_NUM_")
    private Integer maxPicNum;

    @ApiModelProperty("当前画面数")
//    @TableField("CUR_PIC_NUM_")
    private Integer curPicNum;

    @ApiModelProperty("当前用户反馈状态，0：已反馈，1：未反馈，默认为1")
    private String feedBackStatus;

    @ApiModelProperty("当前用户反馈结果，1：准时参加会议，2：推迟参加会议，3：不能参加会议")
    private String feedBack;

    @ApiModelProperty("当前用户预计入会时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime estimatedArrivalDate;

    @ApiModelProperty("当前用户预计晚到时间，单位：分钟，当反馈结果为推迟参加会议时填写")
    private Long estimatedArrivalTime;

    @ApiModelProperty("当前用户未入会/延迟入会原因，当反馈结果不为【准时参加会议】时填写")
    private String notJoiningReasons;

    @ApiModelProperty("反馈时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime feedBackDate;


    @ApiModelProperty("是否可以结束 0表示否 1可以")
    private Integer endPower;
}
