package com.artfess.xqxt.meeting.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.xqxt.meeting.dto.MeetingDTO;
import com.artfess.xqxt.meeting.m900.bean.ParticipantStatusV2;
import com.artfess.xqxt.meeting.manager.MeetingManager;
import com.artfess.xqxt.meeting.manager.MeetingUserManager;
import com.artfess.xqxt.meeting.manager.ZTEManager;
import com.artfess.xqxt.meeting.model.Meeting;
import com.artfess.xqxt.meeting.model.MeetingUser;
import com.artfess.xqxt.meeting.model.ZTEErrorCode;
import com.artfess.xqxt.meeting.vo.*;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import java.util.Arrays;
import java.util.List;

@RestController
@RequestMapping("/meetingUser/v1/")
@Api(tags = "会议人员信息模块")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class MeetingUserController extends BaseController<MeetingUserManager, MeetingUser> {


    @Resource
    private MeetingUserManager meetingUserManager;


    @RequestMapping(value = "/queryFeedBackUserList", method = RequestMethod.POST)
    @ApiOperation(value = "反馈-查询会议人员列表", httpMethod = "POST")
    public CommonResult<PageList<MeetingUser>> queryFeedBackUserList(@ApiParam(name = "queryFilter", value = "查询会议用户通用查询器")
                                                       @RequestBody QueryFilter<MeetingUser> queryFilter)  {
        PageList<MeetingUser> list = meetingUserManager.findList(queryFilter);
        return new CommonResult<PageList<MeetingUser>>(true,"数据查询成功！", list);
    }

    @RequestMapping(value = "/feedBackCount", method = RequestMethod.GET)
    @ApiOperation(value = "反馈-反馈人员数量统计", httpMethod = "GET")
    public CommonResult<FeedBackCountVo> feedBackCount(@RequestParam String meetingId)  {

        return new CommonResult<FeedBackCountVo>(true,"数据查询成功！", meetingUserManager.feedBackCount(meetingId));
    }

}
