package com.artfess.sysConfig.persistence.manager;

import com.alibaba.fastjson.JSONArray;
import com.artfess.base.manager.BaseManager;
import com.artfess.sysConfig.persistence.model.SysAreas;

import java.util.List;
import java.util.Map;

/**
 * @Program: edp
 * @Date: 2021/3/2
 * @Author: ZQF
 * @Description: 系统行政区划
 */
public interface SysAreasManager extends BaseManager<SysAreas> {

    String saveSysAreas(SysAreas sysAreas);

    String saveBatchSysAreas(List<SysAreas> sysAreas);

    List<SysAreas> queryAreasEntity(SysAreas sysAreas);

    List<SysAreas> queryByParentId(String parentId);

    void updateSequence(Map<String, Integer> params);

    void deleteBatch(String ids);

    JSONArray tree(SysAreas sysAreas);
}
