import {
  defineComponent,
  reactive,
  onBeforeMount,
  onMounted,
  watch,
} from 'vue'
import * as echarts from 'echarts'
import {
  paramsExample,
  getColor,
} from './pie_config'
let idx = 1
export default defineComponent({
  props: {
    datas: {
      type: Object,
      default: () => paramsExample,
    },
  },
  setup(props) {
    const state = reactive<any>({
      chartId: '',
      height: '100px',
      width: '100px',
      noData: false,
    })

    // 初始化
    let myChart: any = null
    const initChart = () => {
      const dom = document.getElementById(state.chartId)
      if (!dom) {
        return
      }
      myChart = echarts.init(dom)
    }
    const handleData = () => {
      const { data } = props.datas
      const { startColor, endColor } = getColor(data)
      let valData: Array<any> = []
      data.map((item: any, index: number) => {
        valData.push({
          name: item.name,
          value: item.value,
          itemStyle: {
            normal: {
              color: new echarts.graphic.LinearGradient(0, 0, 0, 1, [
                {
                  offset: 0,
                  color: startColor[index],
                },
                {
                  offset: 1,
                  color: endColor[index],
                },
              ]),
            },
          },
        })
      })
      if (!valData.length) {
        valData = [{
          value: 100,
          itemStyle: {
            normal: {
              color: '#dddddd'
            }
          }
        }]
      }
      return { valData }
    }
    const setChatOption = () => {
      const { datas } = props
      if (!datas) {
        state.noData = true
        myChart && myChart.clear()
        return
      }
      state.noData = false
      const { title, pieCenter, data } = datas
      const { valData } = handleData()
      const options = {
        title: {
          show: title,
          text: title + ' ',
          left: '50%',
          textAlign: 'center',
          textStyle: {
            fontWeight: 'normal',
            fontSize: '16',
            color: '#fff',
            textAlign: 'center',
          },
        },
        legend: {
          top:"middle",
          left:"0",
          textStyle: {
            color: '#AAAFC8',
          },
          orient: 'vertical',
        },
        tooltip: {
          show: false,
          trigger: 'item',
          backgroundColor: 'rgba(50, 50, 50, 0.7)',
          borderColor: 'rgb(51, 51, 51)',
          textStyle: {
            color: 'rgb(255, 255, 255)',
          },
        },
        series: [
          {
            silent: data.length ? false : true,
            avoidLabelOverlap: true, // 是否启用防止标签重叠策略
            legendHoverLink: false, // 是否启用图例 hover 时的联动高亮
            type: 'pie',
            radius: ['55%', '72%'],
            center: pieCenter || ['50%', '50%'],
            startAngle: 225,
            labelLine: {
              normal: {
                show: false,
              },
            },
            label: {
              show: false,
              position: 'center',
              formatter: '{b}：{c}',
            },
            emphasis: {
              label: {
                show: true,
                fontSize: 16,
                color: '#AAAFC8',
              },
            },
            data: valData,
          },
        ],
      }
      !myChart && initChart()
      myChart && myChart.setOption(options)
      data.length && setSelected()
    }
    const setSelected = () => {
      let selectedIndex = 0
      let maxValue = ''
      const list = JSON.parse(JSON.stringify(props.datas.data))
      // 默认选中最大值
      list.map((item: any, index: number) => {
        if (item.value > maxValue) {
          selectedIndex = index
          maxValue = item.value
        }
      })
      myChart.dispatchAction({
        type: "highlight",
        dataIndex: selectedIndex,
      })
      
      myChart.on("mouseover", (e:any) =>{
        if (e.dataIndex !== selectedIndex) {
          myChart.dispatchAction({
            type: "downplay",
            dataIndex: selectedIndex,
          });
          myChart.dispatchAction({
            type: "highlight",
            dataIndex: e.dataIndex,
          })
          selectedIndex = e.dataIndex
        }
      })
    }

    watch(
      () => props.datas,
      () => {
        setChatOption()
      },
      { deep: true }
    )
    onBeforeMount(() => {
      state.height = props.datas.height || state.height
      state.width = props.datas.width || state.width
      state.chartId = `ringChart_${idx++}`
    })
    onMounted(() => {
      setChatOption()
    })
    return () => (
      <>
        <div
          v-show={!state.noData}
          style={{ height: state.height, width: state.width }}
          id={state.chartId}
        ></div>
        <div
          v-show={state.noData}
          style={{ height: state.height }}
          class="flex justify-center items-center"
        >
          暂无数据
        </div>
      </>
    )
  },
})
