import axios from "@/utils/axiosCrossDomain";
import { get } from "@/utils/cookie";
const baseUrl = "/yyglapi";
//获取事件统计
export function getStatisticsOneEventType(data) {
  return axios.post(
    `${baseUrl}/zhdd/cdm/eventInfo/statisticsOneEventType`, data,
    {
      headers: {
        token: get("token"), //token换成从缓存获取
      },
    }
  )
}
// 获取事件统计 去除无事件描述的
export function getStatisticsOneEventTypeWithDesc(data) {
  return axios.post(
    `${baseUrl}/zhdd/cdm/eventInfo/statisticsOneEventTypeWithDesc`, data,
    {
      headers: {
        token: get("token"), //token换成从缓存获取
      },
    }
  )
}
// 获取实时事件
export function getAllEvents(params) {
  return axios.get(
    `${baseUrl}/zhdd/cdm/eventInfo/findByPage`,
    {
      headers: {
        token: get("token"), //token换成从缓存获取
      },
      params
    }
  )
}