// import axios from '@/utils/axios';
import axios from "@/utils/axiosCrossDomain";

// 需要暂时屏蔽掉未开通的省份
// 安徽、湖南、新疆、河北、江西
const ignoreOrgCodes = ["AH", "HN", "XJ", "HB", "JX"];

const baseUrl = "/http-server-base/publish/quota-v1";
const NewBaseUrl = "/http-server-base/publish/cockpit/quota-v1";
const api = `/bizapi1${baseUrl}`;
const Newapi = `/bizapi2${NewBaseUrl}`;

/**
 * 收费重点数据
 */

//新接口8/7 减免费用
export function GetreduceFee(params) {
    return axios.get(`${api}/reduceFee`, { params }).then((res) => {
        // 04.21去掉死数据
        // if (
        //   params.dimension === "1551973630102081536" ||
        //   params.dimension === "401" ||
        //   params.dimension === "YN"
        // ) {
        //   res.msgContent = [
        //     {
        //       reduceAmount: 4735.2,
        //       timeFlag: "2023",
        //     },
        //   ];
        // }
        return res;
    });
}

// 当日门架数据状态上传状态
export function Geteupdatastatus(params) {
    return axios.get(`${api}/gateupdatastatus`, { params });
}

// 日均预清分车流量  新街口
export function Gateavgclear(params) {
    return axios.get(`${api}/gateavgclear`, { params });
}
// 当日门架上传状态
export function dayAvgFlowcount(params) {
    return axios.get(`${api}/dayAvgFlowcount`, { params }).then((res) => {
        if (
            params.dimension === "1551973630102081536" ||
            params.dimension === "401" ||
            params.dimension === "YN"
        ) {
            res.msgContent[0].flowCount = 2357517;
        }
        return res;
    });
}

// 收费重点数据--当日特情车辆数
export function daySpecialnum(params) {
    return axios.get(`${api}/daySpecialnum`, { params }).then((res) => {
        if (
            params.dimension === "1551973630102081536" ||
            params.dimension === "401" ||
            params.dimension === "YN"
        ) {
            res.msgContent = [
                {
                    specialnum: 230800,
                    timeFlag: "2023",
                },
            ];
        } else if (
            params.dimension === "1551973634565787637" ||
            params.dimension === "201" ||
            params.dimension === "SC"
        ) {
            res.msgContent = [
                {
                    specialnum: 93600,
                    timeFlag: "2023",
                },
            ];
        }
        return res;
    });
}

// 收费重点数据--年度货车通行量
export function yearTruckFlow(params) {
    return axios.get(`${api}/yearTruckFlow`, { params });
    //   .then((res) => {
    //     if (
    //       params.dimension === "1551973630102081536" ||
    //       params.dimension === "401" ||
    //       params.dimension === "YN"
    //     ) {
    //       res.msgContent[0].keFlowCount = 2068582;
    //       res.msgContent[0].huoFlowCount = 288935;
    //     }
    //     return res;
    //   });
}

// 收费重点数据--当日通行费
export function currentDayFee(params) {
    return axios.get(`${api}/currentDayFee`, { params });
}

// 收费重点数据--清分预算
export function qingfenAmount(params) {
    return axios.get(`${api}/qingfenAmount`, { params });
    //   .then((res) => {
    //     if (
    //       params.dimension === "1551973630102081536" ||
    //       params.dimension === "401" ||
    //       params.dimension === "YN"
    //     ) {
    //       res.msgContent[0].qingfenAmount = 39994.744097;
    //     }
    //     return res;
    //   });
}

// 收费重点数据--年度etc通行量
export function yearEtcFlow(params) {
    return axios.get(`${api}/yearEtcFlow`, { params });
}

// 统计图断面流量
export function gateflow(params) {
    return axios.get(`${api}/gateflow`, { params });
}

// 断面流量 -- 左侧数据
export function gateSummary(params) {
    return axios.get(`${api}/gateSummary`, { params });
    //   .then((res) => {
    //     if (
    //       params.dimension === "1551973630102081536" ||
    //       params.dimension === "401" ||
    //       params.dimension === "YN"
    //     ) {
    //       const data = res.msgContent[0];
    //       if (params.timeflag === "202309") {
    //         data.flowCount = 423795;
    //       } else if (params.timeflag === "202310") {
    //         data.flowCount = 436064;
    //       } else if (params.timeflag === "202210") {
    //         data.flowCount = 354234;
    //       }
    //     }
    //     return res;
    //   });
}

// 断面流量 -- 统计图
export function gateSummaryChild(params) {
    return axios.get(`${api}/gateSummaryChild`, { params }).then((res) => {
        res.msgContent = res.msgContent.filter(
            (item) => !ignoreOrgCodes.includes(item.orgCode)
        );
        return res;
    });
}

// 通行量同比/环比（金额、车辆） -- 左侧数据
export function inOutSummary(params) {
    return axios.get(`${api}/inOutSummary`, { params });
}

// 通行量同比/环比（金额、车辆） -- 统计图
export function inOutSummaryChild(params) {
    return axios.get(`${api}/inOutSummaryChild`, { params }).then((res) => {
        res.msgContent = res.msgContent.filter(
            (item) => !ignoreOrgCodes.includes(item.orgCode)
        );
        return res;
    });
}

/**
 * 当日通行费/排行里 新接口
 */
export function GettodayGateFlowfee(params) {
    return axios.get(`${api}/fiveminGateFlowfee`, { params }).then((res) => {
        if (
            params.dimension === "1551973630102081536" ||
            params.dimension === "401" ||
            params.dimension === "YN"
        ) {
            // 造假数据
            res.msgContent = [
                {
                    feeSum: 91420.18275,
                    flowCount: 5006,
                    gantryId: "G562153002000110010",
                    gantryName: "昆楚接楚大-一平浪站",
                    oldFeeSum: 0,
                    oldFlowCount: 0,
                    timeFlag: "202311260111",
                },
                {
                    feeSum: 146576.5525,
                    flowCount: 5389,
                    gantryId: "G562153002000210010",
                    gantryName: "一平浪站-禄丰站",
                    oldFeeSum: 0,
                    oldFlowCount: 0,
                    timeFlag: "202311260111",
                },
                {
                    feeSum: 79614.0335,
                    flowCount: 6048,
                    gantryId: "G562153002000310010",
                    gantryName: "禄丰站-和平站",
                    oldFeeSum: 0,
                    oldFlowCount: 0,
                    timeFlag: "202311260111",
                },
                {
                    feeSum: 51059.20225,
                    flowCount: 5405,
                    gantryId: "G562153002000410010",
                    gantryName: "和平站-昆楚接武易",
                    oldFeeSum: 0,
                    oldFlowCount: 0,
                    timeFlag: "202311260111",
                },
                {
                    feeSum: 97027.56025,
                    flowCount: 4108,
                    gantryId: "G562153002000510010",
                    gantryName: "昆楚接武易-谷律站",
                    oldFeeSum: 0,
                    oldFlowCount: 0,
                    timeFlag: "202311260111",
                },
                {
                    feeSum: 59055.8135,
                    flowCount: 4185,
                    gantryId: "G562153002000410010",
                    gantryName: "谷律站-昆楚接西北绕",
                    oldFeeSum: 0,
                    oldFlowCount: 0,
                    timeFlag: "202311260111",
                },
                {
                    feeSum: 14815.123,
                    flowCount: 1216,
                    gantryId: "G562153002000410011",
                    gantryName: "昆楚接西北绕-花红园站",
                    oldFeeSum: 0,
                    oldFlowCount: 0,
                    timeFlag: "202311260111",
                },
            ];
        }
        return res;
    });
}

/**
 * 当日通行费/排行里
 */
export function stationSectionDay(params) {
    return axios.get(`${api}/stationSectionDay`, { params });
}

/**
 * 门架数据上传状态
 */
export function gantryStatus(params) {
    return axios.get(`${api}/gantryStatus`, { params });
}
/**
 * 门架成功率
 */
export function gateSuccessRate(params) {
    return axios.get(`${api}/gateSuccessRate1`, { params }).then((res) => {
        if (
            params.dimension === "1551973630102081536" ||
            params.dimension === "401" ||
            params.dimension === "YN"
        ) {
            res.msgContent = [
                {
                    cardTradeCount: 8747982,
                    cardTradeSuccess: 8660177,
                    cardTradeSuccessRate: 0.9814,
                    cpcTradeCount: 4386056,
                    cpcTradeSuccess: 3896196,
                    cpcTradeSuccessRate: 0.9687,
                    obuTradeCount: 8747603,
                    obuTradeSuccess: 8695509,
                    obuTradeSuccessRate: 0.9884,
                    orgCode: params.dimension,
                    orgName: "",
                    platerecoCount: 7468386,
                    platerecoSuccess: 6593793,
                    platerecoSuccessRate: 0.978,
                    etcPlaterecoSuccessRate: 0.9824,
                    cpcPlaterecoSuccessRate: 0.9796,
                    timeFlag: "202311",
                },
            ];
        } else if (
            params.dimension === "1551973634565787637" ||
            params.dimension === "201" ||
            params.dimension === "SC"
        ) {
            res.msgContent = [
                {
                    cardTradeCount: 8747982,
                    cardTradeSuccess: 8660177,
                    cardTradeSuccessRate: 0.9812,
                    cpcTradeCount: 4386056,
                    cpcTradeSuccess: 3896196,
                    cpcTradeSuccessRate: 0.9663,
                    obuTradeCount: 8747603,
                    obuTradeSuccess: 8695509,
                    obuTradeSuccessRate: 0.9878,
                    orgCode: params.dimension,
                    orgName: "",
                    platerecoCount: 7468386,
                    platerecoSuccess: 6593793,
                    platerecoSuccessRate: 0.9756,
                    etcPlaterecoSuccessRate: 0.9743,
                    cpcPlaterecoSuccessRate: 0.9886,
                    timeFlag: "202311",
                },
            ];
        }
        return res;
    });
}
/**
 * 客货对比
 */
export function truckornot(params) {
    return axios.get(`${api}/truckornot`, { params }).then((res) => {
        if (
            params.dimension === "1551973630102081536" ||
            params.dimension === "401" ||
            params.dimension === "YN"
        ) {
            res.msgContent = [
                {
                    cartype: "货车",
                    feeSum: 0,
                    feeSumPer: 0,
                    feeSumSum: 0,
                    flowCount: 1082,
                    flowCountPer: 0.1727,
                    flowCountSum: 6266,
                    orgCode: params.dimension,
                    orgName: "",
                    timeFlag: "20231123",
                },
                {
                    cartype: "客车",
                    feeSum: 0,
                    feeSumPer: 0,
                    feeSumSum: 0,
                    flowCount: 5149,
                    flowCountPer: 0.8217,
                    flowCountSum: 6266,
                    orgCode: params.dimension,
                    orgName: "",
                    timeFlag: "20231123",
                },
                {
                    cartype: "其他",
                    feeSum: 0,
                    feeSumPer: 0,
                    feeSumSum: 0,
                    flowCount: 35,
                    flowCountPer: 0.0056,
                    flowCountSum: 6266,
                    orgCode: params.dimension,
                    orgName: "",
                    timeFlag: "20231123",
                },
            ];
        }
        return res;
    });
}
/**
 * 现金 非现金
 */
export function cashornot(params) {
    return axios.get(`${api}/cashornot`, { params }).then((res) => {
        if (
            params.dimension === "1551973630102081536" ||
            params.dimension === "401" ||
            params.dimension === "YN"
        ) {
            res.msgContent = [
                {
                    payAmount: 2.27,
                    payCount: 0,
                    payType: "现金",
                    payTypeCode: "0",
                },
                {
                    payAmount: 10.72,
                    payCount: 0,
                    payType: "记账支付",
                    payTypeCode: "1",
                },
                {
                    payAmount: 5.36,
                    payCount: 0,
                    payType: "钱包支付",
                    payTypeCode: "2",
                },
                {
                    payAmount: 16.29,
                    payCount: 0,
                    payType: "移动支付",
                    payTypeCode: "3",
                },
            ];
        }
        return res;
    });
}

/**
 * 实时收入
 */
export function getRedisData(params) {
    return axios.get(`${api}/getRedisData`, { params });
}
// 获取一些地址
export function getLinke(params) {
    return axios.get(
        `/bizapi1/http-server-base/publish/base-v1/systemUrl`,
        params
    );
}
//救援点信息
export function rescuePointInfo(params) {
    return axios.get(`${api}/rescuePointInfo`, params);
}

// 非现金
export function cashorNotFlow(params) {
    return axios.get(`${api}/cashorNotFlow`, { params }).then((res) => {
        if (
            params.dimension === "1551973630102081536" ||
            params.dimension === "401" ||
            params.dimension === "YN"
        ) {
            res.msgContent = [
                {
                    cashFlowCount: 1345200,
                    notcashFlowCount: 998000,
                },
            ];
        }
        return res;
    });
}

// 实时数据
// level=1&dimension=CQ&timeFlag=year
export function getLiveData(params) {
    return axios.get(`/bizapi1/http-server-redis/highway-charge/getTradeCache`, {
        params,
    });
}
// 新的实时数据
export function getLiveDatas(params) {
    return axios.get(`${api}/gateQingFenFeeFlow`, { params });
}

// 新的实时数据
export function getEnExFlowRealTime(params) {
    return axios.get(`${Newapi}/enExFlowRealTime`, { params });
}

// 预清分数据 新接口
export function getQingfenAmountNew(params) {
    return axios.get(`${api}/qingfenAmountNew`, { params }).then((res) => {
        if (
            params.dimension === "1551973630102081536" ||
            params.dimension === "401" ||
            params.dimension === "YN"
        ) {
            //   res.msgContent[0].feesum = 1859.0604;
            res.msgContent[0].feesum = 259.0604;
        }
        return res;
    });
}
