import type { Ref } from 'vue';
import type { BaseOptions, BaseResult, FormatOptions, FRPlaceholderType } from './core/types';
import type { IService } from './core/utils/types';
export interface PaginationResult<R, P extends unknown[]> extends Omit<BaseResult<R, P>, 'queries' | 'reset'> {
    current: Ref<number>;
    pageSize: Ref<number>;
    total: Ref<number>;
    totalPage: Ref<number>;
    reloading: Ref<boolean>;
    changeCurrent: (current: number) => void;
    changePageSize: (pageSize: number) => void;
    changePagination: (current: number, pageSize: number) => void;
    reload: () => void;
}
export interface PaginationExtendsOption {
    pagination?: {
        currentKey?: string;
        pageSizeKey?: string;
        totalKey?: string;
        totalPageKey?: string;
    };
}
export interface PaginationFormatOptions<R, P extends unknown[], FR> extends Omit<FormatOptions<R, P, FR>, 'queryKey'>, PaginationExtendsOption {
}
export interface PaginationBaseOptions<R, P extends unknown[]> extends Omit<BaseOptions<R, P>, 'queryKey'>, PaginationExtendsOption {
}
export declare type PaginationMixinOptions<R, P extends unknown[], FR> = PaginationBaseOptions<R, P> | PaginationFormatOptions<R, P, FR>;
declare function usePagination<R, P extends unknown[] = any>(service: IService<R, P>): PaginationResult<R, P>;
declare function usePagination<R, P extends unknown[] = any, FR = FRPlaceholderType>(service: IService<R, P>, options: PaginationFormatOptions<R, P, FR>): PaginationResult<FR, P>;
declare function usePagination<R, P extends unknown[] = any>(service: IService<R, P>, options: PaginationBaseOptions<R, P>): PaginationResult<R, P>;
export default usePagination;
