# @turf/triangle-grid

<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

## triangleGrid

Takes a bounding box and a cell depth and returns a set of triangular [polygons][1] in a grid.

**Parameters**

-   `bbox` **[Array][2]&lt;[number][3]>** extent in [minX, minY, maxX, maxY] order
-   `cellSide` **[number][3]** dimension of each cell
-   `options` **[Object][4]** Optional parameters (optional, default `{}`)
    -   `options.units` **[string][5]** used in calculating cellSide, can be degrees, radians, miles, or kilometers (optional, default `'kilometers'`)
    -   `options.mask` **[Feature][6]&lt;[Polygon][7]>?** if passed a Polygon or MultiPolygon, the grid Points will be created only inside it
    -   `options.properties` **[Object][4]** passed to each point of the grid (optional, default `{}`)

**Examples**

```javascript
var bbox = [-95, 30 ,-85, 40];
var cellSide = 50;
var options = {units: 'miles'};

var triangleGrid = turf.triangleGrid(bbox, cellSide, options);

//addToMap
var addToMap = [triangleGrid];
```

Returns **[FeatureCollection][8]&lt;[Polygon][7]>** grid of polygons

[1]: https://tools.ietf.org/html/rfc7946#section-3.1.6

[2]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Array

[3]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Number

[4]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object

[5]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/String

[6]: https://tools.ietf.org/html/rfc7946#section-3.2

[7]: https://tools.ietf.org/html/rfc7946#section-3.1.6

[8]: https://tools.ietf.org/html/rfc7946#section-3.3

<!-- This file is automatically generated. Please don't edit it directly:
if you find an error, edit the source file (likely index.js), and re-run
./scripts/generate-readmes in the turf project. -->

---

This module is part of the [Turfjs project](http://turfjs.org/), an open source
module collection dedicated to geographic algorithms. It is maintained in the
[Turfjs/turf](https://github.com/Turfjs/turf) repository, where you can create
PRs and issues.

### Installation

Install this module individually:

```sh
$ npm install @turf/triangle-grid
```

Or install the Turf module that includes it as a function:

```sh
$ npm install @turf/turf
```
