const arrCommonProxyPath = [
    "^/http-server-yonyu",
    "^/http-server-kpi",
    "^/http-server-yygl",
    "^/http-server-yhgl",
    "^/http-server-charge-management",
    "^/sys",
    "^/user",
    "^/external",
    "^/weather",
    "^/zsj",
    "^/xcjy",
];

export default (env) => {
    const {
        VITE_SERVICE_BASE,
        VITE_IOT_BASE,
        VITE_APP_WEB_BASE,
        VITE_APP_SERVICE_BASE_1,
        VITE_APP_SERVICE_BASE_2,
        VITE_URI_MINEMAP_BASE,
        VITE_APP_YYGL_SERVICE_BASE,
        VITE_PORTAL_URL,
        VITE_XXJY_URL
    } = env;
    const proxyTable = {
        "^/http-server-charge-management/wsocket": {
            target: VITE_SERVICE_BASE,
            changeOrigin: true,
            ws: true,
        },
        // 消息服务的推送转发
        // "^/wsmsg": {
        //   target: VITE_SERVICE_BASE,
        //   secure: false,
        //   changeOrigin: true,
        //   ws: true,
        //   // 实际地址没有这个wsmsg前缀
        //   pathRewrite: {
        //     "^/wsmsg": "",
        //   },
        //   // 解决ws代理断开后会导致dev server down掉的问题
        //   onProxyReqWs(proxyReq, req, socket, options, head) {
        //     socket.on("error", (err) => {
        //       console.error(err);
        //     });
        //   },
        // },
        "^/user": {
            target: VITE_APP_WEB_BASE,
            secure: false,
            changeOrigin: true,
        },
        "^/weather": {
            target: VITE_APP_WEB_BASE,
            secure: false,
            changeOrigin: true,
            //   rewrite: path => path.replace(/^\/weatherapi/, ''),
        },
        "^/gis-cqjc-maint": {
            target: VITE_APP_WEB_BASE,
            secure: false,
            changeOrigin: true,
        },
        "/bizapi1/": {
            target: VITE_APP_SERVICE_BASE_1,
            changeOrigin: true,
            rewrite: (path) => path.replace("/bizapi1", ""),
        },
        "/bizapi2/": {
            target: VITE_APP_SERVICE_BASE_2,
            changeOrigin: true,
            rewrite: (path) => path.replace("/bizapi2", ""),
        },
        "^/yyglapi/": {
            target: VITE_APP_YYGL_SERVICE_BASE,
            changeOrigin: true,
            rewrite: (path) => path.replace("/yyglapi", "/bizapi"),
        },
        "^/minemapapi": {
            target: VITE_URI_MINEMAP_BASE,
            secure: false,
            changeOrigin: true,
        },
        "^/manage": {
            target: VITE_IOT_BASE,
            secure: false,
            changeOrigin: true,
        },
        "^/video": {
            target: VITE_IOT_BASE,
            secure: false,
            changeOrigin: true,
        },
        "^/zsj": {
            target: VITE_PORTAL_URL,
            secure: false,
            changeOrigin: true,
            rewrite: (path) => path.replace("/zsj", ""),
        },
        "^/xcjy": {
            target: VITE_XXJY_URL,
            secure: false,
            changeOrigin: true,
            rewrite: (path) => path.replace("/xcjy", ""),
        },
    };
    arrCommonProxyPath.forEach((item) => {
        if (proxyTable[item]) {
            return;
        }
        proxyTable[item] = {
            target: VITE_SERVICE_BASE,
            changeOrigin: true,
        };
    });
    return proxyTable;
};
